/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.client.impl;

import io.deephaven.api.ColumnName;
import io.deephaven.api.Pair;
import io.deephaven.api.Strings;
import io.deephaven.api.updateby.BadDataBehavior;
import io.deephaven.api.updateby.ColumnUpdateOperation;
import io.deephaven.api.updateby.DeltaControl;
import io.deephaven.api.updateby.OperationControl;
import io.deephaven.api.updateby.UpdateByControl;
import io.deephaven.api.updateby.UpdateByOperation;
import io.deephaven.api.updateby.spec.CumMinMaxSpec;
import io.deephaven.api.updateby.spec.CumProdSpec;
import io.deephaven.api.updateby.spec.CumSumSpec;
import io.deephaven.api.updateby.spec.DeltaSpec;
import io.deephaven.api.updateby.spec.EmMinMaxSpec;
import io.deephaven.api.updateby.spec.EmStdSpec;
import io.deephaven.api.updateby.spec.EmaSpec;
import io.deephaven.api.updateby.spec.EmsSpec;
import io.deephaven.api.updateby.spec.FillBySpec;
import io.deephaven.api.updateby.spec.RollingAvgSpec;
import io.deephaven.api.updateby.spec.RollingCountSpec;
import io.deephaven.api.updateby.spec.RollingFormulaSpec;
import io.deephaven.api.updateby.spec.RollingGroupSpec;
import io.deephaven.api.updateby.spec.RollingMinMaxSpec;
import io.deephaven.api.updateby.spec.RollingProductSpec;
import io.deephaven.api.updateby.spec.RollingStdSpec;
import io.deephaven.api.updateby.spec.RollingSumSpec;
import io.deephaven.api.updateby.spec.RollingWAvgSpec;
import io.deephaven.api.updateby.spec.UpdateBySpec;
import io.deephaven.api.updateby.spec.WindowScale;
import io.deephaven.proto.backplane.grpc.MathContext;
import io.deephaven.proto.backplane.grpc.UpdateByDeltaOptions;
import io.deephaven.proto.backplane.grpc.UpdateByEmOptions;
import io.deephaven.proto.backplane.grpc.UpdateByNullBehavior;
import io.deephaven.proto.backplane.grpc.UpdateByRequest;
import io.deephaven.proto.backplane.grpc.UpdateByWindowScale;
import io.deephaven.qst.table.UpdateByTable;
import java.math.MathContext;
import java.math.RoundingMode;

class UpdateByBuilder {
    UpdateByBuilder() {
    }

    public static UpdateByRequest.Builder adapt(UpdateByTable updateByTable) {
        UpdateByRequest.Builder builder = UpdateByRequest.newBuilder();
        updateByTable.control().map(UpdateByBuilder::adapt).ifPresent(arg_0 -> ((UpdateByRequest.Builder)builder).setOptions(arg_0));
        for (UpdateByOperation operation : updateByTable.operations()) {
            builder.addOperations(UpdateByBuilder.adapt(operation));
        }
        for (ColumnName groupByColumn : updateByTable.groupByColumns()) {
            builder.addGroupByColumns(groupByColumn.name());
        }
        return builder;
    }

    static UpdateByRequest.UpdateByOperation adapt(UpdateByOperation clause) {
        return (UpdateByRequest.UpdateByOperation)clause.walk((UpdateByOperation.Visitor)OperationVisitor.INSTANCE);
    }

    private static UpdateByRequest.UpdateByOperation.UpdateByColumn adapt(ColumnUpdateOperation columnUpdate) {
        UpdateByRequest.UpdateByOperation.UpdateByColumn.Builder builder = UpdateByRequest.UpdateByOperation.UpdateByColumn.newBuilder().setSpec(UpdateByBuilder.adapt(columnUpdate.spec()));
        for (Pair pair : columnUpdate.columns()) {
            builder.addMatchPairs(Strings.of((Pair)pair));
        }
        return builder.build();
    }

    static UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec adapt(UpdateBySpec spec) {
        return (UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec)spec.walk((UpdateBySpec.Visitor)SpecVisitor.INSTANCE);
    }

    static UpdateByRequest.UpdateByOptions adapt(UpdateByControl control) {
        UpdateByRequest.UpdateByOptions.Builder builder = UpdateByRequest.UpdateByOptions.newBuilder();
        Boolean useRedirection = control.useRedirection();
        if (useRedirection != null) {
            builder.setUseRedirection(useRedirection.booleanValue());
        }
        control.chunkCapacity().ifPresent(arg_0 -> ((UpdateByRequest.UpdateByOptions.Builder)builder).setChunkCapacity(arg_0));
        control.maxStaticSparseMemoryOverhead().ifPresent(arg_0 -> ((UpdateByRequest.UpdateByOptions.Builder)builder).setMaxStaticSparseMemoryOverhead(arg_0));
        control.initialHashTableSize().ifPresent(arg_0 -> ((UpdateByRequest.UpdateByOptions.Builder)builder).setInitialHashTableSize(arg_0));
        control.maximumLoadFactor().ifPresent(arg_0 -> ((UpdateByRequest.UpdateByOptions.Builder)builder).setMaximumLoadFactor(arg_0));
        control.targetLoadFactor().ifPresent(arg_0 -> ((UpdateByRequest.UpdateByOptions.Builder)builder).setTargetLoadFactor(arg_0));
        control.mathContext().map(UpdateByBuilder::adapt).ifPresent(arg_0 -> ((UpdateByRequest.UpdateByOptions.Builder)builder).setMathContext(arg_0));
        return builder.build();
    }

    static io.deephaven.proto.backplane.grpc.MathContext adapt(MathContext mathContext) {
        return io.deephaven.proto.backplane.grpc.MathContext.newBuilder().setPrecision(mathContext.getPrecision()).setRoundingMode(UpdateByBuilder.adapt(mathContext.getRoundingMode())).build();
    }

    private static MathContext.RoundingMode adapt(RoundingMode roundingMode) {
        switch (roundingMode) {
            case UP: {
                return MathContext.RoundingMode.UP;
            }
            case DOWN: {
                return MathContext.RoundingMode.DOWN;
            }
            case CEILING: {
                return MathContext.RoundingMode.CEILING;
            }
            case FLOOR: {
                return MathContext.RoundingMode.FLOOR;
            }
            case HALF_UP: {
                return MathContext.RoundingMode.HALF_UP;
            }
            case HALF_DOWN: {
                return MathContext.RoundingMode.HALF_DOWN;
            }
            case HALF_EVEN: {
                return MathContext.RoundingMode.HALF_EVEN;
            }
            case UNNECESSARY: {
                return MathContext.RoundingMode.UNNECESSARY;
            }
        }
        throw new IllegalArgumentException("Unexpected rounding mode: " + (Object)((Object)roundingMode));
    }

    private static enum SpecVisitor implements UpdateBySpec.Visitor<UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec>
    {
        INSTANCE;


        private static io.deephaven.proto.backplane.grpc.BadDataBehavior adapt(BadDataBehavior b) {
            switch (b) {
                case RESET: {
                    return io.deephaven.proto.backplane.grpc.BadDataBehavior.RESET;
                }
                case SKIP: {
                    return io.deephaven.proto.backplane.grpc.BadDataBehavior.SKIP;
                }
                case THROW: {
                    return io.deephaven.proto.backplane.grpc.BadDataBehavior.THROW;
                }
                case POISON: {
                    return io.deephaven.proto.backplane.grpc.BadDataBehavior.POISON;
                }
            }
            throw new IllegalArgumentException("Unexpected BadDataBehavior: " + b);
        }

        private static UpdateByEmOptions adapt(OperationControl control) {
            UpdateByEmOptions.Builder builder = UpdateByEmOptions.newBuilder();
            control.onNullValue().map(SpecVisitor::adapt).ifPresent(arg_0 -> ((UpdateByEmOptions.Builder)builder).setOnNullValue(arg_0));
            control.onNanValue().map(SpecVisitor::adapt).ifPresent(arg_0 -> ((UpdateByEmOptions.Builder)builder).setOnNanValue(arg_0));
            control.onNullTime().map(SpecVisitor::adapt).ifPresent(arg_0 -> ((UpdateByEmOptions.Builder)builder).setOnNullTime(arg_0));
            control.onNegativeDeltaTime().map(SpecVisitor::adapt).ifPresent(arg_0 -> ((UpdateByEmOptions.Builder)builder).setOnNegativeDeltaTime(arg_0));
            control.onZeroDeltaTime().map(SpecVisitor::adapt).ifPresent(arg_0 -> ((UpdateByEmOptions.Builder)builder).setOnZeroDeltaTime(arg_0));
            control.bigValueContext().map(UpdateByBuilder::adapt).ifPresent(arg_0 -> ((UpdateByEmOptions.Builder)builder).setBigValueContext(arg_0));
            return builder.build();
        }

        private static UpdateByWindowScale adapt(WindowScale windowScale) {
            if (windowScale.isTimeBased()) {
                return UpdateByWindowScale.newBuilder().setTime(UpdateByWindowScale.UpdateByWindowTime.newBuilder().setColumn(windowScale.timestampCol()).setNanos(windowScale.timeUnits()).build()).build();
            }
            return UpdateByWindowScale.newBuilder().setTicks(UpdateByWindowScale.UpdateByWindowTicks.newBuilder().setTicks(windowScale.tickUnits()).build()).build();
        }

        private static UpdateByDeltaOptions adapt(DeltaControl control) {
            UpdateByNullBehavior nullBehavior;
            switch (control.nullBehavior()) {
                case ValueDominates: {
                    nullBehavior = UpdateByNullBehavior.VALUE_DOMINATES;
                    break;
                }
                case ZeroDominates: {
                    nullBehavior = UpdateByNullBehavior.ZERO_DOMINATES;
                    break;
                }
                default: {
                    nullBehavior = UpdateByNullBehavior.NULL_DOMINATES;
                }
            }
            return UpdateByDeltaOptions.newBuilder().setNullBehavior(nullBehavior).build();
        }

        public UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec visit(EmaSpec spec) {
            UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEma.Builder builder = UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEma.newBuilder().setWindowScale(SpecVisitor.adapt(spec.windowScale()));
            spec.control().map(SpecVisitor::adapt).ifPresent(arg_0 -> ((UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEma.Builder)builder).setOptions(arg_0));
            return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setEma(builder.build()).build();
        }

        public UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec visit(EmsSpec spec) {
            UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEms.Builder builder = UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEms.newBuilder().setWindowScale(SpecVisitor.adapt(spec.windowScale()));
            spec.control().map(SpecVisitor::adapt).ifPresent(arg_0 -> ((UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEms.Builder)builder).setOptions(arg_0));
            return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setEms(builder.build()).build();
        }

        public UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec visit(EmMinMaxSpec spec) {
            if (spec.isMax()) {
                UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEmMax.Builder builder = UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEmMax.newBuilder().setWindowScale(SpecVisitor.adapt(spec.windowScale()));
                spec.control().map(SpecVisitor::adapt).ifPresent(arg_0 -> ((UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEmMax.Builder)builder).setOptions(arg_0));
                return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setEmMax(builder.build()).build();
            }
            UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEmMin.Builder builder = UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEmMin.newBuilder().setWindowScale(SpecVisitor.adapt(spec.windowScale()));
            spec.control().map(SpecVisitor::adapt).ifPresent(arg_0 -> ((UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEmMin.Builder)builder).setOptions(arg_0));
            return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setEmMin(builder.build()).build();
        }

        public UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec visit(FillBySpec spec) {
            return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setFill(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByFill.getDefaultInstance()).build();
        }

        public UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec visit(CumSumSpec spec) {
            return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setSum(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByCumulativeSum.getDefaultInstance()).build();
        }

        public UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec visit(CumMinMaxSpec spec) {
            if (spec.isMax()) {
                return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setMax(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByCumulativeMax.getDefaultInstance()).build();
            }
            return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setMin(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByCumulativeMin.getDefaultInstance()).build();
        }

        public UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec visit(CumProdSpec spec) {
            return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setProduct(UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByCumulativeProduct.getDefaultInstance()).build();
        }

        public UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec visit(EmStdSpec spec) {
            UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEmStd.Builder builder = UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEmStd.newBuilder().setWindowScale(SpecVisitor.adapt(spec.windowScale()));
            spec.control().map(SpecVisitor::adapt).ifPresent(arg_0 -> ((UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByEmStd.Builder)builder).setOptions(arg_0));
            return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setEmStd(builder.build()).build();
        }

        public UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec visit(DeltaSpec spec) {
            UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByDelta.Builder builder = UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByDelta.newBuilder();
            spec.deltaControl().map(SpecVisitor::adapt).ifPresent(arg_0 -> ((UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByDelta.Builder)builder).setOptions(arg_0));
            return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setDelta(builder.build()).build();
        }

        public UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec visit(RollingSumSpec rs) {
            UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingSum.Builder builder = UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingSum.newBuilder().setReverseWindowScale(SpecVisitor.adapt(rs.revWindowScale())).setForwardWindowScale(SpecVisitor.adapt(rs.fwdWindowScale()));
            return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setRollingSum(builder.build()).build();
        }

        public UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec visit(RollingGroupSpec rs) {
            UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingGroup.Builder builder = UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingGroup.newBuilder().setReverseWindowScale(SpecVisitor.adapt(rs.revWindowScale())).setForwardWindowScale(SpecVisitor.adapt(rs.fwdWindowScale()));
            return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setRollingGroup(builder.build()).build();
        }

        public UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec visit(RollingAvgSpec rs) {
            UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingAvg.Builder builder = UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingAvg.newBuilder().setReverseWindowScale(SpecVisitor.adapt(rs.revWindowScale())).setForwardWindowScale(SpecVisitor.adapt(rs.fwdWindowScale()));
            return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setRollingAvg(builder.build()).build();
        }

        public UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec visit(RollingMinMaxSpec rs) {
            if (rs.isMax()) {
                UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingMax.Builder builder = UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingMax.newBuilder().setReverseWindowScale(SpecVisitor.adapt(rs.revWindowScale())).setForwardWindowScale(SpecVisitor.adapt(rs.fwdWindowScale()));
                return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setRollingMax(builder.build()).build();
            }
            UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingMin.Builder builder = UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingMin.newBuilder().setReverseWindowScale(SpecVisitor.adapt(rs.revWindowScale())).setForwardWindowScale(SpecVisitor.adapt(rs.fwdWindowScale()));
            return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setRollingMin(builder.build()).build();
        }

        public UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec visit(RollingProductSpec rs) {
            UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingProduct.Builder builder = UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingProduct.newBuilder().setReverseWindowScale(SpecVisitor.adapt(rs.revWindowScale())).setForwardWindowScale(SpecVisitor.adapt(rs.fwdWindowScale()));
            return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setRollingProduct(builder.build()).build();
        }

        public UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec visit(RollingCountSpec rs) {
            UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingCount.Builder builder = UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingCount.newBuilder().setReverseWindowScale(SpecVisitor.adapt(rs.revWindowScale())).setForwardWindowScale(SpecVisitor.adapt(rs.fwdWindowScale()));
            return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setRollingCount(builder.build()).build();
        }

        public UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec visit(RollingStdSpec rs) {
            UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingStd.Builder builder = UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingStd.newBuilder().setReverseWindowScale(SpecVisitor.adapt(rs.revWindowScale())).setForwardWindowScale(SpecVisitor.adapt(rs.fwdWindowScale()));
            return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setRollingStd(builder.build()).build();
        }

        public UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec visit(RollingWAvgSpec rs) {
            UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingWAvg.Builder builder = UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingWAvg.newBuilder().setReverseWindowScale(SpecVisitor.adapt(rs.revWindowScale())).setForwardWindowScale(SpecVisitor.adapt(rs.fwdWindowScale())).setWeightColumn(rs.weightCol());
            return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setRollingWavg(builder.build()).build();
        }

        public UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec visit(RollingFormulaSpec rs) {
            UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingFormula.Builder builder = UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.UpdateByRollingFormula.newBuilder().setReverseWindowScale(SpecVisitor.adapt(rs.revWindowScale())).setForwardWindowScale(SpecVisitor.adapt(rs.fwdWindowScale())).setFormula(rs.formula()).setParamToken(rs.paramToken());
            return UpdateByRequest.UpdateByOperation.UpdateByColumn.UpdateBySpec.newBuilder().setRollingFormula(builder.build()).build();
        }
    }

    private static enum OperationVisitor implements UpdateByOperation.Visitor<UpdateByRequest.UpdateByOperation>
    {
        INSTANCE;


        public UpdateByRequest.UpdateByOperation visit(ColumnUpdateOperation clause) {
            return UpdateByRequest.UpdateByOperation.newBuilder().setColumn(UpdateByBuilder.adapt(clause)).build();
        }
    }
}

