/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.jpy;

import io.deephaven.jpy.JpyConfigSource;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class JpyConfig {
    private final Path pythonHome;
    private final Path programName;
    private final Path pythonLib;
    private final Path jpyLib;
    private final Path jdlLib;
    private final List<Path> extraPaths;
    private final EnumSet<Flag> flags;

    private static void ensureAbsolute(Path path, String name) {
        if (path != null && !path.isAbsolute()) {
            throw new IllegalArgumentException(String.format("%s must be absolute, is '%s'", name, path));
        }
    }

    public JpyConfig(Path programName, Path pythonHome, Path pythonLib, Path jpyLib, Path jdlLib, List<Path> extraPaths, EnumSet<Flag> flags) {
        JpyConfig.ensureAbsolute(programName, "programName");
        JpyConfig.ensureAbsolute(pythonHome, "pythonHome");
        JpyConfig.ensureAbsolute(pythonLib, "pythonLib");
        JpyConfig.ensureAbsolute(jpyLib, "jpyLib");
        JpyConfig.ensureAbsolute(jdlLib, "jdlLib");
        if (jpyLib != null && jdlLib != null && !Objects.equals(jpyLib.getParent(), jdlLib.getParent())) {
            throw new IllegalArgumentException(String.format("jpy lib and jdl lib must be siblings, jpy is '%s', jdl is '%s', parents '%s' and '%s'", jpyLib, jdlLib, jpyLib.getParent(), jdlLib.getParent()));
        }
        this.programName = programName;
        this.pythonHome = pythonHome;
        this.pythonLib = pythonLib;
        this.jpyLib = jpyLib;
        this.jdlLib = jdlLib;
        this.extraPaths = Objects.requireNonNull(extraPaths);
        for (Path path : extraPaths) {
            Objects.requireNonNull(path);
        }
        this.flags = Objects.requireNonNull(flags);
    }

    public boolean isEmpty() {
        return this.programName == null && this.pythonHome == null && this.pythonLib == null && this.jpyLib == null && this.jdlLib == null && this.extraPaths.isEmpty() && this.flags.isEmpty();
    }

    public Optional<Path> getPythonHome() {
        return Optional.ofNullable(this.pythonHome);
    }

    public Optional<Path> getProgramName() {
        return Optional.ofNullable(this.programName);
    }

    public Optional<Path> getPythonLib() {
        return Optional.ofNullable(this.pythonLib);
    }

    public Optional<Path> getJpyLib() {
        return Optional.ofNullable(this.jpyLib);
    }

    public Optional<Path> getJdlLib() {
        return Optional.ofNullable(this.jdlLib);
    }

    public List<Path> getExtraPaths() {
        return this.extraPaths;
    }

    public EnumSet<Flag> getFlags() {
        return this.flags;
    }

    public JpyConfigSource asSource() {
        return new AsSource();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JpyConfig jpyConfig = (JpyConfig)o;
        if (this.pythonHome != null ? !this.pythonHome.equals(jpyConfig.pythonHome) : jpyConfig.pythonHome != null) {
            return false;
        }
        if (this.programName != null ? !this.programName.equals(jpyConfig.programName) : jpyConfig.programName != null) {
            return false;
        }
        if (this.pythonLib != null ? !this.pythonLib.equals(jpyConfig.pythonLib) : jpyConfig.pythonLib != null) {
            return false;
        }
        if (this.jpyLib != null ? !this.jpyLib.equals(jpyConfig.jpyLib) : jpyConfig.jpyLib != null) {
            return false;
        }
        if (this.jdlLib != null ? !this.jdlLib.equals(jpyConfig.jdlLib) : jpyConfig.jdlLib != null) {
            return false;
        }
        if (!this.extraPaths.equals(jpyConfig.extraPaths)) {
            return false;
        }
        return this.flags.equals(jpyConfig.flags);
    }

    public int hashCode() {
        int result = this.pythonHome != null ? this.pythonHome.hashCode() : 0;
        result = 31 * result + (this.programName != null ? this.programName.hashCode() : 0);
        result = 31 * result + (this.pythonLib != null ? this.pythonLib.hashCode() : 0);
        result = 31 * result + (this.jpyLib != null ? this.jpyLib.hashCode() : 0);
        result = 31 * result + (this.jdlLib != null ? this.jdlLib.hashCode() : 0);
        result = 31 * result + this.extraPaths.hashCode();
        result = 31 * result + this.flags.hashCode();
        return result;
    }

    class AsSource
    implements JpyConfigSource {
        AsSource() {
        }

        @Override
        public Optional<String> getFlags() {
            return JpyConfig.this.flags.isEmpty() ? Optional.empty() : Optional.of(JpyConfig.this.flags.stream().map(Enum::name).collect(Collectors.joining(",")));
        }

        @Override
        public Optional<String> getExtraPaths() {
            return JpyConfig.this.extraPaths.isEmpty() ? Optional.empty() : Optional.of(JpyConfig.this.extraPaths.stream().map(Path::toString).collect(Collectors.joining(",")));
        }

        @Override
        public Optional<String> getPythonHome() {
            return Optional.ofNullable(JpyConfig.this.pythonHome).map(Path::toString);
        }

        @Override
        public Optional<String> getProgramName() {
            return Optional.ofNullable(JpyConfig.this.programName).map(Path::toString);
        }

        @Override
        public Optional<String> getPythonLib() {
            return Optional.ofNullable(JpyConfig.this.pythonLib).map(Path::toString);
        }

        @Override
        public Optional<String> getJpyLib() {
            return Optional.ofNullable(JpyConfig.this.jpyLib).map(Path::toString);
        }

        @Override
        public Optional<String> getJdlLib() {
            return Optional.ofNullable(JpyConfig.this.jdlLib).map(Path::toString);
        }
    }

    public static enum Flag {
        OFF(0),
        TYPE(1),
        METH(2),
        EXEC(4),
        MEM(8),
        JVM(16),
        ERR(32),
        ALL(255);

        public final int bitset;

        private Flag(int bitset) {
            this.bitset = bitset;
        }

        public int getBitset() {
            return this.bitset;
        }
    }
}

