/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.jpy;

import io.deephaven.jpy.JpyConfigSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class JpyConfigFromSubprocess {
    private static final String PYTHON_NAME_PROPERTY = "deephaven.python.name";
    private static final String VIRTUAL_ENV = "VIRTUAL_ENV";
    private static final String PYTHON_NAME = "python3";

    public static String getPythonName() {
        String deephavenPythonName = System.getProperty(PYTHON_NAME_PROPERTY);
        if (deephavenPythonName != null) {
            return deephavenPythonName;
        }
        String virtualEnv = System.getenv(VIRTUAL_ENV);
        if (virtualEnv != null) {
            return virtualEnv + "/bin/python";
        }
        return PYTHON_NAME;
    }

    public static JpyConfigSource fromSubprocess(Duration timeout) throws IOException, InterruptedException, TimeoutException {
        return JpyConfigFromSubprocess.fromSubprocess(JpyConfigFromSubprocess.getPythonName(), timeout);
    }

    public static JpyConfigSource fromSubprocess(String pythonName, Duration timeout) throws IOException, InterruptedException, TimeoutException {
        return new JpyConfigSource.FromProperties(JpyConfigFromSubprocess.properties(pythonName, timeout));
    }

    private static Properties properties(String pythonName, Duration timeout) throws IOException, InterruptedException, TimeoutException {
        Process process;
        try (InputStream in = JpyConfigFromSubprocess.class.getResourceAsStream("introspect.py");){
            if (in == null) {
                throw new IllegalStateException("Expected to find introspect.py resource");
            }
            try {
                process = new ProcessBuilder(pythonName, "-").start();
            }
            catch (IOException e) {
                throw new IOException(String.format("Error starting python command '%s'", pythonName), e);
            }
            try (OutputStream out = process.getOutputStream();){
                JpyConfigFromSubprocess.transferTo(in, out);
            }
            catch (Throwable t) {
                process.destroy();
                throw t;
            }
        }
        try {
            if (!process.waitFor(timeout.toNanos(), TimeUnit.NANOSECONDS)) {
                throw new TimeoutException(String.format("Timed out while waiting for '%s' to complete", pythonName));
            }
        }
        catch (Throwable t) {
            process.destroy();
            throw t;
        }
        int exitValue = process.exitValue();
        if (exitValue != 0) {
            String error = JpyConfigFromSubprocess.readAllBytes(process.getErrorStream());
            if (error.contains("ModuleNotFoundError: No module named 'jpyutil'")) {
                throw new IllegalStateException(String.format("A Deephaven python environment has not been configured for '%s'. Please ensure that the appropriate Deephaven wheels have been installed.", pythonName));
            }
            throw new IllegalStateException(String.format("Unexpected error while starting python '%s': %s", pythonName, error));
        }
        Properties properties = new Properties();
        properties.load(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        return properties;
    }

    private static void transferTo(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer, 0, buffer.length)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    private static String readAllBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        JpyConfigFromSubprocess.transferTo(in, out);
        return out.toString("UTF-8");
    }
}

