/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.jpy;

import io.deephaven.jpy.JpyConfig;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;

public interface JpyConfigSource {
    public static final String JPY_FLAGS_PROP = "jpy.flags";
    public static final String JPY_EXTRA_PATHS_PROP = "jpy.extraPaths";
    public static final String JPY_PY_HOME_PROP = "jpy.pythonHome";
    public static final String JPY_PROGRAM_NAME_PROP = "jpy.programName";
    public static final String JPY_PY_LIB_PROP = "jpy.pythonLib";
    public static final String JPY_JPY_LIB_PROP = "jpy.jpyLib";
    public static final String JPY_JDL_LIB_PROP = "jpy.jdlLib";

    public Optional<String> getFlags();

    public Optional<String> getExtraPaths();

    public Optional<String> getPythonHome();

    public Optional<String> getProgramName();

    public Optional<String> getPythonLib();

    public Optional<String> getJpyLib();

    public Optional<String> getJdlLib();

    default public Map<String, String> asProperties() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        this.getFlags().ifPresent(v -> map.put(JPY_FLAGS_PROP, (String)v));
        this.getExtraPaths().ifPresent(v -> map.put(JPY_EXTRA_PATHS_PROP, (String)v));
        this.getPythonHome().ifPresent(v -> map.put(JPY_PY_HOME_PROP, (String)v));
        this.getProgramName().ifPresent(v -> map.put(JPY_PROGRAM_NAME_PROP, (String)v));
        this.getPythonLib().ifPresent(v -> map.put(JPY_PY_LIB_PROP, (String)v));
        this.getJpyLib().ifPresent(v -> map.put(JPY_JPY_LIB_PROP, (String)v));
        this.getJdlLib().ifPresent(v -> map.put(JPY_JDL_LIB_PROP, (String)v));
        return map;
    }

    default public EnumSet<JpyConfig.Flag> getFlagsSet() {
        EnumSet<JpyConfig.Flag> flags = EnumSet.noneOf(JpyConfig.Flag.class);
        this.getFlags().map(s -> s.split(",")).map(Stream::of).orElseGet(Stream::empty).map(String::trim).filter(s -> !s.isEmpty()).map(JpyConfig.Flag::valueOf).forEach(flags::add);
        return flags;
    }

    default public List<Path> getExtraPathsList() {
        ArrayList<Path> extraPaths = new ArrayList<Path>();
        this.getExtraPaths().map(s -> s.split(",")).map(Stream::of).orElseGet(Stream::empty).map(String::trim).filter(s -> !s.isEmpty()).map(x$0 -> Paths.get(x$0, new String[0])).forEachOrdered(extraPaths::add);
        return extraPaths;
    }

    default public JpyConfig asJpyConfig() {
        return new JpyConfig(JpyConfigSource.sanitize(this.getProgramName()), JpyConfigSource.sanitize(this.getPythonHome()), JpyConfigSource.sanitize(this.getPythonLib()), JpyConfigSource.sanitize(this.getJpyLib()), JpyConfigSource.sanitize(this.getJdlLib()), this.getExtraPathsList(), this.getFlagsSet());
    }

    public static Path sanitize(Optional<String> value) {
        return value.map(String::trim).filter(s -> !s.isEmpty()).map(x$0 -> Paths.get(x$0, new String[0])).orElse(null);
    }

    public static JpyConfigSource sysProps() {
        return new FromProperties(System.getProperties());
    }

    public static final class FromProperties
    implements JpyConfigSource {
        private final Properties properties;

        public FromProperties(Properties properties) {
            this.properties = Objects.requireNonNull(properties);
        }

        @Override
        public Optional<String> getFlags() {
            return Optional.ofNullable(this.properties.getProperty(JpyConfigSource.JPY_FLAGS_PROP));
        }

        @Override
        public Optional<String> getExtraPaths() {
            return Optional.ofNullable(this.properties.getProperty(JpyConfigSource.JPY_EXTRA_PATHS_PROP));
        }

        @Override
        public Optional<String> getPythonHome() {
            return Optional.ofNullable(this.properties.getProperty(JpyConfigSource.JPY_PY_HOME_PROP));
        }

        @Override
        public Optional<String> getProgramName() {
            return Optional.ofNullable(this.properties.getProperty(JpyConfigSource.JPY_PROGRAM_NAME_PROP));
        }

        @Override
        public Optional<String> getPythonLib() {
            return Optional.ofNullable(this.properties.getProperty(JpyConfigSource.JPY_PY_LIB_PROP));
        }

        @Override
        public Optional<String> getJpyLib() {
            return Optional.ofNullable(this.properties.getProperty(JpyConfigSource.JPY_JPY_LIB_PROP));
        }

        @Override
        public Optional<String> getJdlLib() {
            return Optional.ofNullable(this.properties.getProperty(JpyConfigSource.JPY_JDL_LIB_PROP));
        }
    }
}

