/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

import io.deephaven.util.ArrayType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface PrimitiveArrayType<T>
extends ArrayType<T> {
    public static Optional<PrimitiveArrayType<?>> lookupForPrimitiveType(Class<?> clazz) {
        return Optional.ofNullable((PrimitiveArrayType)Constants.primitiveTypeMap.get(clazz));
    }

    public static Optional<PrimitiveArrayType<?>> lookupForArrayType(Class<?> clazz) {
        return Optional.ofNullable((PrimitiveArrayType)Constants.arrayTypeMap.get(clazz));
    }

    public static Optional<PrimitiveArrayType<?>> lookupForObject(Object array) {
        return PrimitiveArrayType.lookupForArrayType(array.getClass());
    }

    public static List<PrimitiveArrayType<?>> types() {
        return Arrays.asList(PrimitiveArrayType.booleans(), PrimitiveArrayType.bytes(), PrimitiveArrayType.chars(), PrimitiveArrayType.shorts(), PrimitiveArrayType.ints(), PrimitiveArrayType.longs(), PrimitiveArrayType.floats(), PrimitiveArrayType.doubles());
    }

    public static Booleans booleans() {
        return Booleans.INSTANCE;
    }

    public static Bytes bytes() {
        return Bytes.INSTANCE;
    }

    public static Chars chars() {
        return Chars.INSTANCE;
    }

    public static Shorts shorts() {
        return Shorts.INSTANCE;
    }

    public static Ints ints() {
        return Ints.INSTANCE;
    }

    public static Longs longs() {
        return Longs.INSTANCE;
    }

    public static Floats floats() {
        return Floats.INSTANCE;
    }

    public static Doubles doubles() {
        return Doubles.INSTANCE;
    }

    public Class<?> getPrimitiveType();

    public <V extends Visitor> V walk(V var1);

    public static enum Doubles implements PrimitiveArrayType<double[]>
    {
        INSTANCE;


        @Override
        public Class<?> getPrimitiveType() {
            return Double.TYPE;
        }

        @Override
        public Class<double[]> getArrayType() {
            return double[].class;
        }

        @Override
        public int getLength(double[] array) {
            return array.length;
        }

        @Override
        public double[] newInstance(int len) {
            return new double[len];
        }

        @Override
        public void arrayCopy(double[] src, int srcPos, double[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public <V extends Visitor> V walk(V visitor) {
            visitor.visit(this);
            return visitor;
        }
    }

    public static enum Floats implements PrimitiveArrayType<float[]>
    {
        INSTANCE;


        @Override
        public Class<?> getPrimitiveType() {
            return Float.TYPE;
        }

        @Override
        public Class<float[]> getArrayType() {
            return float[].class;
        }

        @Override
        public int getLength(float[] array) {
            return array.length;
        }

        @Override
        public float[] newInstance(int len) {
            return new float[len];
        }

        @Override
        public void arrayCopy(float[] src, int srcPos, float[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public <V extends Visitor> V walk(V visitor) {
            visitor.visit(this);
            return visitor;
        }
    }

    public static enum Longs implements PrimitiveArrayType<long[]>
    {
        INSTANCE;


        @Override
        public Class<?> getPrimitiveType() {
            return Long.TYPE;
        }

        @Override
        public Class<long[]> getArrayType() {
            return long[].class;
        }

        @Override
        public int getLength(long[] array) {
            return array.length;
        }

        @Override
        public long[] newInstance(int len) {
            return new long[len];
        }

        @Override
        public void arrayCopy(long[] src, int srcPos, long[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public <V extends Visitor> V walk(V visitor) {
            visitor.visit(this);
            return visitor;
        }
    }

    public static enum Ints implements PrimitiveArrayType<int[]>
    {
        INSTANCE;


        @Override
        public Class<?> getPrimitiveType() {
            return Integer.TYPE;
        }

        @Override
        public Class<int[]> getArrayType() {
            return int[].class;
        }

        @Override
        public int getLength(int[] array) {
            return array.length;
        }

        @Override
        public int[] newInstance(int len) {
            return new int[len];
        }

        @Override
        public void arrayCopy(int[] src, int srcPos, int[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public <V extends Visitor> V walk(V visitor) {
            visitor.visit(this);
            return visitor;
        }
    }

    public static enum Shorts implements PrimitiveArrayType<short[]>
    {
        INSTANCE;


        @Override
        public Class<?> getPrimitiveType() {
            return Short.TYPE;
        }

        @Override
        public Class<short[]> getArrayType() {
            return short[].class;
        }

        @Override
        public int getLength(short[] array) {
            return array.length;
        }

        @Override
        public short[] newInstance(int len) {
            return new short[len];
        }

        @Override
        public void arrayCopy(short[] src, int srcPos, short[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public <V extends Visitor> V walk(V visitor) {
            visitor.visit(this);
            return visitor;
        }
    }

    public static enum Chars implements PrimitiveArrayType<char[]>
    {
        INSTANCE;


        @Override
        public Class<?> getPrimitiveType() {
            return Character.TYPE;
        }

        @Override
        public Class<char[]> getArrayType() {
            return char[].class;
        }

        @Override
        public int getLength(char[] array) {
            return array.length;
        }

        @Override
        public char[] newInstance(int len) {
            return new char[len];
        }

        @Override
        public void arrayCopy(char[] src, int srcPos, char[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public <V extends Visitor> V walk(V visitor) {
            visitor.visit(this);
            return visitor;
        }
    }

    public static enum Bytes implements PrimitiveArrayType<byte[]>
    {
        INSTANCE;


        @Override
        public Class<?> getPrimitiveType() {
            return Byte.TYPE;
        }

        @Override
        public Class<byte[]> getArrayType() {
            return byte[].class;
        }

        @Override
        public int getLength(byte[] array) {
            return array.length;
        }

        @Override
        public byte[] newInstance(int len) {
            return new byte[len];
        }

        @Override
        public void arrayCopy(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public <V extends Visitor> V walk(V visitor) {
            visitor.visit(this);
            return visitor;
        }
    }

    public static enum Booleans implements PrimitiveArrayType<boolean[]>
    {
        INSTANCE;


        @Override
        public Class<?> getPrimitiveType() {
            return Boolean.TYPE;
        }

        @Override
        public Class<boolean[]> getArrayType() {
            return boolean[].class;
        }

        @Override
        public int getLength(boolean[] array) {
            return array.length;
        }

        @Override
        public boolean[] newInstance(int len) {
            return new boolean[len];
        }

        @Override
        public void arrayCopy(boolean[] src, int srcPos, boolean[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public <V extends Visitor> V walk(V visitor) {
            visitor.visit(this);
            return visitor;
        }
    }

    public static interface Visitor {
        public void visit(Booleans var1);

        public void visit(Bytes var1);

        public void visit(Chars var1);

        public void visit(Shorts var1);

        public void visit(Ints var1);

        public void visit(Longs var1);

        public void visit(Floats var1);

        public void visit(Doubles var1);
    }

    public static class Constants {
        private static final Map<Class<?>, PrimitiveArrayType<?>> primitiveTypeMap = new HashMap();
        private static final Map<Class<?>, PrimitiveArrayType<?>> arrayTypeMap = new HashMap();

        static {
            for (PrimitiveArrayType<?> po : PrimitiveArrayType.types()) {
                if (primitiveTypeMap.put(po.getPrimitiveType(), po) != null) {
                    throw new IllegalStateException();
                }
                if (arrayTypeMap.put(po.getArrayType(), po) == null) continue;
                throw new IllegalStateException();
            }
        }
    }
}

