/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.jpy;

import io.deephaven.jpy.JpyConfig;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import org.jpy.PyLib;
import org.jpy.PyLibInitializer;

public class JpyConfigExt {
    private final JpyConfig config;
    private boolean initialized;

    public JpyConfigExt(JpyConfig config) {
        this.config = Objects.requireNonNull(config, "config");
        this.initialized = false;
    }

    private static String safeToString(Path path) {
        return path == null ? null : path.toString();
    }

    private static void format(StringBuilder logOutput, Path path) {
        logOutput.append(JpyConfigExt.safeToString(path));
    }

    private static <T> void format(StringBuilder logOutput, Collection<T> collection) {
        boolean first = true;
        for (T item : collection) {
            if (!first) {
                logOutput.append(',');
            }
            logOutput.append(item.toString());
            first = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPython() {
        Class<JpyConfigExt> clazz = JpyConfigExt.class;
        synchronized (JpyConfigExt.class) {
            if (PyLibInitializer.isPyLibInitialized()) {
                throw new IllegalStateException("PyLib has already been initialized");
            }
            if (this.initialized) {
                throw new IllegalStateException("Already initialized - this should not happen, unless there is some weird class unloading going on?");
            }
            PyLibInitializer.initPyLib((String)this.config.getPythonLib().map(Path::toString).orElse(null), (String)this.config.getJpyLib().map(Path::toString).orElse(null), (String)this.config.getJdlLib().map(Path::toString).orElse(null));
            this.initialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPython() {
        Class<JpyConfigExt> clazz = JpyConfigExt.class;
        synchronized (JpyConfigExt.class) {
            if (!PyLibInitializer.isPyLibInitialized()) {
                throw new IllegalStateException("PyLib has not been initialized");
            }
            if (!this.initialized) {
                throw new IllegalStateException("PyLib has been initialized, but not by the current JpyConfigExt!");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (PyLib.isPythonRunning()) {
                throw new IllegalStateException("Python is already running");
            }
            this.config.getProgramName().map(Path::toString).ifPresent(PyLib::setProgramName);
            this.config.getPythonHome().map(Path::toString).ifPresent(PyLib::setPythonHome);
            int bitset = JpyConfig.Flag.OFF.bitset;
            for (JpyConfig.Flag flag : this.config.getFlags()) {
                bitset |= flag.bitset;
            }
            PyLib.startPython((int)bitset, (String[])((String[])this.config.getExtraPaths().stream().map(Path::toString).toArray(String[]::new)));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPython(Duration cleanupTimeout) {
        Class<JpyConfigExt> clazz = JpyConfigExt.class;
        synchronized (JpyConfigExt.class) {
            if (!PyLibInitializer.isPyLibInitialized()) {
                throw new IllegalStateException("PyLib has not been initialized");
            }
            if (!this.initialized) {
                throw new IllegalStateException("PyLib has been initialized, but not by the current JpyConfigExt!");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (!PyLib.isPythonRunning()) {
                throw new IllegalStateException("Python is not running");
            }
            System.gc();
            PyLib.stopPython();
            if (PyLib.isPythonRunning()) {
                throw new IllegalStateException("Python did not stop!");
            }
            return;
        }
    }

    public void append(StringBuilder logOutput) {
        logOutput.append("flags=");
        JpyConfigExt.format(logOutput, this.config.getFlags());
        logOutput.append(",programName=");
        JpyConfigExt.format(logOutput, this.config.getProgramName().orElse(null));
        logOutput.append(",pythonHome=");
        JpyConfigExt.format(logOutput, this.config.getPythonHome().orElse(null));
        logOutput.append(",pythonLib=");
        JpyConfigExt.format(logOutput, this.config.getPythonLib().orElse(null));
        logOutput.append(",jpyLib=");
        JpyConfigExt.format(logOutput, this.config.getJpyLib().orElse(null));
        logOutput.append(",jdlLib=");
        JpyConfigExt.format(logOutput, this.config.getJdlLib().orElse(null));
        logOutput.append(",extras=");
        JpyConfigExt.format(logOutput, this.config.getExtraPaths());
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        this.append(sb);
        return sb.toString();
    }
}

