/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.jpy;

import io.deephaven.jpy.JpyConfig;
import io.deephaven.util.PrimitiveArrayType;
import java.util.EnumSet;
import java.util.Objects;
import org.jpy.PyModule;
import org.jpy.PyObject;

public final class JpyModule
implements AutoCloseable {
    private static final String ARRAY_METHOD_NAME = "array";
    private final PyModule module;
    private final PyObject diag;

    public static JpyModule create() {
        return new JpyModule(PyModule.importModule((String)"jpy"));
    }

    JpyModule(PyModule module) {
        this.module = module;
        this.diag = module.getAttribute("diag");
    }

    public int getFlags() {
        return (Integer)this.diag.getAttribute("flags", Integer.TYPE);
    }

    public void setFlags(EnumSet<JpyConfig.Flag> flags) {
        int f = 0;
        for (JpyConfig.Flag flag : flags) {
            f |= flag.bitset;
        }
        this.diag.setAttribute("flags", (Object)f);
    }

    public <T> ArrayOps<T> ops(PrimitiveArrayType<T> type) {
        return new BaseImpl<T>(type);
    }

    @Deprecated
    public PyObject boolean_array(boolean[] values) {
        return this.ops(PrimitiveArrayType.Booleans.INSTANCE).newPyCopy(values);
    }

    public boolean[] to_boolean_array(PyObject pyObject) {
        try (PyObject out = this.module.call(ARRAY_METHOD_NAME, new Object[]{"boolean", pyObject});){
            boolean[] blArray = (boolean[])out.getObjectValue();
            return blArray;
        }
    }

    @Override
    public void close() {
        this.diag.close();
        this.module.close();
    }

    private static class JpyArrayType
    implements PrimitiveArrayType.Visitor {
        private String out;

        private JpyArrayType() {
        }

        static String of(PrimitiveArrayType<?> ops) {
            return Objects.requireNonNull(ops.walk(new JpyArrayType()).out);
        }

        @Override
        public void visit(PrimitiveArrayType.Booleans booleans) {
            this.out = "boolean";
        }

        @Override
        public void visit(PrimitiveArrayType.Bytes bytes) {
            this.out = "byte";
        }

        @Override
        public void visit(PrimitiveArrayType.Chars chars) {
            this.out = "char";
        }

        @Override
        public void visit(PrimitiveArrayType.Shorts shorts) {
            this.out = "short";
        }

        @Override
        public void visit(PrimitiveArrayType.Ints ints) {
            this.out = "int";
        }

        @Override
        public void visit(PrimitiveArrayType.Longs longs) {
            this.out = "long";
        }

        @Override
        public void visit(PrimitiveArrayType.Floats floats) {
            this.out = "float";
        }

        @Override
        public void visit(PrimitiveArrayType.Doubles doubles) {
            this.out = "double";
        }
    }

    class BaseImpl<T>
    implements ArrayOps<T> {
        private final PrimitiveArrayType<T> type;

        BaseImpl(PrimitiveArrayType<T> type) {
            this.type = Objects.requireNonNull(type, "type");
        }

        @Override
        public PrimitiveArrayType<T> getType() {
            return this.type;
        }

        @Override
        public PyObject newPyCopy(T values) {
            return (PyObject)JpyModule.this.module.call(PyObject.class, JpyModule.ARRAY_METHOD_NAME, String.class, (Object)JpyArrayType.of(this.type), this.type.getArrayType(), values);
        }

        @Override
        public T newCopy(T values) {
            return (T)JpyModule.this.module.call(this.type.getArrayType(), JpyModule.ARRAY_METHOD_NAME, String.class, (Object)JpyArrayType.of(this.type), this.type.getArrayType(), values);
        }

        @Override
        public PyObject newPyInstance(int len) {
            return (PyObject)JpyModule.this.module.call(PyObject.class, JpyModule.ARRAY_METHOD_NAME, String.class, (Object)JpyArrayType.of(this.type), Integer.class, (Object)len);
        }

        @Override
        public T newInstance(int len) {
            return (T)JpyModule.this.module.call(this.type.getArrayType(), JpyModule.ARRAY_METHOD_NAME, String.class, (Object)JpyArrayType.of(this.type), Integer.class, (Object)len);
        }
    }

    public static interface ArrayOps<T> {
        public PrimitiveArrayType<T> getType();

        public PyObject newPyCopy(T var1);

        public T newCopy(T var1);

        public PyObject newPyInstance(int var1);

        public T newInstance(int var1);
    }
}

