/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.internal.log;

import java.util.Optional;

public final class Bootstrap {
    public static boolean isQuiet() {
        return Bootstrap.viaProperty().or(Bootstrap::viaEnvironment).map(Boolean::parseBoolean).orElse(false);
    }

    public static void log(Class<?> source, String message) {
        Bootstrap.printf("# %s: %s%n", source.getName(), message);
    }

    public static void printf(String format, Object ... args) {
        if (!Bootstrap.isQuiet()) {
            System.out.printf(format, args);
        }
    }

    private static Optional<String> viaProperty() {
        return Optional.ofNullable(System.getProperty("deephaven.quiet"));
    }

    private static Optional<String> viaEnvironment() {
        return Optional.ofNullable(System.getenv("DEEPHAVEN_QUIET"));
    }
}

