/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugin.js;

import io.deephaven.plugin.js.PathsPrefixes;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

@Generated(from="PathsPrefixes", generator="Immutables")
final class ImmutablePathsPrefixes
extends PathsPrefixes {
    private final Set<Path> prefixes;

    private ImmutablePathsPrefixes(Builder builder) {
        this.prefixes = ImmutablePathsPrefixes.createUnmodifiableSet(builder.prefixes);
    }

    @Override
    public Set<Path> prefixes() {
        return this.prefixes;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePathsPrefixes && this.equalTo(0, (ImmutablePathsPrefixes)another);
    }

    private boolean equalTo(int synthetic, ImmutablePathsPrefixes another) {
        return this.prefixes.equals(another.prefixes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.prefixes.hashCode();
        return h;
    }

    public String toString() {
        return "PathsPrefixes{prefixes=" + this.prefixes + "}";
    }

    private static ImmutablePathsPrefixes validate(ImmutablePathsPrefixes instance) {
        instance.checkPrefixesNonEmpty();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="PathsPrefixes", generator="Immutables")
    public static final class Builder
    implements PathsPrefixes.Builder {
        private final List<Path> prefixes = new ArrayList<Path>();

        private Builder() {
        }

        @Override
        public final Builder addPrefixes(Path element) {
            this.prefixes.add(Objects.requireNonNull(element, "prefixes element"));
            return this;
        }

        @Override
        public final Builder addPrefixes(Path ... elements) {
            for (Path element : elements) {
                this.prefixes.add(Objects.requireNonNull(element, "prefixes element"));
            }
            return this;
        }

        @Override
        public final Builder addAllPrefixes(Iterable<? extends Path> elements) {
            for (Path path : elements) {
                this.prefixes.add(Objects.requireNonNull(path, "prefixes element"));
            }
            return this;
        }

        @Override
        public ImmutablePathsPrefixes build() {
            return ImmutablePathsPrefixes.validate(new ImmutablePathsPrefixes(this));
        }
    }
}

