/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugin.js;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.plugin.Plugin;
import io.deephaven.plugin.PluginBase;
import io.deephaven.plugin.js.ImmutableJsPlugin;
import io.deephaven.plugin.js.Paths;
import io.deephaven.plugin.js.PathsInternal;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class JsPlugin
extends PluginBase {
    public static Builder builder() {
        return ImmutableJsPlugin.builder();
    }

    public abstract String name();

    public abstract String version();

    public abstract Path main();

    public abstract Path path();

    @Value.Default
    public Paths paths() {
        return Paths.all();
    }

    @Override
    public final <T, V extends Plugin.Visitor<T>> T walk(V visitor) {
        return visitor.visit(this);
    }

    @Value.Check
    final void checkPath() {
        if (!Files.isDirectory(this.path(), new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("path ('%s') must exist and be a directory", this.path()));
        }
    }

    @Value.Check
    final void checkMain() {
        Path mainPath = this.path().resolve(this.main());
        if (!Files.isRegularFile(mainPath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("main ('%s') must exist and be a regular file", mainPath));
        }
    }

    @Value.Check
    final void checkPaths() {
        if (!(this.paths() instanceof PathsInternal)) {
            throw new IllegalArgumentException("Must construct one of the approved Paths");
        }
        Path relativeMain = this.path().relativize(this.path().resolve(this.main()));
        if (!((PathsInternal)this.paths()).matches(relativeMain)) {
            throw new IllegalArgumentException(String.format("main ('%s') is not in paths", relativeMain));
        }
    }

    public static interface Builder {
        public Builder name(String var1);

        public Builder version(String var1);

        public Builder main(Path var1);

        public Builder path(Path var1);

        public Builder paths(Paths var1);

        public JsPlugin build();
    }
}

