/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugin.js;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.plugin.js.ImmutablePathsPrefixes;
import io.deephaven.plugin.js.PathsInternal;
import java.nio.file.Path;
import java.util.Set;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
abstract class PathsPrefixes
implements PathsInternal {
    PathsPrefixes() {
    }

    public static Builder builder() {
        return ImmutablePathsPrefixes.builder();
    }

    public abstract Set<Path> prefixes();

    @Override
    public final boolean matches(Path path) {
        if (this.prefixes().contains(path)) {
            return true;
        }
        for (Path prefix : this.prefixes()) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @Value.Check
    final void checkPrefixesNonEmpty() {
        if (this.prefixes().isEmpty()) {
            throw new IllegalArgumentException("prefixes must be non-empty");
        }
    }

    static interface Builder {
        public Builder addPrefixes(Path var1);

        public Builder addPrefixes(Path ... var1);

        public Builder addAllPrefixes(Iterable<? extends Path> var1);

        public PathsPrefixes build();
    }
}

