/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugin.type;

import io.deephaven.plugin.Plugin;
import io.deephaven.plugin.PluginBase;
import io.deephaven.plugin.type.Exporter;
import io.deephaven.plugin.type.ObjectCommunicationException;
import io.deephaven.plugin.type.ObjectType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;

public abstract class ObjectTypeBase
extends PluginBase
implements ObjectType {
    @Override
    public final ObjectType.MessageStream clientConnection(Object object, ObjectType.MessageStream connection) throws ObjectCommunicationException {
        if (!this.isType(object)) {
            throw new IllegalArgumentException("Can't serialize object, wrong type: " + this + " / " + object);
        }
        return this.compatibleClientConnection(object, connection);
    }

    public abstract ObjectType.MessageStream compatibleClientConnection(Object var1, ObjectType.MessageStream var2) throws ObjectCommunicationException;

    @Override
    public final <T, V extends Plugin.Visitor<T>> T walk(V visitor) {
        return visitor.visit(this);
    }

    public static abstract class FetchOnly
    extends ObjectTypeBase {
        public abstract void writeCompatibleObjectTo(Exporter var1, Object var2, OutputStream var3) throws IOException;

        @Override
        public ObjectType.MessageStream compatibleClientConnection(Object object, ObjectType.MessageStream connection) throws ObjectCommunicationException {
            Exporter exporter = new Exporter();
            try {
                this.writeCompatibleObjectTo(exporter, object, exporter.outputStream());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            connection.onData(exporter.payload(), exporter.references());
            connection.onClose();
            return ObjectType.MessageStream.NOOP;
        }
    }
}

