/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plugin.type;

import io.deephaven.plugin.type.Exporter;
import io.deephaven.plugin.type.ObjectCommunicationException;
import io.deephaven.plugin.type.ObjectType;
import io.deephaven.plugin.type.ObjectTypeBase;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Objects;

public abstract class ObjectTypeClassBase<T>
extends ObjectTypeBase {
    private final String name;
    private final Class<T> clazz;

    public ObjectTypeClassBase(String name, Class<T> clazz) {
        this.name = Objects.requireNonNull(name);
        this.clazz = Objects.requireNonNull(clazz);
    }

    public final Class<T> clazz() {
        return this.clazz;
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public final boolean isType(Object object) {
        return this.clazz.equals(object.getClass());
    }

    @Override
    public final ObjectType.MessageStream compatibleClientConnection(Object object, ObjectType.MessageStream connection) throws ObjectCommunicationException {
        return this.clientConnectionImpl(object, connection);
    }

    public abstract ObjectType.MessageStream clientConnectionImpl(T var1, ObjectType.MessageStream var2) throws ObjectCommunicationException;

    public String toString() {
        return this.name + ":" + this.clazz.getName();
    }

    public static abstract class FetchOnly<T>
    extends ObjectTypeClassBase<T> {
        public FetchOnly(String name, Class<T> clazz) {
            super(name, clazz);
        }

        @Override
        public final ObjectType.MessageStream clientConnectionImpl(T object, ObjectType.MessageStream connection) throws ObjectCommunicationException {
            Exporter exporter = new Exporter();
            try {
                this.writeToImpl(exporter, object, exporter.outputStream());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            connection.onData(exporter.payload(), exporter.references());
            connection.onClose();
            return ObjectType.MessageStream.NOOP;
        }

        public abstract void writeToImpl(Exporter var1, T var2, OutputStream var3) throws IOException;
    }
}

