/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.proto.flight.util;

import java.util.List;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.impl.Flight;

public class ArrowHelper {
    public static FlightDescriptor descriptor(Flight.FlightDescriptor impl) {
        switch (impl.getType()) {
            case PATH: {
                return FlightDescriptor.path((Iterable)impl.getPathList());
            }
            case CMD: {
                return FlightDescriptor.command((byte[])impl.getCmd().toByteArray());
            }
        }
        throw new IllegalArgumentException("Unexpected type " + impl.getTypeValue());
    }

    public static FlightDescriptor descriptor(List<String> path) {
        return FlightDescriptor.path(path);
    }

    public static Ticket ticket(Flight.Ticket ticket) {
        return new Ticket(ticket.getTicket().toByteArray());
    }
}

