/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.proto.flight.util;

import com.google.protobuf.ByteStringAccess;
import com.google.rpc.Code;
import io.deephaven.proto.backplane.grpc.Ticket;
import io.deephaven.proto.flight.util.TicketRouterHelper;
import io.deephaven.proto.util.Exceptions;
import io.deephaven.proto.util.ExportTicketHelper;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.arrow.flight.impl.Flight;

public class FlightExportTicketHelper {
    public static Flight.Ticket exportIdToFlightTicket(int exportId) {
        byte[] dest = ExportTicketHelper.exportIdToBytes((int)exportId);
        return Flight.Ticket.newBuilder().setTicket(ByteStringAccess.wrap((byte[])dest)).build();
    }

    public static Flight.FlightDescriptor exportIdToDescriptor(int exportId) {
        return Flight.FlightDescriptor.newBuilder().setType(Flight.FlightDescriptor.DescriptorType.PATH).addAllPath((Iterable)ExportTicketHelper.exportIdToPath((int)exportId)).build();
    }

    public static int ticketToExportId(Flight.Ticket ticket, String logId) {
        return ExportTicketHelper.ticketToExportIdInternal((ByteBuffer)ticket.getTicket().asReadOnlyByteBuffer().order(ByteOrder.LITTLE_ENDIAN), (String)logId);
    }

    public static int descriptorToExportId(Flight.FlightDescriptor descriptor, String logId) {
        if (descriptor == null) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve descriptor '" + logId + "': is empty"));
        }
        if (descriptor.getType() != Flight.FlightDescriptor.DescriptorType.PATH) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve descriptor '" + logId + "': not a path"));
        }
        if (descriptor.getPathCount() != 2) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve descriptor '" + logId + "': unexpected path length (found: " + TicketRouterHelper.getLogNameFor(descriptor) + ", expected: 2)"));
        }
        try {
            return Integer.parseInt(descriptor.getPath(1));
        }
        catch (NumberFormatException nfe) {
            throw Exceptions.statusRuntimeException((Code)Code.FAILED_PRECONDITION, (String)("Could not resolve descriptor '" + logId + "': export id not numeric (found: " + TicketRouterHelper.getLogNameFor(descriptor) + ")"));
        }
    }

    public static Flight.FlightDescriptor ticketToDescriptor(Ticket ticket, String logId) {
        return FlightExportTicketHelper.exportIdToDescriptor(ExportTicketHelper.ticketToExportId((Ticket)ticket, (String)logId));
    }

    public static Flight.FlightDescriptor ticketToDescriptor(Flight.Ticket ticket, String logId) {
        return FlightExportTicketHelper.exportIdToDescriptor(FlightExportTicketHelper.ticketToExportId(ticket, logId));
    }

    public static Flight.Ticket descriptorToFlightTicket(Flight.FlightDescriptor descriptor, String logId) {
        return FlightExportTicketHelper.exportIdToFlightTicket(FlightExportTicketHelper.descriptorToExportId(descriptor, logId));
    }

    public static Ticket descriptorToTicket(Flight.FlightDescriptor descriptor, String logId) {
        return ExportTicketHelper.wrapExportIdInTicket((int)FlightExportTicketHelper.descriptorToExportId(descriptor, logId));
    }
}

