/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.proto.flight.util;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import org.apache.arrow.flatbuf.Message;

public class MessageHelper {
    private static final int IPC_CONTINUATION_TOKEN = -1;

    public static int wrapInMessage(FlatBufferBuilder builder, int headerOffset, byte headerType) {
        return MessageHelper.wrapInMessage(builder, headerOffset, headerType, 0);
    }

    public static int wrapInMessage(FlatBufferBuilder builder, int headerOffset, byte headerType, int bodyLength) {
        Message.startMessage((FlatBufferBuilder)builder);
        Message.addHeaderType((FlatBufferBuilder)builder, (byte)headerType);
        Message.addHeader((FlatBufferBuilder)builder, (int)headerOffset);
        Message.addVersion((FlatBufferBuilder)builder, (short)4);
        Message.addBodyLength((FlatBufferBuilder)builder, (long)bodyLength);
        return Message.endMessage((FlatBufferBuilder)builder);
    }

    public static byte[] toIpcBytes(FlatBufferBuilder builder) {
        ByteBuffer msg = builder.dataBuffer();
        int padding = msg.remaining() % 8;
        if (padding != 0) {
            padding = 8 - padding;
        }
        byte[] byteMsg = new byte[msg.remaining() + 8 + padding];
        MessageHelper.intToBytes(-1, byteMsg, 0);
        MessageHelper.intToBytes(msg.remaining(), byteMsg, 4);
        msg.get(byteMsg, 8, msg.remaining());
        return byteMsg;
    }

    private static void intToBytes(int value, byte[] bytes, int offset) {
        bytes[offset + 3] = (byte)(value >>> 24);
        bytes[offset + 2] = (byte)(value >>> 16);
        bytes[offset + 1] = (byte)(value >>> 8);
        bytes[offset] = (byte)value;
    }
}

