package io.deephaven.flightjs.protocol;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * A flight js service is a (non-proper) extension of arrow flight service
 * that augments existing client-streaming (or bidirectional streaming) methods
 * with a pair that can be used to simulate a client stream over unary requests.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.50.2)",
    comments = "Source: BrowserFlight.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class BrowserFlightServiceGrpc {

  private BrowserFlightServiceGrpc() {}

  public static final String SERVICE_NAME = "io.deephaven.flightjs.protocol.BrowserFlightService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.HandshakeRequest,
      org.apache.arrow.flight.impl.Flight.HandshakeResponse> getOpenHandshakeMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "OpenHandshake",
      requestType = org.apache.arrow.flight.impl.Flight.HandshakeRequest.class,
      responseType = org.apache.arrow.flight.impl.Flight.HandshakeResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.HandshakeRequest,
      org.apache.arrow.flight.impl.Flight.HandshakeResponse> getOpenHandshakeMethod() {
    io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.HandshakeRequest, org.apache.arrow.flight.impl.Flight.HandshakeResponse> getOpenHandshakeMethod;
    if ((getOpenHandshakeMethod = BrowserFlightServiceGrpc.getOpenHandshakeMethod) == null) {
      synchronized (BrowserFlightServiceGrpc.class) {
        if ((getOpenHandshakeMethod = BrowserFlightServiceGrpc.getOpenHandshakeMethod) == null) {
          BrowserFlightServiceGrpc.getOpenHandshakeMethod = getOpenHandshakeMethod =
              io.grpc.MethodDescriptor.<org.apache.arrow.flight.impl.Flight.HandshakeRequest, org.apache.arrow.flight.impl.Flight.HandshakeResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "OpenHandshake"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.HandshakeRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.HandshakeResponse.getDefaultInstance()))
              .setSchemaDescriptor(new BrowserFlightServiceMethodDescriptorSupplier("OpenHandshake"))
              .build();
        }
      }
    }
    return getOpenHandshakeMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.HandshakeRequest,
      io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse> getNextHandshakeMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "NextHandshake",
      requestType = org.apache.arrow.flight.impl.Flight.HandshakeRequest.class,
      responseType = io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.HandshakeRequest,
      io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse> getNextHandshakeMethod() {
    io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.HandshakeRequest, io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse> getNextHandshakeMethod;
    if ((getNextHandshakeMethod = BrowserFlightServiceGrpc.getNextHandshakeMethod) == null) {
      synchronized (BrowserFlightServiceGrpc.class) {
        if ((getNextHandshakeMethod = BrowserFlightServiceGrpc.getNextHandshakeMethod) == null) {
          BrowserFlightServiceGrpc.getNextHandshakeMethod = getNextHandshakeMethod =
              io.grpc.MethodDescriptor.<org.apache.arrow.flight.impl.Flight.HandshakeRequest, io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "NextHandshake"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.HandshakeRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse.getDefaultInstance()))
              .setSchemaDescriptor(new BrowserFlightServiceMethodDescriptorSupplier("NextHandshake"))
              .build();
        }
      }
    }
    return getNextHandshakeMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.FlightData,
      org.apache.arrow.flight.impl.Flight.PutResult> getOpenDoPutMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "OpenDoPut",
      requestType = org.apache.arrow.flight.impl.Flight.FlightData.class,
      responseType = org.apache.arrow.flight.impl.Flight.PutResult.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.FlightData,
      org.apache.arrow.flight.impl.Flight.PutResult> getOpenDoPutMethod() {
    io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.FlightData, org.apache.arrow.flight.impl.Flight.PutResult> getOpenDoPutMethod;
    if ((getOpenDoPutMethod = BrowserFlightServiceGrpc.getOpenDoPutMethod) == null) {
      synchronized (BrowserFlightServiceGrpc.class) {
        if ((getOpenDoPutMethod = BrowserFlightServiceGrpc.getOpenDoPutMethod) == null) {
          BrowserFlightServiceGrpc.getOpenDoPutMethod = getOpenDoPutMethod =
              io.grpc.MethodDescriptor.<org.apache.arrow.flight.impl.Flight.FlightData, org.apache.arrow.flight.impl.Flight.PutResult>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "OpenDoPut"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.FlightData.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.PutResult.getDefaultInstance()))
              .setSchemaDescriptor(new BrowserFlightServiceMethodDescriptorSupplier("OpenDoPut"))
              .build();
        }
      }
    }
    return getOpenDoPutMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.FlightData,
      io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse> getNextDoPutMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "NextDoPut",
      requestType = org.apache.arrow.flight.impl.Flight.FlightData.class,
      responseType = io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.FlightData,
      io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse> getNextDoPutMethod() {
    io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.FlightData, io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse> getNextDoPutMethod;
    if ((getNextDoPutMethod = BrowserFlightServiceGrpc.getNextDoPutMethod) == null) {
      synchronized (BrowserFlightServiceGrpc.class) {
        if ((getNextDoPutMethod = BrowserFlightServiceGrpc.getNextDoPutMethod) == null) {
          BrowserFlightServiceGrpc.getNextDoPutMethod = getNextDoPutMethod =
              io.grpc.MethodDescriptor.<org.apache.arrow.flight.impl.Flight.FlightData, io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "NextDoPut"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.FlightData.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse.getDefaultInstance()))
              .setSchemaDescriptor(new BrowserFlightServiceMethodDescriptorSupplier("NextDoPut"))
              .build();
        }
      }
    }
    return getNextDoPutMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.FlightData,
      org.apache.arrow.flight.impl.Flight.FlightData> getOpenDoExchangeMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "OpenDoExchange",
      requestType = org.apache.arrow.flight.impl.Flight.FlightData.class,
      responseType = org.apache.arrow.flight.impl.Flight.FlightData.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.FlightData,
      org.apache.arrow.flight.impl.Flight.FlightData> getOpenDoExchangeMethod() {
    io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.FlightData, org.apache.arrow.flight.impl.Flight.FlightData> getOpenDoExchangeMethod;
    if ((getOpenDoExchangeMethod = BrowserFlightServiceGrpc.getOpenDoExchangeMethod) == null) {
      synchronized (BrowserFlightServiceGrpc.class) {
        if ((getOpenDoExchangeMethod = BrowserFlightServiceGrpc.getOpenDoExchangeMethod) == null) {
          BrowserFlightServiceGrpc.getOpenDoExchangeMethod = getOpenDoExchangeMethod =
              io.grpc.MethodDescriptor.<org.apache.arrow.flight.impl.Flight.FlightData, org.apache.arrow.flight.impl.Flight.FlightData>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "OpenDoExchange"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.FlightData.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.FlightData.getDefaultInstance()))
              .setSchemaDescriptor(new BrowserFlightServiceMethodDescriptorSupplier("OpenDoExchange"))
              .build();
        }
      }
    }
    return getOpenDoExchangeMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.FlightData,
      io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse> getNextDoExchangeMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "NextDoExchange",
      requestType = org.apache.arrow.flight.impl.Flight.FlightData.class,
      responseType = io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.FlightData,
      io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse> getNextDoExchangeMethod() {
    io.grpc.MethodDescriptor<org.apache.arrow.flight.impl.Flight.FlightData, io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse> getNextDoExchangeMethod;
    if ((getNextDoExchangeMethod = BrowserFlightServiceGrpc.getNextDoExchangeMethod) == null) {
      synchronized (BrowserFlightServiceGrpc.class) {
        if ((getNextDoExchangeMethod = BrowserFlightServiceGrpc.getNextDoExchangeMethod) == null) {
          BrowserFlightServiceGrpc.getNextDoExchangeMethod = getNextDoExchangeMethod =
              io.grpc.MethodDescriptor.<org.apache.arrow.flight.impl.Flight.FlightData, io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "NextDoExchange"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.apache.arrow.flight.impl.Flight.FlightData.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse.getDefaultInstance()))
              .setSchemaDescriptor(new BrowserFlightServiceMethodDescriptorSupplier("NextDoExchange"))
              .build();
        }
      }
    }
    return getNextDoExchangeMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static BrowserFlightServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<BrowserFlightServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<BrowserFlightServiceStub>() {
        @java.lang.Override
        public BrowserFlightServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new BrowserFlightServiceStub(channel, callOptions);
        }
      };
    return BrowserFlightServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static BrowserFlightServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<BrowserFlightServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<BrowserFlightServiceBlockingStub>() {
        @java.lang.Override
        public BrowserFlightServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new BrowserFlightServiceBlockingStub(channel, callOptions);
        }
      };
    return BrowserFlightServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static BrowserFlightServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<BrowserFlightServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<BrowserFlightServiceFutureStub>() {
        @java.lang.Override
        public BrowserFlightServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new BrowserFlightServiceFutureStub(channel, callOptions);
        }
      };
    return BrowserFlightServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * A flight js service is a (non-proper) extension of arrow flight service
   * that augments existing client-streaming (or bidirectional streaming) methods
   * with a pair that can be used to simulate a client stream over unary requests.
   * </pre>
   */
  public static abstract class BrowserFlightServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Handshake between client and server. Depending on the server, the
     * handshake may be required to determine the token that should be used for
     * future operations. Both request and response are streams to allow multiple
     * round-trips depending on auth mechanism.
     * </pre>
     */
    public void openHandshake(org.apache.arrow.flight.impl.Flight.HandshakeRequest request,
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.HandshakeResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getOpenHandshakeMethod(), responseObserver);
    }

    /**
     */
    public void nextHandshake(org.apache.arrow.flight.impl.Flight.HandshakeRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getNextHandshakeMethod(), responseObserver);
    }

    /**
     * <pre>
     * Push a stream to the flight service associated with a particular
     * flight stream. This allows a client of a flight service to upload a stream
     * of data. Depending on the particular flight service, a client consumer
     * could be allowed to upload a single stream per descriptor or an unlimited
     * number. In the latter, the service might implement a 'seal' action that
     * can be applied to a descriptor once all streams are uploaded.
     * </pre>
     */
    public void openDoPut(org.apache.arrow.flight.impl.Flight.FlightData request,
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.PutResult> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getOpenDoPutMethod(), responseObserver);
    }

    /**
     */
    public void nextDoPut(org.apache.arrow.flight.impl.Flight.FlightData request,
        io.grpc.stub.StreamObserver<io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getNextDoPutMethod(), responseObserver);
    }

    /**
     * <pre>
     * Open a bidirectional data channel for a given descriptor. This
     * allows clients to send and receive arbitrary Arrow data and
     * application-specific metadata in a single logical stream. In
     * contrast to DoGet/DoPut, this is more suited for clients
     * offloading computation (rather than storage) to a Flight service.
     * </pre>
     */
    public void openDoExchange(org.apache.arrow.flight.impl.Flight.FlightData request,
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.FlightData> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getOpenDoExchangeMethod(), responseObserver);
    }

    /**
     */
    public void nextDoExchange(org.apache.arrow.flight.impl.Flight.FlightData request,
        io.grpc.stub.StreamObserver<io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getNextDoExchangeMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getOpenHandshakeMethod(),
            io.grpc.stub.ServerCalls.asyncServerStreamingCall(
              new MethodHandlers<
                org.apache.arrow.flight.impl.Flight.HandshakeRequest,
                org.apache.arrow.flight.impl.Flight.HandshakeResponse>(
                  this, METHODID_OPEN_HANDSHAKE)))
          .addMethod(
            getNextHandshakeMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.apache.arrow.flight.impl.Flight.HandshakeRequest,
                io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse>(
                  this, METHODID_NEXT_HANDSHAKE)))
          .addMethod(
            getOpenDoPutMethod(),
            io.grpc.stub.ServerCalls.asyncServerStreamingCall(
              new MethodHandlers<
                org.apache.arrow.flight.impl.Flight.FlightData,
                org.apache.arrow.flight.impl.Flight.PutResult>(
                  this, METHODID_OPEN_DO_PUT)))
          .addMethod(
            getNextDoPutMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.apache.arrow.flight.impl.Flight.FlightData,
                io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse>(
                  this, METHODID_NEXT_DO_PUT)))
          .addMethod(
            getOpenDoExchangeMethod(),
            io.grpc.stub.ServerCalls.asyncServerStreamingCall(
              new MethodHandlers<
                org.apache.arrow.flight.impl.Flight.FlightData,
                org.apache.arrow.flight.impl.Flight.FlightData>(
                  this, METHODID_OPEN_DO_EXCHANGE)))
          .addMethod(
            getNextDoExchangeMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.apache.arrow.flight.impl.Flight.FlightData,
                io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse>(
                  this, METHODID_NEXT_DO_EXCHANGE)))
          .build();
    }
  }

  /**
   * <pre>
   * A flight js service is a (non-proper) extension of arrow flight service
   * that augments existing client-streaming (or bidirectional streaming) methods
   * with a pair that can be used to simulate a client stream over unary requests.
   * </pre>
   */
  public static final class BrowserFlightServiceStub extends io.grpc.stub.AbstractAsyncStub<BrowserFlightServiceStub> {
    private BrowserFlightServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected BrowserFlightServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new BrowserFlightServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Handshake between client and server. Depending on the server, the
     * handshake may be required to determine the token that should be used for
     * future operations. Both request and response are streams to allow multiple
     * round-trips depending on auth mechanism.
     * </pre>
     */
    public void openHandshake(org.apache.arrow.flight.impl.Flight.HandshakeRequest request,
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.HandshakeResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getOpenHandshakeMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void nextHandshake(org.apache.arrow.flight.impl.Flight.HandshakeRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getNextHandshakeMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Push a stream to the flight service associated with a particular
     * flight stream. This allows a client of a flight service to upload a stream
     * of data. Depending on the particular flight service, a client consumer
     * could be allowed to upload a single stream per descriptor or an unlimited
     * number. In the latter, the service might implement a 'seal' action that
     * can be applied to a descriptor once all streams are uploaded.
     * </pre>
     */
    public void openDoPut(org.apache.arrow.flight.impl.Flight.FlightData request,
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.PutResult> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getOpenDoPutMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void nextDoPut(org.apache.arrow.flight.impl.Flight.FlightData request,
        io.grpc.stub.StreamObserver<io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getNextDoPutMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Open a bidirectional data channel for a given descriptor. This
     * allows clients to send and receive arbitrary Arrow data and
     * application-specific metadata in a single logical stream. In
     * contrast to DoGet/DoPut, this is more suited for clients
     * offloading computation (rather than storage) to a Flight service.
     * </pre>
     */
    public void openDoExchange(org.apache.arrow.flight.impl.Flight.FlightData request,
        io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.FlightData> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getOpenDoExchangeMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void nextDoExchange(org.apache.arrow.flight.impl.Flight.FlightData request,
        io.grpc.stub.StreamObserver<io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getNextDoExchangeMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * A flight js service is a (non-proper) extension of arrow flight service
   * that augments existing client-streaming (or bidirectional streaming) methods
   * with a pair that can be used to simulate a client stream over unary requests.
   * </pre>
   */
  public static final class BrowserFlightServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<BrowserFlightServiceBlockingStub> {
    private BrowserFlightServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected BrowserFlightServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new BrowserFlightServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Handshake between client and server. Depending on the server, the
     * handshake may be required to determine the token that should be used for
     * future operations. Both request and response are streams to allow multiple
     * round-trips depending on auth mechanism.
     * </pre>
     */
    public java.util.Iterator<org.apache.arrow.flight.impl.Flight.HandshakeResponse> openHandshake(
        org.apache.arrow.flight.impl.Flight.HandshakeRequest request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getOpenHandshakeMethod(), getCallOptions(), request);
    }

    /**
     */
    public io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse nextHandshake(org.apache.arrow.flight.impl.Flight.HandshakeRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getNextHandshakeMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Push a stream to the flight service associated with a particular
     * flight stream. This allows a client of a flight service to upload a stream
     * of data. Depending on the particular flight service, a client consumer
     * could be allowed to upload a single stream per descriptor or an unlimited
     * number. In the latter, the service might implement a 'seal' action that
     * can be applied to a descriptor once all streams are uploaded.
     * </pre>
     */
    public java.util.Iterator<org.apache.arrow.flight.impl.Flight.PutResult> openDoPut(
        org.apache.arrow.flight.impl.Flight.FlightData request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getOpenDoPutMethod(), getCallOptions(), request);
    }

    /**
     */
    public io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse nextDoPut(org.apache.arrow.flight.impl.Flight.FlightData request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getNextDoPutMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Open a bidirectional data channel for a given descriptor. This
     * allows clients to send and receive arbitrary Arrow data and
     * application-specific metadata in a single logical stream. In
     * contrast to DoGet/DoPut, this is more suited for clients
     * offloading computation (rather than storage) to a Flight service.
     * </pre>
     */
    public java.util.Iterator<org.apache.arrow.flight.impl.Flight.FlightData> openDoExchange(
        org.apache.arrow.flight.impl.Flight.FlightData request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getOpenDoExchangeMethod(), getCallOptions(), request);
    }

    /**
     */
    public io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse nextDoExchange(org.apache.arrow.flight.impl.Flight.FlightData request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getNextDoExchangeMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * A flight js service is a (non-proper) extension of arrow flight service
   * that augments existing client-streaming (or bidirectional streaming) methods
   * with a pair that can be used to simulate a client stream over unary requests.
   * </pre>
   */
  public static final class BrowserFlightServiceFutureStub extends io.grpc.stub.AbstractFutureStub<BrowserFlightServiceFutureStub> {
    private BrowserFlightServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected BrowserFlightServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new BrowserFlightServiceFutureStub(channel, callOptions);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse> nextHandshake(
        org.apache.arrow.flight.impl.Flight.HandshakeRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getNextHandshakeMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse> nextDoPut(
        org.apache.arrow.flight.impl.Flight.FlightData request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getNextDoPutMethod(), getCallOptions()), request);
    }

    /**
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse> nextDoExchange(
        org.apache.arrow.flight.impl.Flight.FlightData request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getNextDoExchangeMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_OPEN_HANDSHAKE = 0;
  private static final int METHODID_NEXT_HANDSHAKE = 1;
  private static final int METHODID_OPEN_DO_PUT = 2;
  private static final int METHODID_NEXT_DO_PUT = 3;
  private static final int METHODID_OPEN_DO_EXCHANGE = 4;
  private static final int METHODID_NEXT_DO_EXCHANGE = 5;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final BrowserFlightServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(BrowserFlightServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_OPEN_HANDSHAKE:
          serviceImpl.openHandshake((org.apache.arrow.flight.impl.Flight.HandshakeRequest) request,
              (io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.HandshakeResponse>) responseObserver);
          break;
        case METHODID_NEXT_HANDSHAKE:
          serviceImpl.nextHandshake((org.apache.arrow.flight.impl.Flight.HandshakeRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse>) responseObserver);
          break;
        case METHODID_OPEN_DO_PUT:
          serviceImpl.openDoPut((org.apache.arrow.flight.impl.Flight.FlightData) request,
              (io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.PutResult>) responseObserver);
          break;
        case METHODID_NEXT_DO_PUT:
          serviceImpl.nextDoPut((org.apache.arrow.flight.impl.Flight.FlightData) request,
              (io.grpc.stub.StreamObserver<io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse>) responseObserver);
          break;
        case METHODID_OPEN_DO_EXCHANGE:
          serviceImpl.openDoExchange((org.apache.arrow.flight.impl.Flight.FlightData) request,
              (io.grpc.stub.StreamObserver<org.apache.arrow.flight.impl.Flight.FlightData>) responseObserver);
          break;
        case METHODID_NEXT_DO_EXCHANGE:
          serviceImpl.nextDoExchange((org.apache.arrow.flight.impl.Flight.FlightData) request,
              (io.grpc.stub.StreamObserver<io.deephaven.flightjs.protocol.BrowserFlight.BrowserNextResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class BrowserFlightServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    BrowserFlightServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.deephaven.flightjs.protocol.BrowserFlight.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("BrowserFlightService");
    }
  }

  private static final class BrowserFlightServiceFileDescriptorSupplier
      extends BrowserFlightServiceBaseDescriptorSupplier {
    BrowserFlightServiceFileDescriptorSupplier() {}
  }

  private static final class BrowserFlightServiceMethodDescriptorSupplier
      extends BrowserFlightServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    BrowserFlightServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (BrowserFlightServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new BrowserFlightServiceFileDescriptorSupplier())
              .addMethod(getOpenHandshakeMethod())
              .addMethod(getNextHandshakeMethod())
              .addMethod(getOpenDoPutMethod())
              .addMethod(getNextDoPutMethod())
              .addMethod(getOpenDoExchangeMethod())
              .addMethod(getNextDoExchangeMethod())
              .build();
        }
      }
    }
    return result;
  }
}
