package io.deephaven.proto.backplane.grpc;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * This service provides tools to create and view hierarchical tables (rollups and trees).
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.50.2)",
    comments = "Source: deephaven/proto/hierarchicaltable.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class HierarchicalTableServiceGrpc {

  private HierarchicalTableServiceGrpc() {}

  public static final String SERVICE_NAME = "io.deephaven.proto.backplane.grpc.HierarchicalTableService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.RollupRequest,
      io.deephaven.proto.backplane.grpc.RollupResponse> getRollupMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Rollup",
      requestType = io.deephaven.proto.backplane.grpc.RollupRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.RollupResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.RollupRequest,
      io.deephaven.proto.backplane.grpc.RollupResponse> getRollupMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.RollupRequest, io.deephaven.proto.backplane.grpc.RollupResponse> getRollupMethod;
    if ((getRollupMethod = HierarchicalTableServiceGrpc.getRollupMethod) == null) {
      synchronized (HierarchicalTableServiceGrpc.class) {
        if ((getRollupMethod = HierarchicalTableServiceGrpc.getRollupMethod) == null) {
          HierarchicalTableServiceGrpc.getRollupMethod = getRollupMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.RollupRequest, io.deephaven.proto.backplane.grpc.RollupResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Rollup"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.RollupRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.RollupResponse.getDefaultInstance()))
              .setSchemaDescriptor(new HierarchicalTableServiceMethodDescriptorSupplier("Rollup"))
              .build();
        }
      }
    }
    return getRollupMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.TreeRequest,
      io.deephaven.proto.backplane.grpc.TreeResponse> getTreeMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Tree",
      requestType = io.deephaven.proto.backplane.grpc.TreeRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.TreeResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.TreeRequest,
      io.deephaven.proto.backplane.grpc.TreeResponse> getTreeMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.TreeRequest, io.deephaven.proto.backplane.grpc.TreeResponse> getTreeMethod;
    if ((getTreeMethod = HierarchicalTableServiceGrpc.getTreeMethod) == null) {
      synchronized (HierarchicalTableServiceGrpc.class) {
        if ((getTreeMethod = HierarchicalTableServiceGrpc.getTreeMethod) == null) {
          HierarchicalTableServiceGrpc.getTreeMethod = getTreeMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.TreeRequest, io.deephaven.proto.backplane.grpc.TreeResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Tree"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.TreeRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.TreeResponse.getDefaultInstance()))
              .setSchemaDescriptor(new HierarchicalTableServiceMethodDescriptorSupplier("Tree"))
              .build();
        }
      }
    }
    return getTreeMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.HierarchicalTableApplyRequest,
      io.deephaven.proto.backplane.grpc.HierarchicalTableApplyResponse> getApplyMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Apply",
      requestType = io.deephaven.proto.backplane.grpc.HierarchicalTableApplyRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.HierarchicalTableApplyResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.HierarchicalTableApplyRequest,
      io.deephaven.proto.backplane.grpc.HierarchicalTableApplyResponse> getApplyMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.HierarchicalTableApplyRequest, io.deephaven.proto.backplane.grpc.HierarchicalTableApplyResponse> getApplyMethod;
    if ((getApplyMethod = HierarchicalTableServiceGrpc.getApplyMethod) == null) {
      synchronized (HierarchicalTableServiceGrpc.class) {
        if ((getApplyMethod = HierarchicalTableServiceGrpc.getApplyMethod) == null) {
          HierarchicalTableServiceGrpc.getApplyMethod = getApplyMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.HierarchicalTableApplyRequest, io.deephaven.proto.backplane.grpc.HierarchicalTableApplyResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Apply"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.HierarchicalTableApplyRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.HierarchicalTableApplyResponse.getDefaultInstance()))
              .setSchemaDescriptor(new HierarchicalTableServiceMethodDescriptorSupplier("Apply"))
              .build();
        }
      }
    }
    return getApplyMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.HierarchicalTableViewRequest,
      io.deephaven.proto.backplane.grpc.HierarchicalTableViewResponse> getViewMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "View",
      requestType = io.deephaven.proto.backplane.grpc.HierarchicalTableViewRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.HierarchicalTableViewResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.HierarchicalTableViewRequest,
      io.deephaven.proto.backplane.grpc.HierarchicalTableViewResponse> getViewMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.HierarchicalTableViewRequest, io.deephaven.proto.backplane.grpc.HierarchicalTableViewResponse> getViewMethod;
    if ((getViewMethod = HierarchicalTableServiceGrpc.getViewMethod) == null) {
      synchronized (HierarchicalTableServiceGrpc.class) {
        if ((getViewMethod = HierarchicalTableServiceGrpc.getViewMethod) == null) {
          HierarchicalTableServiceGrpc.getViewMethod = getViewMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.HierarchicalTableViewRequest, io.deephaven.proto.backplane.grpc.HierarchicalTableViewResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "View"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.HierarchicalTableViewRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.HierarchicalTableViewResponse.getDefaultInstance()))
              .setSchemaDescriptor(new HierarchicalTableServiceMethodDescriptorSupplier("View"))
              .build();
        }
      }
    }
    return getViewMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.HierarchicalTableSourceExportRequest,
      io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse> getExportSourceMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ExportSource",
      requestType = io.deephaven.proto.backplane.grpc.HierarchicalTableSourceExportRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.HierarchicalTableSourceExportRequest,
      io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse> getExportSourceMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.HierarchicalTableSourceExportRequest, io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse> getExportSourceMethod;
    if ((getExportSourceMethod = HierarchicalTableServiceGrpc.getExportSourceMethod) == null) {
      synchronized (HierarchicalTableServiceGrpc.class) {
        if ((getExportSourceMethod = HierarchicalTableServiceGrpc.getExportSourceMethod) == null) {
          HierarchicalTableServiceGrpc.getExportSourceMethod = getExportSourceMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.HierarchicalTableSourceExportRequest, io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ExportSource"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.HierarchicalTableSourceExportRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse.getDefaultInstance()))
              .setSchemaDescriptor(new HierarchicalTableServiceMethodDescriptorSupplier("ExportSource"))
              .build();
        }
      }
    }
    return getExportSourceMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static HierarchicalTableServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<HierarchicalTableServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<HierarchicalTableServiceStub>() {
        @java.lang.Override
        public HierarchicalTableServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new HierarchicalTableServiceStub(channel, callOptions);
        }
      };
    return HierarchicalTableServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static HierarchicalTableServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<HierarchicalTableServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<HierarchicalTableServiceBlockingStub>() {
        @java.lang.Override
        public HierarchicalTableServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new HierarchicalTableServiceBlockingStub(channel, callOptions);
        }
      };
    return HierarchicalTableServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static HierarchicalTableServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<HierarchicalTableServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<HierarchicalTableServiceFutureStub>() {
        @java.lang.Override
        public HierarchicalTableServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new HierarchicalTableServiceFutureStub(channel, callOptions);
        }
      };
    return HierarchicalTableServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * This service provides tools to create and view hierarchical tables (rollups and trees).
   * </pre>
   */
  public static abstract class HierarchicalTableServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Applies a rollup operation to a Table and exports the resulting RollupTable
     * </pre>
     */
    public void rollup(io.deephaven.proto.backplane.grpc.RollupRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.RollupResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getRollupMethod(), responseObserver);
    }

    /**
     * <pre>
     * Applies a tree operation to a Table and exports the resulting TreeTable
     * </pre>
     */
    public void tree(io.deephaven.proto.backplane.grpc.TreeRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.TreeResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getTreeMethod(), responseObserver);
    }

    /**
     * <pre>
     * Applies operations to an existing HierarchicalTable (RollupTable or TreeTable) and exports the resulting
     * HierarchicalTable
     * </pre>
     */
    public void apply(io.deephaven.proto.backplane.grpc.HierarchicalTableApplyRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.HierarchicalTableApplyResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getApplyMethod(), responseObserver);
    }

    /**
     * <pre>
     * Creates a view associating a Table of expansion keys and actions with an existing HierarchicalTable and exports
     * the resulting HierarchicalTableView for subsequent snapshot or subscription requests
     * </pre>
     */
    public void view(io.deephaven.proto.backplane.grpc.HierarchicalTableViewRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.HierarchicalTableViewResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getViewMethod(), responseObserver);
    }

    /**
     * <pre>
     * Exports the source Table for a HierarchicalTable (Rollup or TreeTable)
     * </pre>
     */
    public void exportSource(io.deephaven.proto.backplane.grpc.HierarchicalTableSourceExportRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getExportSourceMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getRollupMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.RollupRequest,
                io.deephaven.proto.backplane.grpc.RollupResponse>(
                  this, METHODID_ROLLUP)))
          .addMethod(
            getTreeMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.TreeRequest,
                io.deephaven.proto.backplane.grpc.TreeResponse>(
                  this, METHODID_TREE)))
          .addMethod(
            getApplyMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.HierarchicalTableApplyRequest,
                io.deephaven.proto.backplane.grpc.HierarchicalTableApplyResponse>(
                  this, METHODID_APPLY)))
          .addMethod(
            getViewMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.HierarchicalTableViewRequest,
                io.deephaven.proto.backplane.grpc.HierarchicalTableViewResponse>(
                  this, METHODID_VIEW)))
          .addMethod(
            getExportSourceMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.HierarchicalTableSourceExportRequest,
                io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse>(
                  this, METHODID_EXPORT_SOURCE)))
          .build();
    }
  }

  /**
   * <pre>
   * This service provides tools to create and view hierarchical tables (rollups and trees).
   * </pre>
   */
  public static final class HierarchicalTableServiceStub extends io.grpc.stub.AbstractAsyncStub<HierarchicalTableServiceStub> {
    private HierarchicalTableServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected HierarchicalTableServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new HierarchicalTableServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Applies a rollup operation to a Table and exports the resulting RollupTable
     * </pre>
     */
    public void rollup(io.deephaven.proto.backplane.grpc.RollupRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.RollupResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getRollupMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Applies a tree operation to a Table and exports the resulting TreeTable
     * </pre>
     */
    public void tree(io.deephaven.proto.backplane.grpc.TreeRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.TreeResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getTreeMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Applies operations to an existing HierarchicalTable (RollupTable or TreeTable) and exports the resulting
     * HierarchicalTable
     * </pre>
     */
    public void apply(io.deephaven.proto.backplane.grpc.HierarchicalTableApplyRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.HierarchicalTableApplyResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getApplyMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Creates a view associating a Table of expansion keys and actions with an existing HierarchicalTable and exports
     * the resulting HierarchicalTableView for subsequent snapshot or subscription requests
     * </pre>
     */
    public void view(io.deephaven.proto.backplane.grpc.HierarchicalTableViewRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.HierarchicalTableViewResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getViewMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Exports the source Table for a HierarchicalTable (Rollup or TreeTable)
     * </pre>
     */
    public void exportSource(io.deephaven.proto.backplane.grpc.HierarchicalTableSourceExportRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getExportSourceMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * This service provides tools to create and view hierarchical tables (rollups and trees).
   * </pre>
   */
  public static final class HierarchicalTableServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<HierarchicalTableServiceBlockingStub> {
    private HierarchicalTableServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected HierarchicalTableServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new HierarchicalTableServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Applies a rollup operation to a Table and exports the resulting RollupTable
     * </pre>
     */
    public io.deephaven.proto.backplane.grpc.RollupResponse rollup(io.deephaven.proto.backplane.grpc.RollupRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getRollupMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Applies a tree operation to a Table and exports the resulting TreeTable
     * </pre>
     */
    public io.deephaven.proto.backplane.grpc.TreeResponse tree(io.deephaven.proto.backplane.grpc.TreeRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getTreeMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Applies operations to an existing HierarchicalTable (RollupTable or TreeTable) and exports the resulting
     * HierarchicalTable
     * </pre>
     */
    public io.deephaven.proto.backplane.grpc.HierarchicalTableApplyResponse apply(io.deephaven.proto.backplane.grpc.HierarchicalTableApplyRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getApplyMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Creates a view associating a Table of expansion keys and actions with an existing HierarchicalTable and exports
     * the resulting HierarchicalTableView for subsequent snapshot or subscription requests
     * </pre>
     */
    public io.deephaven.proto.backplane.grpc.HierarchicalTableViewResponse view(io.deephaven.proto.backplane.grpc.HierarchicalTableViewRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getViewMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Exports the source Table for a HierarchicalTable (Rollup or TreeTable)
     * </pre>
     */
    public io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse exportSource(io.deephaven.proto.backplane.grpc.HierarchicalTableSourceExportRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getExportSourceMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * This service provides tools to create and view hierarchical tables (rollups and trees).
   * </pre>
   */
  public static final class HierarchicalTableServiceFutureStub extends io.grpc.stub.AbstractFutureStub<HierarchicalTableServiceFutureStub> {
    private HierarchicalTableServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected HierarchicalTableServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new HierarchicalTableServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Applies a rollup operation to a Table and exports the resulting RollupTable
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.RollupResponse> rollup(
        io.deephaven.proto.backplane.grpc.RollupRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getRollupMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Applies a tree operation to a Table and exports the resulting TreeTable
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.TreeResponse> tree(
        io.deephaven.proto.backplane.grpc.TreeRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getTreeMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Applies operations to an existing HierarchicalTable (RollupTable or TreeTable) and exports the resulting
     * HierarchicalTable
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.HierarchicalTableApplyResponse> apply(
        io.deephaven.proto.backplane.grpc.HierarchicalTableApplyRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getApplyMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Creates a view associating a Table of expansion keys and actions with an existing HierarchicalTable and exports
     * the resulting HierarchicalTableView for subsequent snapshot or subscription requests
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.HierarchicalTableViewResponse> view(
        io.deephaven.proto.backplane.grpc.HierarchicalTableViewRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getViewMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Exports the source Table for a HierarchicalTable (Rollup or TreeTable)
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse> exportSource(
        io.deephaven.proto.backplane.grpc.HierarchicalTableSourceExportRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getExportSourceMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_ROLLUP = 0;
  private static final int METHODID_TREE = 1;
  private static final int METHODID_APPLY = 2;
  private static final int METHODID_VIEW = 3;
  private static final int METHODID_EXPORT_SOURCE = 4;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final HierarchicalTableServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(HierarchicalTableServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_ROLLUP:
          serviceImpl.rollup((io.deephaven.proto.backplane.grpc.RollupRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.RollupResponse>) responseObserver);
          break;
        case METHODID_TREE:
          serviceImpl.tree((io.deephaven.proto.backplane.grpc.TreeRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.TreeResponse>) responseObserver);
          break;
        case METHODID_APPLY:
          serviceImpl.apply((io.deephaven.proto.backplane.grpc.HierarchicalTableApplyRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.HierarchicalTableApplyResponse>) responseObserver);
          break;
        case METHODID_VIEW:
          serviceImpl.view((io.deephaven.proto.backplane.grpc.HierarchicalTableViewRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.HierarchicalTableViewResponse>) responseObserver);
          break;
        case METHODID_EXPORT_SOURCE:
          serviceImpl.exportSource((io.deephaven.proto.backplane.grpc.HierarchicalTableSourceExportRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class HierarchicalTableServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    HierarchicalTableServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.deephaven.proto.backplane.grpc.Hierarchicaltable.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("HierarchicalTableService");
    }
  }

  private static final class HierarchicalTableServiceFileDescriptorSupplier
      extends HierarchicalTableServiceBaseDescriptorSupplier {
    HierarchicalTableServiceFileDescriptorSupplier() {}
  }

  private static final class HierarchicalTableServiceMethodDescriptorSupplier
      extends HierarchicalTableServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    HierarchicalTableServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (HierarchicalTableServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new HierarchicalTableServiceFileDescriptorSupplier())
              .addMethod(getRollupMethod())
              .addMethod(getTreeMethod())
              .addMethod(getApplyMethod())
              .addMethod(getViewMethod())
              .addMethod(getExportSourceMethod())
              .build();
        }
      }
    }
    return result;
  }
}
