package io.deephaven.proto.backplane.grpc;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * This service provides tools to create and query partitioned tables.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.50.2)",
    comments = "Source: deephaven/proto/partitionedtable.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class PartitionedTableServiceGrpc {

  private PartitionedTableServiceGrpc() {}

  public static final String SERVICE_NAME = "io.deephaven.proto.backplane.grpc.PartitionedTableService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.PartitionByRequest,
      io.deephaven.proto.backplane.grpc.PartitionByResponse> getPartitionByMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "PartitionBy",
      requestType = io.deephaven.proto.backplane.grpc.PartitionByRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.PartitionByResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.PartitionByRequest,
      io.deephaven.proto.backplane.grpc.PartitionByResponse> getPartitionByMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.PartitionByRequest, io.deephaven.proto.backplane.grpc.PartitionByResponse> getPartitionByMethod;
    if ((getPartitionByMethod = PartitionedTableServiceGrpc.getPartitionByMethod) == null) {
      synchronized (PartitionedTableServiceGrpc.class) {
        if ((getPartitionByMethod = PartitionedTableServiceGrpc.getPartitionByMethod) == null) {
          PartitionedTableServiceGrpc.getPartitionByMethod = getPartitionByMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.PartitionByRequest, io.deephaven.proto.backplane.grpc.PartitionByResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "PartitionBy"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.PartitionByRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.PartitionByResponse.getDefaultInstance()))
              .setSchemaDescriptor(new PartitionedTableServiceMethodDescriptorSupplier("PartitionBy"))
              .build();
        }
      }
    }
    return getPartitionByMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.MergeRequest,
      io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse> getMergeMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Merge",
      requestType = io.deephaven.proto.backplane.grpc.MergeRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.MergeRequest,
      io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse> getMergeMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.MergeRequest, io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse> getMergeMethod;
    if ((getMergeMethod = PartitionedTableServiceGrpc.getMergeMethod) == null) {
      synchronized (PartitionedTableServiceGrpc.class) {
        if ((getMergeMethod = PartitionedTableServiceGrpc.getMergeMethod) == null) {
          PartitionedTableServiceGrpc.getMergeMethod = getMergeMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.MergeRequest, io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Merge"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.MergeRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse.getDefaultInstance()))
              .setSchemaDescriptor(new PartitionedTableServiceMethodDescriptorSupplier("Merge"))
              .build();
        }
      }
    }
    return getMergeMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.GetTableRequest,
      io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse> getGetTableMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetTable",
      requestType = io.deephaven.proto.backplane.grpc.GetTableRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.GetTableRequest,
      io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse> getGetTableMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.GetTableRequest, io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse> getGetTableMethod;
    if ((getGetTableMethod = PartitionedTableServiceGrpc.getGetTableMethod) == null) {
      synchronized (PartitionedTableServiceGrpc.class) {
        if ((getGetTableMethod = PartitionedTableServiceGrpc.getGetTableMethod) == null) {
          PartitionedTableServiceGrpc.getGetTableMethod = getGetTableMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.GetTableRequest, io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetTable"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.GetTableRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse.getDefaultInstance()))
              .setSchemaDescriptor(new PartitionedTableServiceMethodDescriptorSupplier("GetTable"))
              .build();
        }
      }
    }
    return getGetTableMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static PartitionedTableServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<PartitionedTableServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<PartitionedTableServiceStub>() {
        @java.lang.Override
        public PartitionedTableServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new PartitionedTableServiceStub(channel, callOptions);
        }
      };
    return PartitionedTableServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static PartitionedTableServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<PartitionedTableServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<PartitionedTableServiceBlockingStub>() {
        @java.lang.Override
        public PartitionedTableServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new PartitionedTableServiceBlockingStub(channel, callOptions);
        }
      };
    return PartitionedTableServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static PartitionedTableServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<PartitionedTableServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<PartitionedTableServiceFutureStub>() {
        @java.lang.Override
        public PartitionedTableServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new PartitionedTableServiceFutureStub(channel, callOptions);
        }
      };
    return PartitionedTableServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * This service provides tools to create and query partitioned tables.
   * </pre>
   */
  public static abstract class PartitionedTableServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Transforms a table into a partitioned table, consisting of many separate tables, each individually
     * addressable. The result will be a FetchObjectResponse populated with a PartitionedTable.
     * </pre>
     */
    public void partitionBy(io.deephaven.proto.backplane.grpc.PartitionByRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.PartitionByResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getPartitionByMethod(), responseObserver);
    }

    /**
     * <pre>
     * Given a partitioned table, returns a table with the contents of all of the constituent tables.
     * </pre>
     */
    public void merge(io.deephaven.proto.backplane.grpc.MergeRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getMergeMethod(), responseObserver);
    }

    /**
     * <pre>
     * Given a partitioned table and a row described by another table's contents, returns a table
     * that matched that row, if any. If none is present, NOT_FOUND will be sent in response. If
     * more than one is present, FAILED_PRECONDITION will be sent in response.
     * If the provided key table has any number of rows other than one, INVALID_ARGUMENT will be
     * sent in response.
     * The simplest way to generally use this is to subscribe to the key columns of the underlying
     * table of a given PartitionedTable, then use /FlightService/DoPut to create a table with the
     * desired keys, and pass that ticket to this service. After that request is sent (note that it
     * is not required to wait for it to complete), that new table ticket can be used to make this
     * GetTable request.
     * </pre>
     */
    public void getTable(io.deephaven.proto.backplane.grpc.GetTableRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetTableMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getPartitionByMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.PartitionByRequest,
                io.deephaven.proto.backplane.grpc.PartitionByResponse>(
                  this, METHODID_PARTITION_BY)))
          .addMethod(
            getMergeMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.MergeRequest,
                io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse>(
                  this, METHODID_MERGE)))
          .addMethod(
            getGetTableMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.GetTableRequest,
                io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse>(
                  this, METHODID_GET_TABLE)))
          .build();
    }
  }

  /**
   * <pre>
   * This service provides tools to create and query partitioned tables.
   * </pre>
   */
  public static final class PartitionedTableServiceStub extends io.grpc.stub.AbstractAsyncStub<PartitionedTableServiceStub> {
    private PartitionedTableServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PartitionedTableServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new PartitionedTableServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Transforms a table into a partitioned table, consisting of many separate tables, each individually
     * addressable. The result will be a FetchObjectResponse populated with a PartitionedTable.
     * </pre>
     */
    public void partitionBy(io.deephaven.proto.backplane.grpc.PartitionByRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.PartitionByResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getPartitionByMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Given a partitioned table, returns a table with the contents of all of the constituent tables.
     * </pre>
     */
    public void merge(io.deephaven.proto.backplane.grpc.MergeRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getMergeMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Given a partitioned table and a row described by another table's contents, returns a table
     * that matched that row, if any. If none is present, NOT_FOUND will be sent in response. If
     * more than one is present, FAILED_PRECONDITION will be sent in response.
     * If the provided key table has any number of rows other than one, INVALID_ARGUMENT will be
     * sent in response.
     * The simplest way to generally use this is to subscribe to the key columns of the underlying
     * table of a given PartitionedTable, then use /FlightService/DoPut to create a table with the
     * desired keys, and pass that ticket to this service. After that request is sent (note that it
     * is not required to wait for it to complete), that new table ticket can be used to make this
     * GetTable request.
     * </pre>
     */
    public void getTable(io.deephaven.proto.backplane.grpc.GetTableRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetTableMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * This service provides tools to create and query partitioned tables.
   * </pre>
   */
  public static final class PartitionedTableServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<PartitionedTableServiceBlockingStub> {
    private PartitionedTableServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PartitionedTableServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new PartitionedTableServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Transforms a table into a partitioned table, consisting of many separate tables, each individually
     * addressable. The result will be a FetchObjectResponse populated with a PartitionedTable.
     * </pre>
     */
    public io.deephaven.proto.backplane.grpc.PartitionByResponse partitionBy(io.deephaven.proto.backplane.grpc.PartitionByRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getPartitionByMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Given a partitioned table, returns a table with the contents of all of the constituent tables.
     * </pre>
     */
    public io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse merge(io.deephaven.proto.backplane.grpc.MergeRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getMergeMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Given a partitioned table and a row described by another table's contents, returns a table
     * that matched that row, if any. If none is present, NOT_FOUND will be sent in response. If
     * more than one is present, FAILED_PRECONDITION will be sent in response.
     * If the provided key table has any number of rows other than one, INVALID_ARGUMENT will be
     * sent in response.
     * The simplest way to generally use this is to subscribe to the key columns of the underlying
     * table of a given PartitionedTable, then use /FlightService/DoPut to create a table with the
     * desired keys, and pass that ticket to this service. After that request is sent (note that it
     * is not required to wait for it to complete), that new table ticket can be used to make this
     * GetTable request.
     * </pre>
     */
    public io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse getTable(io.deephaven.proto.backplane.grpc.GetTableRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetTableMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * This service provides tools to create and query partitioned tables.
   * </pre>
   */
  public static final class PartitionedTableServiceFutureStub extends io.grpc.stub.AbstractFutureStub<PartitionedTableServiceFutureStub> {
    private PartitionedTableServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PartitionedTableServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new PartitionedTableServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Transforms a table into a partitioned table, consisting of many separate tables, each individually
     * addressable. The result will be a FetchObjectResponse populated with a PartitionedTable.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.PartitionByResponse> partitionBy(
        io.deephaven.proto.backplane.grpc.PartitionByRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getPartitionByMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Given a partitioned table, returns a table with the contents of all of the constituent tables.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse> merge(
        io.deephaven.proto.backplane.grpc.MergeRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getMergeMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Given a partitioned table and a row described by another table's contents, returns a table
     * that matched that row, if any. If none is present, NOT_FOUND will be sent in response. If
     * more than one is present, FAILED_PRECONDITION will be sent in response.
     * If the provided key table has any number of rows other than one, INVALID_ARGUMENT will be
     * sent in response.
     * The simplest way to generally use this is to subscribe to the key columns of the underlying
     * table of a given PartitionedTable, then use /FlightService/DoPut to create a table with the
     * desired keys, and pass that ticket to this service. After that request is sent (note that it
     * is not required to wait for it to complete), that new table ticket can be used to make this
     * GetTable request.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse> getTable(
        io.deephaven.proto.backplane.grpc.GetTableRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetTableMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_PARTITION_BY = 0;
  private static final int METHODID_MERGE = 1;
  private static final int METHODID_GET_TABLE = 2;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final PartitionedTableServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(PartitionedTableServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_PARTITION_BY:
          serviceImpl.partitionBy((io.deephaven.proto.backplane.grpc.PartitionByRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.PartitionByResponse>) responseObserver);
          break;
        case METHODID_MERGE:
          serviceImpl.merge((io.deephaven.proto.backplane.grpc.MergeRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse>) responseObserver);
          break;
        case METHODID_GET_TABLE:
          serviceImpl.getTable((io.deephaven.proto.backplane.grpc.GetTableRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ExportedTableCreationResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class PartitionedTableServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    PartitionedTableServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.deephaven.proto.backplane.grpc.Partitionedtable.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("PartitionedTableService");
    }
  }

  private static final class PartitionedTableServiceFileDescriptorSupplier
      extends PartitionedTableServiceBaseDescriptorSupplier {
    PartitionedTableServiceFileDescriptorSupplier() {}
  }

  private static final class PartitionedTableServiceMethodDescriptorSupplier
      extends PartitionedTableServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    PartitionedTableServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (PartitionedTableServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new PartitionedTableServiceFileDescriptorSupplier())
              .addMethod(getPartitionByMethod())
              .addMethod(getMergeMethod())
              .addMethod(getGetTableMethod())
              .build();
        }
      }
    }
    return result;
  }
}
