package io.deephaven.proto.backplane.grpc;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * User supplied Flight.Ticket(s) should begin with 'e' byte followed by an signed little-endian int. The client is only
 * allowed to use the positive exportId key-space (client generated exportIds should be greater than 0). The client is
 * encouraged to use a packed ranges of ids as this yields the smallest footprint server side for long running sessions.
 * The client is responsible for releasing all Flight.Tickets that they create or that were created for them via a gRPC
 * call. The documentation for the gRPC call will indicate that the exports must be released. Exports that need to be
 * released will always be communicated over the session's ExportNotification stream.
 * When a session ends, either explicitly or due to timeout, all exported objects in that session are released
 * automatically.
 * Some parts of the API return a Flight.Ticket that does not need to be released. It is not an error to attempt to
 * release them.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.50.2)",
    comments = "Source: deephaven/proto/session.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class SessionServiceGrpc {

  private SessionServiceGrpc() {}

  public static final String SERVICE_NAME = "io.deephaven.proto.backplane.grpc.SessionService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.HandshakeRequest,
      io.deephaven.proto.backplane.grpc.HandshakeResponse> getNewSessionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "NewSession",
      requestType = io.deephaven.proto.backplane.grpc.HandshakeRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.HandshakeResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.HandshakeRequest,
      io.deephaven.proto.backplane.grpc.HandshakeResponse> getNewSessionMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.HandshakeRequest, io.deephaven.proto.backplane.grpc.HandshakeResponse> getNewSessionMethod;
    if ((getNewSessionMethod = SessionServiceGrpc.getNewSessionMethod) == null) {
      synchronized (SessionServiceGrpc.class) {
        if ((getNewSessionMethod = SessionServiceGrpc.getNewSessionMethod) == null) {
          SessionServiceGrpc.getNewSessionMethod = getNewSessionMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.HandshakeRequest, io.deephaven.proto.backplane.grpc.HandshakeResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "NewSession"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.HandshakeRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.HandshakeResponse.getDefaultInstance()))
              .setSchemaDescriptor(new SessionServiceMethodDescriptorSupplier("NewSession"))
              .build();
        }
      }
    }
    return getNewSessionMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.HandshakeRequest,
      io.deephaven.proto.backplane.grpc.HandshakeResponse> getRefreshSessionTokenMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RefreshSessionToken",
      requestType = io.deephaven.proto.backplane.grpc.HandshakeRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.HandshakeResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.HandshakeRequest,
      io.deephaven.proto.backplane.grpc.HandshakeResponse> getRefreshSessionTokenMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.HandshakeRequest, io.deephaven.proto.backplane.grpc.HandshakeResponse> getRefreshSessionTokenMethod;
    if ((getRefreshSessionTokenMethod = SessionServiceGrpc.getRefreshSessionTokenMethod) == null) {
      synchronized (SessionServiceGrpc.class) {
        if ((getRefreshSessionTokenMethod = SessionServiceGrpc.getRefreshSessionTokenMethod) == null) {
          SessionServiceGrpc.getRefreshSessionTokenMethod = getRefreshSessionTokenMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.HandshakeRequest, io.deephaven.proto.backplane.grpc.HandshakeResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RefreshSessionToken"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.HandshakeRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.HandshakeResponse.getDefaultInstance()))
              .setSchemaDescriptor(new SessionServiceMethodDescriptorSupplier("RefreshSessionToken"))
              .build();
        }
      }
    }
    return getRefreshSessionTokenMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.HandshakeRequest,
      io.deephaven.proto.backplane.grpc.CloseSessionResponse> getCloseSessionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CloseSession",
      requestType = io.deephaven.proto.backplane.grpc.HandshakeRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.CloseSessionResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.HandshakeRequest,
      io.deephaven.proto.backplane.grpc.CloseSessionResponse> getCloseSessionMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.HandshakeRequest, io.deephaven.proto.backplane.grpc.CloseSessionResponse> getCloseSessionMethod;
    if ((getCloseSessionMethod = SessionServiceGrpc.getCloseSessionMethod) == null) {
      synchronized (SessionServiceGrpc.class) {
        if ((getCloseSessionMethod = SessionServiceGrpc.getCloseSessionMethod) == null) {
          SessionServiceGrpc.getCloseSessionMethod = getCloseSessionMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.HandshakeRequest, io.deephaven.proto.backplane.grpc.CloseSessionResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CloseSession"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.HandshakeRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.CloseSessionResponse.getDefaultInstance()))
              .setSchemaDescriptor(new SessionServiceMethodDescriptorSupplier("CloseSession"))
              .build();
        }
      }
    }
    return getCloseSessionMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.ReleaseRequest,
      io.deephaven.proto.backplane.grpc.ReleaseResponse> getReleaseMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Release",
      requestType = io.deephaven.proto.backplane.grpc.ReleaseRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.ReleaseResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.ReleaseRequest,
      io.deephaven.proto.backplane.grpc.ReleaseResponse> getReleaseMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.ReleaseRequest, io.deephaven.proto.backplane.grpc.ReleaseResponse> getReleaseMethod;
    if ((getReleaseMethod = SessionServiceGrpc.getReleaseMethod) == null) {
      synchronized (SessionServiceGrpc.class) {
        if ((getReleaseMethod = SessionServiceGrpc.getReleaseMethod) == null) {
          SessionServiceGrpc.getReleaseMethod = getReleaseMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.ReleaseRequest, io.deephaven.proto.backplane.grpc.ReleaseResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Release"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.ReleaseRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.ReleaseResponse.getDefaultInstance()))
              .setSchemaDescriptor(new SessionServiceMethodDescriptorSupplier("Release"))
              .build();
        }
      }
    }
    return getReleaseMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.ExportRequest,
      io.deephaven.proto.backplane.grpc.ExportResponse> getExportFromTicketMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ExportFromTicket",
      requestType = io.deephaven.proto.backplane.grpc.ExportRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.ExportResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.ExportRequest,
      io.deephaven.proto.backplane.grpc.ExportResponse> getExportFromTicketMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.ExportRequest, io.deephaven.proto.backplane.grpc.ExportResponse> getExportFromTicketMethod;
    if ((getExportFromTicketMethod = SessionServiceGrpc.getExportFromTicketMethod) == null) {
      synchronized (SessionServiceGrpc.class) {
        if ((getExportFromTicketMethod = SessionServiceGrpc.getExportFromTicketMethod) == null) {
          SessionServiceGrpc.getExportFromTicketMethod = getExportFromTicketMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.ExportRequest, io.deephaven.proto.backplane.grpc.ExportResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ExportFromTicket"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.ExportRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.ExportResponse.getDefaultInstance()))
              .setSchemaDescriptor(new SessionServiceMethodDescriptorSupplier("ExportFromTicket"))
              .build();
        }
      }
    }
    return getExportFromTicketMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.PublishRequest,
      io.deephaven.proto.backplane.grpc.PublishResponse> getPublishFromTicketMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "PublishFromTicket",
      requestType = io.deephaven.proto.backplane.grpc.PublishRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.PublishResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.PublishRequest,
      io.deephaven.proto.backplane.grpc.PublishResponse> getPublishFromTicketMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.PublishRequest, io.deephaven.proto.backplane.grpc.PublishResponse> getPublishFromTicketMethod;
    if ((getPublishFromTicketMethod = SessionServiceGrpc.getPublishFromTicketMethod) == null) {
      synchronized (SessionServiceGrpc.class) {
        if ((getPublishFromTicketMethod = SessionServiceGrpc.getPublishFromTicketMethod) == null) {
          SessionServiceGrpc.getPublishFromTicketMethod = getPublishFromTicketMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.PublishRequest, io.deephaven.proto.backplane.grpc.PublishResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "PublishFromTicket"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.PublishRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.PublishResponse.getDefaultInstance()))
              .setSchemaDescriptor(new SessionServiceMethodDescriptorSupplier("PublishFromTicket"))
              .build();
        }
      }
    }
    return getPublishFromTicketMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.ExportNotificationRequest,
      io.deephaven.proto.backplane.grpc.ExportNotification> getExportNotificationsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ExportNotifications",
      requestType = io.deephaven.proto.backplane.grpc.ExportNotificationRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.ExportNotification.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.ExportNotificationRequest,
      io.deephaven.proto.backplane.grpc.ExportNotification> getExportNotificationsMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.ExportNotificationRequest, io.deephaven.proto.backplane.grpc.ExportNotification> getExportNotificationsMethod;
    if ((getExportNotificationsMethod = SessionServiceGrpc.getExportNotificationsMethod) == null) {
      synchronized (SessionServiceGrpc.class) {
        if ((getExportNotificationsMethod = SessionServiceGrpc.getExportNotificationsMethod) == null) {
          SessionServiceGrpc.getExportNotificationsMethod = getExportNotificationsMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.ExportNotificationRequest, io.deephaven.proto.backplane.grpc.ExportNotification>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ExportNotifications"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.ExportNotificationRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.ExportNotification.getDefaultInstance()))
              .setSchemaDescriptor(new SessionServiceMethodDescriptorSupplier("ExportNotifications"))
              .build();
        }
      }
    }
    return getExportNotificationsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.TerminationNotificationRequest,
      io.deephaven.proto.backplane.grpc.TerminationNotificationResponse> getTerminationNotificationMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "TerminationNotification",
      requestType = io.deephaven.proto.backplane.grpc.TerminationNotificationRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.TerminationNotificationResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.TerminationNotificationRequest,
      io.deephaven.proto.backplane.grpc.TerminationNotificationResponse> getTerminationNotificationMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.TerminationNotificationRequest, io.deephaven.proto.backplane.grpc.TerminationNotificationResponse> getTerminationNotificationMethod;
    if ((getTerminationNotificationMethod = SessionServiceGrpc.getTerminationNotificationMethod) == null) {
      synchronized (SessionServiceGrpc.class) {
        if ((getTerminationNotificationMethod = SessionServiceGrpc.getTerminationNotificationMethod) == null) {
          SessionServiceGrpc.getTerminationNotificationMethod = getTerminationNotificationMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.TerminationNotificationRequest, io.deephaven.proto.backplane.grpc.TerminationNotificationResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "TerminationNotification"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.TerminationNotificationRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.TerminationNotificationResponse.getDefaultInstance()))
              .setSchemaDescriptor(new SessionServiceMethodDescriptorSupplier("TerminationNotification"))
              .build();
        }
      }
    }
    return getTerminationNotificationMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static SessionServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<SessionServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<SessionServiceStub>() {
        @java.lang.Override
        public SessionServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new SessionServiceStub(channel, callOptions);
        }
      };
    return SessionServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static SessionServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<SessionServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<SessionServiceBlockingStub>() {
        @java.lang.Override
        public SessionServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new SessionServiceBlockingStub(channel, callOptions);
        }
      };
    return SessionServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static SessionServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<SessionServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<SessionServiceFutureStub>() {
        @java.lang.Override
        public SessionServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new SessionServiceFutureStub(channel, callOptions);
        }
      };
    return SessionServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * User supplied Flight.Ticket(s) should begin with 'e' byte followed by an signed little-endian int. The client is only
   * allowed to use the positive exportId key-space (client generated exportIds should be greater than 0). The client is
   * encouraged to use a packed ranges of ids as this yields the smallest footprint server side for long running sessions.
   * The client is responsible for releasing all Flight.Tickets that they create or that were created for them via a gRPC
   * call. The documentation for the gRPC call will indicate that the exports must be released. Exports that need to be
   * released will always be communicated over the session's ExportNotification stream.
   * When a session ends, either explicitly or due to timeout, all exported objects in that session are released
   * automatically.
   * Some parts of the API return a Flight.Ticket that does not need to be released. It is not an error to attempt to
   * release them.
   * </pre>
   */
  public static abstract class SessionServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Handshake between client and server to create a new session. The response includes a metadata header name and the
     * token to send on every subsequent request. The auth mechanisms here are unary to best support grpc-web.
     * Deprecated: Please use Flight's Handshake or http authorization headers instead.
     * </pre>
     */
    @java.lang.Deprecated
    public void newSession(io.deephaven.proto.backplane.grpc.HandshakeRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.HandshakeResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getNewSessionMethod(), responseObserver);
    }

    /**
     * <pre>
     * Keep-alive a given token to ensure that a session is not cleaned prematurely. The response may include an updated
     * token that should replace the existing token for subsequent requests.
     * Deprecated: Please use Flight's Handshake with an empty payload.
     * </pre>
     */
    @java.lang.Deprecated
    public void refreshSessionToken(io.deephaven.proto.backplane.grpc.HandshakeRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.HandshakeResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getRefreshSessionTokenMethod(), responseObserver);
    }

    /**
     * <pre>
     * Proactively close an open session. Sessions will automatically close on timeout. When a session is closed, all
     * unreleased exports will be automatically released.
     * </pre>
     */
    public void closeSession(io.deephaven.proto.backplane.grpc.HandshakeRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.CloseSessionResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCloseSessionMethod(), responseObserver);
    }

    /**
     * <pre>
     * Attempts to release an export by its ticket. Returns true if an existing export was found. It is the client's
     * responsibility to release all resources they no longer want the server to hold on to. Proactively cancels work; do
     * not release a ticket that is needed by dependent work that has not yet finished
     * (i.e. the dependencies that are staying around should first be in EXPORTED state).
     * </pre>
     */
    public void release(io.deephaven.proto.backplane.grpc.ReleaseRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ReleaseResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getReleaseMethod(), responseObserver);
    }

    /**
     * <pre>
     * Makes a copy from a source ticket to a client managed result ticket. The source ticket does not need to be
     * a client managed ticket.
     * </pre>
     */
    public void exportFromTicket(io.deephaven.proto.backplane.grpc.ExportRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ExportResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getExportFromTicketMethod(), responseObserver);
    }

    /**
     * <pre>
     * Makes a copy from a source ticket and publishes to a result ticket. Neither the source ticket, nor the destination
     * ticket, need to be a client managed ticket.
     * </pre>
     */
    public void publishFromTicket(io.deephaven.proto.backplane.grpc.PublishRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.PublishResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getPublishFromTicketMethod(), responseObserver);
    }

    /**
     * <pre>
     * Establish a stream to manage all session exports, including those lost due to partially complete rpc calls.
     * New streams will flush notifications for all un-released exports, prior to seeing any new or updated exports
     * for all live exports. After the refresh of existing state, subscribers will receive notifications of new and
     * updated exports. An export id of zero will be sent to indicate all pre-existing exports have been sent.
     * </pre>
     */
    public void exportNotifications(io.deephaven.proto.backplane.grpc.ExportNotificationRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ExportNotification> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getExportNotificationsMethod(), responseObserver);
    }

    /**
     * <pre>
     * Receive a best-effort message on-exit indicating why this server is exiting. Reception of this message cannot be
     * guaranteed.
     * </pre>
     */
    public void terminationNotification(io.deephaven.proto.backplane.grpc.TerminationNotificationRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.TerminationNotificationResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getTerminationNotificationMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getNewSessionMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.HandshakeRequest,
                io.deephaven.proto.backplane.grpc.HandshakeResponse>(
                  this, METHODID_NEW_SESSION)))
          .addMethod(
            getRefreshSessionTokenMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.HandshakeRequest,
                io.deephaven.proto.backplane.grpc.HandshakeResponse>(
                  this, METHODID_REFRESH_SESSION_TOKEN)))
          .addMethod(
            getCloseSessionMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.HandshakeRequest,
                io.deephaven.proto.backplane.grpc.CloseSessionResponse>(
                  this, METHODID_CLOSE_SESSION)))
          .addMethod(
            getReleaseMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.ReleaseRequest,
                io.deephaven.proto.backplane.grpc.ReleaseResponse>(
                  this, METHODID_RELEASE)))
          .addMethod(
            getExportFromTicketMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.ExportRequest,
                io.deephaven.proto.backplane.grpc.ExportResponse>(
                  this, METHODID_EXPORT_FROM_TICKET)))
          .addMethod(
            getPublishFromTicketMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.PublishRequest,
                io.deephaven.proto.backplane.grpc.PublishResponse>(
                  this, METHODID_PUBLISH_FROM_TICKET)))
          .addMethod(
            getExportNotificationsMethod(),
            io.grpc.stub.ServerCalls.asyncServerStreamingCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.ExportNotificationRequest,
                io.deephaven.proto.backplane.grpc.ExportNotification>(
                  this, METHODID_EXPORT_NOTIFICATIONS)))
          .addMethod(
            getTerminationNotificationMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.TerminationNotificationRequest,
                io.deephaven.proto.backplane.grpc.TerminationNotificationResponse>(
                  this, METHODID_TERMINATION_NOTIFICATION)))
          .build();
    }
  }

  /**
   * <pre>
   * User supplied Flight.Ticket(s) should begin with 'e' byte followed by an signed little-endian int. The client is only
   * allowed to use the positive exportId key-space (client generated exportIds should be greater than 0). The client is
   * encouraged to use a packed ranges of ids as this yields the smallest footprint server side for long running sessions.
   * The client is responsible for releasing all Flight.Tickets that they create or that were created for them via a gRPC
   * call. The documentation for the gRPC call will indicate that the exports must be released. Exports that need to be
   * released will always be communicated over the session's ExportNotification stream.
   * When a session ends, either explicitly or due to timeout, all exported objects in that session are released
   * automatically.
   * Some parts of the API return a Flight.Ticket that does not need to be released. It is not an error to attempt to
   * release them.
   * </pre>
   */
  public static final class SessionServiceStub extends io.grpc.stub.AbstractAsyncStub<SessionServiceStub> {
    private SessionServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected SessionServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new SessionServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Handshake between client and server to create a new session. The response includes a metadata header name and the
     * token to send on every subsequent request. The auth mechanisms here are unary to best support grpc-web.
     * Deprecated: Please use Flight's Handshake or http authorization headers instead.
     * </pre>
     */
    @java.lang.Deprecated
    public void newSession(io.deephaven.proto.backplane.grpc.HandshakeRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.HandshakeResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getNewSessionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Keep-alive a given token to ensure that a session is not cleaned prematurely. The response may include an updated
     * token that should replace the existing token for subsequent requests.
     * Deprecated: Please use Flight's Handshake with an empty payload.
     * </pre>
     */
    @java.lang.Deprecated
    public void refreshSessionToken(io.deephaven.proto.backplane.grpc.HandshakeRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.HandshakeResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getRefreshSessionTokenMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Proactively close an open session. Sessions will automatically close on timeout. When a session is closed, all
     * unreleased exports will be automatically released.
     * </pre>
     */
    public void closeSession(io.deephaven.proto.backplane.grpc.HandshakeRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.CloseSessionResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCloseSessionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Attempts to release an export by its ticket. Returns true if an existing export was found. It is the client's
     * responsibility to release all resources they no longer want the server to hold on to. Proactively cancels work; do
     * not release a ticket that is needed by dependent work that has not yet finished
     * (i.e. the dependencies that are staying around should first be in EXPORTED state).
     * </pre>
     */
    public void release(io.deephaven.proto.backplane.grpc.ReleaseRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ReleaseResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getReleaseMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Makes a copy from a source ticket to a client managed result ticket. The source ticket does not need to be
     * a client managed ticket.
     * </pre>
     */
    public void exportFromTicket(io.deephaven.proto.backplane.grpc.ExportRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ExportResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getExportFromTicketMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Makes a copy from a source ticket and publishes to a result ticket. Neither the source ticket, nor the destination
     * ticket, need to be a client managed ticket.
     * </pre>
     */
    public void publishFromTicket(io.deephaven.proto.backplane.grpc.PublishRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.PublishResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getPublishFromTicketMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Establish a stream to manage all session exports, including those lost due to partially complete rpc calls.
     * New streams will flush notifications for all un-released exports, prior to seeing any new or updated exports
     * for all live exports. After the refresh of existing state, subscribers will receive notifications of new and
     * updated exports. An export id of zero will be sent to indicate all pre-existing exports have been sent.
     * </pre>
     */
    public void exportNotifications(io.deephaven.proto.backplane.grpc.ExportNotificationRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ExportNotification> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getExportNotificationsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Receive a best-effort message on-exit indicating why this server is exiting. Reception of this message cannot be
     * guaranteed.
     * </pre>
     */
    public void terminationNotification(io.deephaven.proto.backplane.grpc.TerminationNotificationRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.TerminationNotificationResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getTerminationNotificationMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * User supplied Flight.Ticket(s) should begin with 'e' byte followed by an signed little-endian int. The client is only
   * allowed to use the positive exportId key-space (client generated exportIds should be greater than 0). The client is
   * encouraged to use a packed ranges of ids as this yields the smallest footprint server side for long running sessions.
   * The client is responsible for releasing all Flight.Tickets that they create or that were created for them via a gRPC
   * call. The documentation for the gRPC call will indicate that the exports must be released. Exports that need to be
   * released will always be communicated over the session's ExportNotification stream.
   * When a session ends, either explicitly or due to timeout, all exported objects in that session are released
   * automatically.
   * Some parts of the API return a Flight.Ticket that does not need to be released. It is not an error to attempt to
   * release them.
   * </pre>
   */
  public static final class SessionServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<SessionServiceBlockingStub> {
    private SessionServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected SessionServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new SessionServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Handshake between client and server to create a new session. The response includes a metadata header name and the
     * token to send on every subsequent request. The auth mechanisms here are unary to best support grpc-web.
     * Deprecated: Please use Flight's Handshake or http authorization headers instead.
     * </pre>
     */
    @java.lang.Deprecated
    public io.deephaven.proto.backplane.grpc.HandshakeResponse newSession(io.deephaven.proto.backplane.grpc.HandshakeRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getNewSessionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Keep-alive a given token to ensure that a session is not cleaned prematurely. The response may include an updated
     * token that should replace the existing token for subsequent requests.
     * Deprecated: Please use Flight's Handshake with an empty payload.
     * </pre>
     */
    @java.lang.Deprecated
    public io.deephaven.proto.backplane.grpc.HandshakeResponse refreshSessionToken(io.deephaven.proto.backplane.grpc.HandshakeRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getRefreshSessionTokenMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Proactively close an open session. Sessions will automatically close on timeout. When a session is closed, all
     * unreleased exports will be automatically released.
     * </pre>
     */
    public io.deephaven.proto.backplane.grpc.CloseSessionResponse closeSession(io.deephaven.proto.backplane.grpc.HandshakeRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCloseSessionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Attempts to release an export by its ticket. Returns true if an existing export was found. It is the client's
     * responsibility to release all resources they no longer want the server to hold on to. Proactively cancels work; do
     * not release a ticket that is needed by dependent work that has not yet finished
     * (i.e. the dependencies that are staying around should first be in EXPORTED state).
     * </pre>
     */
    public io.deephaven.proto.backplane.grpc.ReleaseResponse release(io.deephaven.proto.backplane.grpc.ReleaseRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getReleaseMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Makes a copy from a source ticket to a client managed result ticket. The source ticket does not need to be
     * a client managed ticket.
     * </pre>
     */
    public io.deephaven.proto.backplane.grpc.ExportResponse exportFromTicket(io.deephaven.proto.backplane.grpc.ExportRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getExportFromTicketMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Makes a copy from a source ticket and publishes to a result ticket. Neither the source ticket, nor the destination
     * ticket, need to be a client managed ticket.
     * </pre>
     */
    public io.deephaven.proto.backplane.grpc.PublishResponse publishFromTicket(io.deephaven.proto.backplane.grpc.PublishRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getPublishFromTicketMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Establish a stream to manage all session exports, including those lost due to partially complete rpc calls.
     * New streams will flush notifications for all un-released exports, prior to seeing any new or updated exports
     * for all live exports. After the refresh of existing state, subscribers will receive notifications of new and
     * updated exports. An export id of zero will be sent to indicate all pre-existing exports have been sent.
     * </pre>
     */
    public java.util.Iterator<io.deephaven.proto.backplane.grpc.ExportNotification> exportNotifications(
        io.deephaven.proto.backplane.grpc.ExportNotificationRequest request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getExportNotificationsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Receive a best-effort message on-exit indicating why this server is exiting. Reception of this message cannot be
     * guaranteed.
     * </pre>
     */
    public io.deephaven.proto.backplane.grpc.TerminationNotificationResponse terminationNotification(io.deephaven.proto.backplane.grpc.TerminationNotificationRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getTerminationNotificationMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * User supplied Flight.Ticket(s) should begin with 'e' byte followed by an signed little-endian int. The client is only
   * allowed to use the positive exportId key-space (client generated exportIds should be greater than 0). The client is
   * encouraged to use a packed ranges of ids as this yields the smallest footprint server side for long running sessions.
   * The client is responsible for releasing all Flight.Tickets that they create or that were created for them via a gRPC
   * call. The documentation for the gRPC call will indicate that the exports must be released. Exports that need to be
   * released will always be communicated over the session's ExportNotification stream.
   * When a session ends, either explicitly or due to timeout, all exported objects in that session are released
   * automatically.
   * Some parts of the API return a Flight.Ticket that does not need to be released. It is not an error to attempt to
   * release them.
   * </pre>
   */
  public static final class SessionServiceFutureStub extends io.grpc.stub.AbstractFutureStub<SessionServiceFutureStub> {
    private SessionServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected SessionServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new SessionServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Handshake between client and server to create a new session. The response includes a metadata header name and the
     * token to send on every subsequent request. The auth mechanisms here are unary to best support grpc-web.
     * Deprecated: Please use Flight's Handshake or http authorization headers instead.
     * </pre>
     */
    @java.lang.Deprecated
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.HandshakeResponse> newSession(
        io.deephaven.proto.backplane.grpc.HandshakeRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getNewSessionMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Keep-alive a given token to ensure that a session is not cleaned prematurely. The response may include an updated
     * token that should replace the existing token for subsequent requests.
     * Deprecated: Please use Flight's Handshake with an empty payload.
     * </pre>
     */
    @java.lang.Deprecated
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.HandshakeResponse> refreshSessionToken(
        io.deephaven.proto.backplane.grpc.HandshakeRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getRefreshSessionTokenMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Proactively close an open session. Sessions will automatically close on timeout. When a session is closed, all
     * unreleased exports will be automatically released.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.CloseSessionResponse> closeSession(
        io.deephaven.proto.backplane.grpc.HandshakeRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCloseSessionMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Attempts to release an export by its ticket. Returns true if an existing export was found. It is the client's
     * responsibility to release all resources they no longer want the server to hold on to. Proactively cancels work; do
     * not release a ticket that is needed by dependent work that has not yet finished
     * (i.e. the dependencies that are staying around should first be in EXPORTED state).
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.ReleaseResponse> release(
        io.deephaven.proto.backplane.grpc.ReleaseRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getReleaseMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Makes a copy from a source ticket to a client managed result ticket. The source ticket does not need to be
     * a client managed ticket.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.ExportResponse> exportFromTicket(
        io.deephaven.proto.backplane.grpc.ExportRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getExportFromTicketMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Makes a copy from a source ticket and publishes to a result ticket. Neither the source ticket, nor the destination
     * ticket, need to be a client managed ticket.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.PublishResponse> publishFromTicket(
        io.deephaven.proto.backplane.grpc.PublishRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getPublishFromTicketMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Receive a best-effort message on-exit indicating why this server is exiting. Reception of this message cannot be
     * guaranteed.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.TerminationNotificationResponse> terminationNotification(
        io.deephaven.proto.backplane.grpc.TerminationNotificationRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getTerminationNotificationMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_NEW_SESSION = 0;
  private static final int METHODID_REFRESH_SESSION_TOKEN = 1;
  private static final int METHODID_CLOSE_SESSION = 2;
  private static final int METHODID_RELEASE = 3;
  private static final int METHODID_EXPORT_FROM_TICKET = 4;
  private static final int METHODID_PUBLISH_FROM_TICKET = 5;
  private static final int METHODID_EXPORT_NOTIFICATIONS = 6;
  private static final int METHODID_TERMINATION_NOTIFICATION = 7;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final SessionServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(SessionServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_NEW_SESSION:
          serviceImpl.newSession((io.deephaven.proto.backplane.grpc.HandshakeRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.HandshakeResponse>) responseObserver);
          break;
        case METHODID_REFRESH_SESSION_TOKEN:
          serviceImpl.refreshSessionToken((io.deephaven.proto.backplane.grpc.HandshakeRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.HandshakeResponse>) responseObserver);
          break;
        case METHODID_CLOSE_SESSION:
          serviceImpl.closeSession((io.deephaven.proto.backplane.grpc.HandshakeRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.CloseSessionResponse>) responseObserver);
          break;
        case METHODID_RELEASE:
          serviceImpl.release((io.deephaven.proto.backplane.grpc.ReleaseRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ReleaseResponse>) responseObserver);
          break;
        case METHODID_EXPORT_FROM_TICKET:
          serviceImpl.exportFromTicket((io.deephaven.proto.backplane.grpc.ExportRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ExportResponse>) responseObserver);
          break;
        case METHODID_PUBLISH_FROM_TICKET:
          serviceImpl.publishFromTicket((io.deephaven.proto.backplane.grpc.PublishRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.PublishResponse>) responseObserver);
          break;
        case METHODID_EXPORT_NOTIFICATIONS:
          serviceImpl.exportNotifications((io.deephaven.proto.backplane.grpc.ExportNotificationRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ExportNotification>) responseObserver);
          break;
        case METHODID_TERMINATION_NOTIFICATION:
          serviceImpl.terminationNotification((io.deephaven.proto.backplane.grpc.TerminationNotificationRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.TerminationNotificationResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class SessionServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    SessionServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.deephaven.proto.backplane.grpc.Session.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("SessionService");
    }
  }

  private static final class SessionServiceFileDescriptorSupplier
      extends SessionServiceBaseDescriptorSupplier {
    SessionServiceFileDescriptorSupplier() {}
  }

  private static final class SessionServiceMethodDescriptorSupplier
      extends SessionServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    SessionServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (SessionServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new SessionServiceFileDescriptorSupplier())
              .addMethod(getNewSessionMethod())
              .addMethod(getRefreshSessionTokenMethod())
              .addMethod(getCloseSessionMethod())
              .addMethod(getReleaseMethod())
              .addMethod(getExportFromTicketMethod())
              .addMethod(getPublishFromTicketMethod())
              .addMethod(getExportNotificationsMethod())
              .addMethod(getTerminationNotificationMethod())
              .build();
        }
      }
    }
    return result;
  }
}
