package io.deephaven.proto.backplane.grpc;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * Shared storage management service.
 * Operations may fail (or omit data) if the current session does not have permission to read or write that resource.
 * Paths will be "/" delimited and must start with a leading slash.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.50.2)",
    comments = "Source: deephaven/proto/storage.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class StorageServiceGrpc {

  private StorageServiceGrpc() {}

  public static final String SERVICE_NAME = "io.deephaven.proto.backplane.grpc.StorageService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.ListItemsRequest,
      io.deephaven.proto.backplane.grpc.ListItemsResponse> getListItemsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListItems",
      requestType = io.deephaven.proto.backplane.grpc.ListItemsRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.ListItemsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.ListItemsRequest,
      io.deephaven.proto.backplane.grpc.ListItemsResponse> getListItemsMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.ListItemsRequest, io.deephaven.proto.backplane.grpc.ListItemsResponse> getListItemsMethod;
    if ((getListItemsMethod = StorageServiceGrpc.getListItemsMethod) == null) {
      synchronized (StorageServiceGrpc.class) {
        if ((getListItemsMethod = StorageServiceGrpc.getListItemsMethod) == null) {
          StorageServiceGrpc.getListItemsMethod = getListItemsMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.ListItemsRequest, io.deephaven.proto.backplane.grpc.ListItemsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListItems"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.ListItemsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.ListItemsResponse.getDefaultInstance()))
              .setSchemaDescriptor(new StorageServiceMethodDescriptorSupplier("ListItems"))
              .build();
        }
      }
    }
    return getListItemsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.FetchFileRequest,
      io.deephaven.proto.backplane.grpc.FetchFileResponse> getFetchFileMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "FetchFile",
      requestType = io.deephaven.proto.backplane.grpc.FetchFileRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.FetchFileResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.FetchFileRequest,
      io.deephaven.proto.backplane.grpc.FetchFileResponse> getFetchFileMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.FetchFileRequest, io.deephaven.proto.backplane.grpc.FetchFileResponse> getFetchFileMethod;
    if ((getFetchFileMethod = StorageServiceGrpc.getFetchFileMethod) == null) {
      synchronized (StorageServiceGrpc.class) {
        if ((getFetchFileMethod = StorageServiceGrpc.getFetchFileMethod) == null) {
          StorageServiceGrpc.getFetchFileMethod = getFetchFileMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.FetchFileRequest, io.deephaven.proto.backplane.grpc.FetchFileResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "FetchFile"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.FetchFileRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.FetchFileResponse.getDefaultInstance()))
              .setSchemaDescriptor(new StorageServiceMethodDescriptorSupplier("FetchFile"))
              .build();
        }
      }
    }
    return getFetchFileMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.SaveFileRequest,
      io.deephaven.proto.backplane.grpc.SaveFileResponse> getSaveFileMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SaveFile",
      requestType = io.deephaven.proto.backplane.grpc.SaveFileRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.SaveFileResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.SaveFileRequest,
      io.deephaven.proto.backplane.grpc.SaveFileResponse> getSaveFileMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.SaveFileRequest, io.deephaven.proto.backplane.grpc.SaveFileResponse> getSaveFileMethod;
    if ((getSaveFileMethod = StorageServiceGrpc.getSaveFileMethod) == null) {
      synchronized (StorageServiceGrpc.class) {
        if ((getSaveFileMethod = StorageServiceGrpc.getSaveFileMethod) == null) {
          StorageServiceGrpc.getSaveFileMethod = getSaveFileMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.SaveFileRequest, io.deephaven.proto.backplane.grpc.SaveFileResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "SaveFile"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.SaveFileRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.SaveFileResponse.getDefaultInstance()))
              .setSchemaDescriptor(new StorageServiceMethodDescriptorSupplier("SaveFile"))
              .build();
        }
      }
    }
    return getSaveFileMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.MoveItemRequest,
      io.deephaven.proto.backplane.grpc.MoveItemResponse> getMoveItemMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "MoveItem",
      requestType = io.deephaven.proto.backplane.grpc.MoveItemRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.MoveItemResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.MoveItemRequest,
      io.deephaven.proto.backplane.grpc.MoveItemResponse> getMoveItemMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.MoveItemRequest, io.deephaven.proto.backplane.grpc.MoveItemResponse> getMoveItemMethod;
    if ((getMoveItemMethod = StorageServiceGrpc.getMoveItemMethod) == null) {
      synchronized (StorageServiceGrpc.class) {
        if ((getMoveItemMethod = StorageServiceGrpc.getMoveItemMethod) == null) {
          StorageServiceGrpc.getMoveItemMethod = getMoveItemMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.MoveItemRequest, io.deephaven.proto.backplane.grpc.MoveItemResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "MoveItem"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.MoveItemRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.MoveItemResponse.getDefaultInstance()))
              .setSchemaDescriptor(new StorageServiceMethodDescriptorSupplier("MoveItem"))
              .build();
        }
      }
    }
    return getMoveItemMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.CreateDirectoryRequest,
      io.deephaven.proto.backplane.grpc.CreateDirectoryResponse> getCreateDirectoryMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CreateDirectory",
      requestType = io.deephaven.proto.backplane.grpc.CreateDirectoryRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.CreateDirectoryResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.CreateDirectoryRequest,
      io.deephaven.proto.backplane.grpc.CreateDirectoryResponse> getCreateDirectoryMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.CreateDirectoryRequest, io.deephaven.proto.backplane.grpc.CreateDirectoryResponse> getCreateDirectoryMethod;
    if ((getCreateDirectoryMethod = StorageServiceGrpc.getCreateDirectoryMethod) == null) {
      synchronized (StorageServiceGrpc.class) {
        if ((getCreateDirectoryMethod = StorageServiceGrpc.getCreateDirectoryMethod) == null) {
          StorageServiceGrpc.getCreateDirectoryMethod = getCreateDirectoryMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.CreateDirectoryRequest, io.deephaven.proto.backplane.grpc.CreateDirectoryResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CreateDirectory"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.CreateDirectoryRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.CreateDirectoryResponse.getDefaultInstance()))
              .setSchemaDescriptor(new StorageServiceMethodDescriptorSupplier("CreateDirectory"))
              .build();
        }
      }
    }
    return getCreateDirectoryMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.DeleteItemRequest,
      io.deephaven.proto.backplane.grpc.DeleteItemResponse> getDeleteItemMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DeleteItem",
      requestType = io.deephaven.proto.backplane.grpc.DeleteItemRequest.class,
      responseType = io.deephaven.proto.backplane.grpc.DeleteItemResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.DeleteItemRequest,
      io.deephaven.proto.backplane.grpc.DeleteItemResponse> getDeleteItemMethod() {
    io.grpc.MethodDescriptor<io.deephaven.proto.backplane.grpc.DeleteItemRequest, io.deephaven.proto.backplane.grpc.DeleteItemResponse> getDeleteItemMethod;
    if ((getDeleteItemMethod = StorageServiceGrpc.getDeleteItemMethod) == null) {
      synchronized (StorageServiceGrpc.class) {
        if ((getDeleteItemMethod = StorageServiceGrpc.getDeleteItemMethod) == null) {
          StorageServiceGrpc.getDeleteItemMethod = getDeleteItemMethod =
              io.grpc.MethodDescriptor.<io.deephaven.proto.backplane.grpc.DeleteItemRequest, io.deephaven.proto.backplane.grpc.DeleteItemResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DeleteItem"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.DeleteItemRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.deephaven.proto.backplane.grpc.DeleteItemResponse.getDefaultInstance()))
              .setSchemaDescriptor(new StorageServiceMethodDescriptorSupplier("DeleteItem"))
              .build();
        }
      }
    }
    return getDeleteItemMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static StorageServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<StorageServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<StorageServiceStub>() {
        @java.lang.Override
        public StorageServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new StorageServiceStub(channel, callOptions);
        }
      };
    return StorageServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static StorageServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<StorageServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<StorageServiceBlockingStub>() {
        @java.lang.Override
        public StorageServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new StorageServiceBlockingStub(channel, callOptions);
        }
      };
    return StorageServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static StorageServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<StorageServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<StorageServiceFutureStub>() {
        @java.lang.Override
        public StorageServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new StorageServiceFutureStub(channel, callOptions);
        }
      };
    return StorageServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * Shared storage management service.
   * Operations may fail (or omit data) if the current session does not have permission to read or write that resource.
   * Paths will be "/" delimited and must start with a leading slash.
   * </pre>
   */
  public static abstract class StorageServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Lists the files and directories present in a given directory. Will return an error
     * </pre>
     */
    public void listItems(io.deephaven.proto.backplane.grpc.ListItemsRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ListItemsResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getListItemsMethod(), responseObserver);
    }

    /**
     * <pre>
     * Reads the file at the given path. Client can optionally specify an etag, asking the server
     * not to send the file if it hasn't changed.
     * </pre>
     */
    public void fetchFile(io.deephaven.proto.backplane.grpc.FetchFileRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.FetchFileResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getFetchFileMethod(), responseObserver);
    }

    /**
     * <pre>
     * Can create new files or modify existing with client provided contents.
     * </pre>
     */
    public void saveFile(io.deephaven.proto.backplane.grpc.SaveFileRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.SaveFileResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getSaveFileMethod(), responseObserver);
    }

    /**
     * <pre>
     * Moves a file from one path to another.
     * </pre>
     */
    public void moveItem(io.deephaven.proto.backplane.grpc.MoveItemRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.MoveItemResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getMoveItemMethod(), responseObserver);
    }

    /**
     * <pre>
     * Creates a directory at the given path.
     * </pre>
     */
    public void createDirectory(io.deephaven.proto.backplane.grpc.CreateDirectoryRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.CreateDirectoryResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCreateDirectoryMethod(), responseObserver);
    }

    /**
     * <pre>
     * Deletes the file or directory at the given path. Directories must be empty to be deleted.
     * </pre>
     */
    public void deleteItem(io.deephaven.proto.backplane.grpc.DeleteItemRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.DeleteItemResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getDeleteItemMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getListItemsMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.ListItemsRequest,
                io.deephaven.proto.backplane.grpc.ListItemsResponse>(
                  this, METHODID_LIST_ITEMS)))
          .addMethod(
            getFetchFileMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.FetchFileRequest,
                io.deephaven.proto.backplane.grpc.FetchFileResponse>(
                  this, METHODID_FETCH_FILE)))
          .addMethod(
            getSaveFileMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.SaveFileRequest,
                io.deephaven.proto.backplane.grpc.SaveFileResponse>(
                  this, METHODID_SAVE_FILE)))
          .addMethod(
            getMoveItemMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.MoveItemRequest,
                io.deephaven.proto.backplane.grpc.MoveItemResponse>(
                  this, METHODID_MOVE_ITEM)))
          .addMethod(
            getCreateDirectoryMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.CreateDirectoryRequest,
                io.deephaven.proto.backplane.grpc.CreateDirectoryResponse>(
                  this, METHODID_CREATE_DIRECTORY)))
          .addMethod(
            getDeleteItemMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                io.deephaven.proto.backplane.grpc.DeleteItemRequest,
                io.deephaven.proto.backplane.grpc.DeleteItemResponse>(
                  this, METHODID_DELETE_ITEM)))
          .build();
    }
  }

  /**
   * <pre>
   * Shared storage management service.
   * Operations may fail (or omit data) if the current session does not have permission to read or write that resource.
   * Paths will be "/" delimited and must start with a leading slash.
   * </pre>
   */
  public static final class StorageServiceStub extends io.grpc.stub.AbstractAsyncStub<StorageServiceStub> {
    private StorageServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected StorageServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new StorageServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * Lists the files and directories present in a given directory. Will return an error
     * </pre>
     */
    public void listItems(io.deephaven.proto.backplane.grpc.ListItemsRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ListItemsResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getListItemsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Reads the file at the given path. Client can optionally specify an etag, asking the server
     * not to send the file if it hasn't changed.
     * </pre>
     */
    public void fetchFile(io.deephaven.proto.backplane.grpc.FetchFileRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.FetchFileResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getFetchFileMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Can create new files or modify existing with client provided contents.
     * </pre>
     */
    public void saveFile(io.deephaven.proto.backplane.grpc.SaveFileRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.SaveFileResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getSaveFileMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Moves a file from one path to another.
     * </pre>
     */
    public void moveItem(io.deephaven.proto.backplane.grpc.MoveItemRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.MoveItemResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getMoveItemMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Creates a directory at the given path.
     * </pre>
     */
    public void createDirectory(io.deephaven.proto.backplane.grpc.CreateDirectoryRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.CreateDirectoryResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCreateDirectoryMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Deletes the file or directory at the given path. Directories must be empty to be deleted.
     * </pre>
     */
    public void deleteItem(io.deephaven.proto.backplane.grpc.DeleteItemRequest request,
        io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.DeleteItemResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getDeleteItemMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * Shared storage management service.
   * Operations may fail (or omit data) if the current session does not have permission to read or write that resource.
   * Paths will be "/" delimited and must start with a leading slash.
   * </pre>
   */
  public static final class StorageServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<StorageServiceBlockingStub> {
    private StorageServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected StorageServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new StorageServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Lists the files and directories present in a given directory. Will return an error
     * </pre>
     */
    public io.deephaven.proto.backplane.grpc.ListItemsResponse listItems(io.deephaven.proto.backplane.grpc.ListItemsRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getListItemsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Reads the file at the given path. Client can optionally specify an etag, asking the server
     * not to send the file if it hasn't changed.
     * </pre>
     */
    public io.deephaven.proto.backplane.grpc.FetchFileResponse fetchFile(io.deephaven.proto.backplane.grpc.FetchFileRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getFetchFileMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Can create new files or modify existing with client provided contents.
     * </pre>
     */
    public io.deephaven.proto.backplane.grpc.SaveFileResponse saveFile(io.deephaven.proto.backplane.grpc.SaveFileRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getSaveFileMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Moves a file from one path to another.
     * </pre>
     */
    public io.deephaven.proto.backplane.grpc.MoveItemResponse moveItem(io.deephaven.proto.backplane.grpc.MoveItemRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getMoveItemMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Creates a directory at the given path.
     * </pre>
     */
    public io.deephaven.proto.backplane.grpc.CreateDirectoryResponse createDirectory(io.deephaven.proto.backplane.grpc.CreateDirectoryRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCreateDirectoryMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Deletes the file or directory at the given path. Directories must be empty to be deleted.
     * </pre>
     */
    public io.deephaven.proto.backplane.grpc.DeleteItemResponse deleteItem(io.deephaven.proto.backplane.grpc.DeleteItemRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getDeleteItemMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * Shared storage management service.
   * Operations may fail (or omit data) if the current session does not have permission to read or write that resource.
   * Paths will be "/" delimited and must start with a leading slash.
   * </pre>
   */
  public static final class StorageServiceFutureStub extends io.grpc.stub.AbstractFutureStub<StorageServiceFutureStub> {
    private StorageServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected StorageServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new StorageServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Lists the files and directories present in a given directory. Will return an error
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.ListItemsResponse> listItems(
        io.deephaven.proto.backplane.grpc.ListItemsRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getListItemsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Reads the file at the given path. Client can optionally specify an etag, asking the server
     * not to send the file if it hasn't changed.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.FetchFileResponse> fetchFile(
        io.deephaven.proto.backplane.grpc.FetchFileRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getFetchFileMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Can create new files or modify existing with client provided contents.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.SaveFileResponse> saveFile(
        io.deephaven.proto.backplane.grpc.SaveFileRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getSaveFileMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Moves a file from one path to another.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.MoveItemResponse> moveItem(
        io.deephaven.proto.backplane.grpc.MoveItemRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getMoveItemMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Creates a directory at the given path.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.CreateDirectoryResponse> createDirectory(
        io.deephaven.proto.backplane.grpc.CreateDirectoryRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCreateDirectoryMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Deletes the file or directory at the given path. Directories must be empty to be deleted.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.deephaven.proto.backplane.grpc.DeleteItemResponse> deleteItem(
        io.deephaven.proto.backplane.grpc.DeleteItemRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getDeleteItemMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_LIST_ITEMS = 0;
  private static final int METHODID_FETCH_FILE = 1;
  private static final int METHODID_SAVE_FILE = 2;
  private static final int METHODID_MOVE_ITEM = 3;
  private static final int METHODID_CREATE_DIRECTORY = 4;
  private static final int METHODID_DELETE_ITEM = 5;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final StorageServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(StorageServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_LIST_ITEMS:
          serviceImpl.listItems((io.deephaven.proto.backplane.grpc.ListItemsRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.ListItemsResponse>) responseObserver);
          break;
        case METHODID_FETCH_FILE:
          serviceImpl.fetchFile((io.deephaven.proto.backplane.grpc.FetchFileRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.FetchFileResponse>) responseObserver);
          break;
        case METHODID_SAVE_FILE:
          serviceImpl.saveFile((io.deephaven.proto.backplane.grpc.SaveFileRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.SaveFileResponse>) responseObserver);
          break;
        case METHODID_MOVE_ITEM:
          serviceImpl.moveItem((io.deephaven.proto.backplane.grpc.MoveItemRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.MoveItemResponse>) responseObserver);
          break;
        case METHODID_CREATE_DIRECTORY:
          serviceImpl.createDirectory((io.deephaven.proto.backplane.grpc.CreateDirectoryRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.CreateDirectoryResponse>) responseObserver);
          break;
        case METHODID_DELETE_ITEM:
          serviceImpl.deleteItem((io.deephaven.proto.backplane.grpc.DeleteItemRequest) request,
              (io.grpc.stub.StreamObserver<io.deephaven.proto.backplane.grpc.DeleteItemResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class StorageServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    StorageServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.deephaven.proto.backplane.grpc.Storage.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("StorageService");
    }
  }

  private static final class StorageServiceFileDescriptorSupplier
      extends StorageServiceBaseDescriptorSupplier {
    StorageServiceFileDescriptorSupplier() {}
  }

  private static final class StorageServiceMethodDescriptorSupplier
      extends StorageServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    StorageServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (StorageServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new StorageServiceFileDescriptorSupplier())
              .addMethod(getListItemsMethod())
              .addMethod(getFetchFileMethod())
              .addMethod(getSaveFileMethod())
              .addMethod(getMoveItemMethod())
              .addMethod(getCreateDirectoryMethod())
              .addMethod(getDeleteItemMethod())
              .build();
        }
      }
    }
    return result;
  }
}
