/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.proto;

import io.deephaven.proto.DeephavenChannel;
import io.deephaven.proto.DeephavenChannelMixin;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.stub.AbstractStub;
import java.util.Objects;

final class DeephavenChannelWithCallCredentials
extends DeephavenChannelMixin {
    private final CallCredentials callCredentials;

    public DeephavenChannelWithCallCredentials(DeephavenChannel delegate, CallCredentials callCredentials) {
        super(delegate);
        this.callCredentials = Objects.requireNonNull(callCredentials);
    }

    @Override
    protected <S extends AbstractStub<S>> S mixin(S stub) {
        return (S)stub.withCallCredentials(this.callCredentials);
    }

    @Override
    protected Channel mixinChannel(Channel channel) {
        return new CallCredentialsChannel(channel);
    }

    private final class CallCredentialsChannel
    extends Channel {
        private final Channel delegate;

        public CallCredentialsChannel(Channel delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
            return this.delegate.newCall(methodDescriptor, callOptions.withCallCredentials(DeephavenChannelWithCallCredentials.this.callCredentials));
        }

        public String authority() {
            return this.delegate.authority();
        }
    }
}

