/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.proto.util;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Hex;

public class ApplicationTicketHelper {
    public static final char TICKET_PREFIX = 'a';
    public static final String FLIGHT_DESCRIPTOR_ROUTE = "app";
    public static final String FIELD_PATH_SEGMENT = "field";

    public static List<String> applicationFieldToPath(String applicationId, String fieldName) {
        return Arrays.asList(FLIGHT_DESCRIPTOR_ROUTE, applicationId, FIELD_PATH_SEGMENT, fieldName);
    }

    public static byte[] applicationFieldToBytes(String applicationId, String fieldName) {
        return ("a/" + applicationId + "/f/" + fieldName).getBytes(StandardCharsets.UTF_8);
    }

    public static String toReadableString(byte[] ticket) {
        String ticketAsString;
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        try {
            ticketAsString = decoder.decode(ByteBuffer.wrap(ticket)).toString();
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException(String.format("Failed to decode application field ticket; found '0x%s'", Hex.encodeHexString((byte[])ticket)), e);
        }
        int endOfRoute = ticketAsString.indexOf(47);
        int endOfAppId = ticketAsString.indexOf(47, endOfRoute + 1);
        int endOfFieldSegment = ticketAsString.indexOf(47, endOfAppId + 1);
        if (endOfFieldSegment == -1) {
            throw new IllegalArgumentException(String.format("Application field ticket does not conform to expected format; found '0x%s'", Hex.encodeHexString((byte[])ticket)));
        }
        String appId = ticketAsString.substring(endOfRoute + 1, endOfAppId);
        String fieldName = ticketAsString.substring(endOfFieldSegment + 1);
        return String.format("%s/%s/%s/%s", FLIGHT_DESCRIPTOR_ROUTE, appId, FIELD_PATH_SEGMENT, fieldName);
    }
}

