/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.proto.util;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Hex;

public class ScopeTicketHelper {
    public static final char TICKET_PREFIX = 's';
    public static final String FLIGHT_DESCRIPTOR_ROUTE = "scope";

    public static List<String> nameToPath(String variableName) {
        return Arrays.asList(FLIGHT_DESCRIPTOR_ROUTE, variableName);
    }

    public static byte[] nameToBytes(String variableName) {
        return ("s/" + variableName).getBytes(StandardCharsets.UTF_8);
    }

    public static String toReadableString(byte[] ticket) {
        String ticketAsString;
        if (ticket.length < 3 || ticket[0] != 115 || ticket[1] != 47) {
            throw new IllegalArgumentException(String.format("QueryScope ticket does not conform to expected format; found '0x%s", Hex.encodeHexString((byte[])ticket)));
        }
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        try {
            ticketAsString = decoder.decode(ByteBuffer.wrap(ticket)).toString();
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException(String.format("Failed to decode query scope ticket; found '0x%s'", Hex.encodeHexString((byte[])ticket)), e);
        }
        String fieldName = ticketAsString.substring(2);
        return String.format("%s/%s", FLIGHT_DESCRIPTOR_ROUTE, fieldName);
    }
}

