/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.proto.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Hex;

public class SharedTicketHelper {
    public static final char TICKET_PREFIX = 'h';
    public static final String FLIGHT_DESCRIPTOR_ROUTE = "shared";

    public static List<String> idToPath(byte[] sharedId) {
        return Arrays.asList(FLIGHT_DESCRIPTOR_ROUTE, Hex.encodeHexString((byte[])sharedId));
    }

    public static byte[] idToBytes(byte[] sharedId) {
        byte[] fullTicket = new byte[1 + sharedId.length];
        fullTicket[0] = 104;
        System.arraycopy(sharedId, 0, fullTicket, 1, sharedId.length);
        return fullTicket;
    }

    public static String toReadableString(byte[] ticket) {
        if (ticket.length < 2 || ticket[0] != 104) {
            throw new IllegalArgumentException(String.format("Shared ticket does not conform to expected format; found '0x%s'", Hex.encodeHexString((byte[])ticket)));
        }
        return String.format("%s/0x%s", FLIGHT_DESCRIPTOR_ROUTE, Hex.encodeHexString((ByteBuffer)ByteBuffer.wrap(ticket, 1, ticket.length - 1)));
    }
}

