/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.ssl.config;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.deephaven.annotations.BuildableStyle;
import io.deephaven.ssl.config.Identity;
import io.deephaven.ssl.config.ImmutableIdentityList;
import java.util.List;
import org.immutables.value.Value;

@JsonDeserialize(as=ImmutableIdentityList.class)
@Value.Immutable
@BuildableStyle
public abstract class IdentityList
implements Identity {
    public static IdentityList of(Identity ... identities) {
        return ImmutableIdentityList.builder().addValues(identities).build();
    }

    public static IdentityList of(List<? extends Identity> identities) {
        return ImmutableIdentityList.builder().addAllValues(identities).build();
    }

    public abstract List<Identity> values();

    @Override
    public final <V extends Identity.Visitor<T>, T> T walk(V visitor) {
        return visitor.visit(this);
    }
}

