/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.ssl.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.deephaven.ssl.config.IdentityKeyStore;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="IdentityKeyStore", generator="Immutables")
final class ImmutableIdentityKeyStore
extends IdentityKeyStore {
    private final String path;
    private final String password;
    private final String keystoreType;

    private ImmutableIdentityKeyStore(Builder builder) {
        this.path = builder.path;
        this.password = builder.password;
        this.keystoreType = builder.keystoreType;
    }

    @Override
    @JsonProperty(value="path")
    public String path() {
        return this.path;
    }

    @Override
    @JsonProperty(value="password")
    public String password() {
        return this.password;
    }

    @Override
    @JsonProperty(value="keystoreType")
    public Optional<String> keystoreType() {
        return Optional.ofNullable(this.keystoreType);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIdentityKeyStore && this.equalTo(0, (ImmutableIdentityKeyStore)another);
    }

    private boolean equalTo(int synthetic, ImmutableIdentityKeyStore another) {
        return this.path.equals(another.path) && this.password.equals(another.password) && Objects.equals(this.keystoreType, another.keystoreType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.password.hashCode();
        h += (h << 5) + Objects.hashCode(this.keystoreType);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("IdentityKeyStore{");
        builder.append("path=").append(this.path);
        builder.append(", ");
        builder.append("password=").append(this.password);
        if (this.keystoreType != null) {
            builder.append(", ");
            builder.append("keystoreType=").append(this.keystoreType);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIdentityKeyStore fromJson(Json json) {
        Builder builder = ImmutableIdentityKeyStore.builder();
        if (json.path != null) {
            builder.path(json.path);
        }
        if (json.password != null) {
            builder.password(json.password);
        }
        if (json.keystoreTypeIsSet) {
            builder.keystoreType(json.keystoreType);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IdentityKeyStore", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PATH = 1L;
        private static final long INIT_BIT_PASSWORD = 2L;
        private static final long OPT_BIT_KEYSTORE_TYPE = 1L;
        private long initBits = 3L;
        private long optBits;
        private String path;
        private String password;
        private String keystoreType;

        private Builder() {
        }

        @JsonProperty(value="path")
        public final Builder path(String path) {
            Builder.checkNotIsSet(this.pathIsSet(), "path");
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="password")
        public final Builder password(String password) {
            Builder.checkNotIsSet(this.passwordIsSet(), "password");
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder keystoreType(String keystoreType) {
            Builder.checkNotIsSet(this.keystoreTypeIsSet(), "keystoreType");
            this.keystoreType = Objects.requireNonNull(keystoreType, "keystoreType");
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="keystoreType")
        public final Builder keystoreType(Optional<String> keystoreType) {
            Builder.checkNotIsSet(this.keystoreTypeIsSet(), "keystoreType");
            this.keystoreType = keystoreType.orElse(null);
            this.optBits |= 1L;
            return this;
        }

        public ImmutableIdentityKeyStore build() {
            this.checkRequiredAttributes();
            return new ImmutableIdentityKeyStore(this);
        }

        private boolean keystoreTypeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean pathIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean passwordIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of IdentityKeyStore is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.pathIsSet()) {
                attributes.add("path");
            }
            if (!this.passwordIsSet()) {
                attributes.add("password");
            }
            return "Cannot build IdentityKeyStore, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="IdentityKeyStore", generator="Immutables")
    static final class Json
    extends IdentityKeyStore {
        String path;
        String password;
        Optional<String> keystoreType = Optional.empty();
        boolean keystoreTypeIsSet;

        Json() {
        }

        @JsonProperty(value="path")
        public void setPath(String path) {
            this.path = path;
        }

        @JsonProperty(value="password")
        public void setPassword(String password) {
            this.password = password;
        }

        @JsonProperty(value="keystoreType")
        public void setKeystoreType(Optional<String> keystoreType) {
            this.keystoreType = keystoreType;
            this.keystoreTypeIsSet = true;
        }

        @Override
        public String path() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String password() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> keystoreType() {
            throw new UnsupportedOperationException();
        }
    }
}

