/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.ssl.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.deephaven.ssl.config.Identity;
import io.deephaven.ssl.config.IdentityList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="IdentityList", generator="Immutables")
final class ImmutableIdentityList
extends IdentityList {
    private final List<Identity> values;

    private ImmutableIdentityList(Builder builder) {
        this.values = ImmutableIdentityList.createUnmodifiableList(true, builder.values);
    }

    @Override
    @JsonProperty(value="values")
    public List<Identity> values() {
        return this.values;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIdentityList && this.equalTo(0, (ImmutableIdentityList)another);
    }

    private boolean equalTo(int synthetic, ImmutableIdentityList another) {
        return this.values.equals(another.values);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.values.hashCode();
        return h;
    }

    public String toString() {
        return "IdentityList{values=" + this.values + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIdentityList fromJson(Json json) {
        Builder builder = ImmutableIdentityList.builder();
        if (json.values != null) {
            builder.addAllValues(json.values);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="IdentityList", generator="Immutables")
    public static final class Builder {
        private final List<Identity> values = new ArrayList<Identity>();

        private Builder() {
        }

        public final Builder addValues(Identity element) {
            this.values.add(Objects.requireNonNull(element, "values element"));
            return this;
        }

        public final Builder addValues(Identity ... elements) {
            for (Identity element : elements) {
                this.values.add(Objects.requireNonNull(element, "values element"));
            }
            return this;
        }

        public final Builder addAllValues(Iterable<? extends Identity> elements) {
            for (Identity identity : elements) {
                this.values.add(Objects.requireNonNull(identity, "values element"));
            }
            return this;
        }

        public ImmutableIdentityList build() {
            return new ImmutableIdentityList(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="IdentityList", generator="Immutables")
    static final class Json
    extends IdentityList {
        List<Identity> values = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="values")
        public void setValues(List<Identity> values) {
            this.values = values;
        }

        @Override
        public List<Identity> values() {
            throw new UnsupportedOperationException();
        }
    }
}

