/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.ssl.config;

import io.deephaven.ssl.config.TrustCustom;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="TrustCustom", generator="Immutables")
final class ImmutableTrustCustom
extends TrustCustom {
    private final List<Certificate> certificates;

    private ImmutableTrustCustom(Builder builder) {
        this.certificates = ImmutableTrustCustom.createUnmodifiableList(true, builder.certificates);
    }

    @Override
    public List<Certificate> certificates() {
        return this.certificates;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTrustCustom && this.equalTo(0, (ImmutableTrustCustom)another);
    }

    private boolean equalTo(int synthetic, ImmutableTrustCustom another) {
        return this.certificates.equals(another.certificates);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.certificates.hashCode();
        return h;
    }

    public String toString() {
        return "TrustCustom{certificates=" + this.certificates + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="TrustCustom", generator="Immutables")
    public static final class Builder
    implements TrustCustom.Builder {
        private final List<Certificate> certificates = new ArrayList<Certificate>();

        private Builder() {
        }

        @Override
        public final Builder addCertificates(Certificate element) {
            this.certificates.add(Objects.requireNonNull(element, "certificates element"));
            return this;
        }

        @Override
        public final Builder addCertificates(Certificate ... elements) {
            for (Certificate element : elements) {
                this.certificates.add(Objects.requireNonNull(element, "certificates element"));
            }
            return this;
        }

        @Override
        public final Builder addAllCertificates(Iterable<? extends Certificate> elements) {
            for (Certificate certificate : elements) {
                this.certificates.add(Objects.requireNonNull(certificate, "certificates element"));
            }
            return this;
        }

        @Override
        public ImmutableTrustCustom build() {
            return new ImmutableTrustCustom(this);
        }
    }
}

