/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.ssl.config;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.deephaven.annotations.BuildableStyle;
import io.deephaven.ssl.config.Ciphers;
import io.deephaven.ssl.config.Identity;
import io.deephaven.ssl.config.ImmutableSSLConfig;
import io.deephaven.ssl.config.Parser;
import io.deephaven.ssl.config.Protocols;
import io.deephaven.ssl.config.Trust;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Optional;
import org.immutables.value.Value;

@JsonDeserialize(as=ImmutableSSLConfig.class)
@Value.Immutable(copy=true)
@BuildableStyle
public abstract class SSLConfig {
    public static Builder builder() {
        return ImmutableSSLConfig.builder();
    }

    public static SSLConfig empty() {
        return SSLConfig.builder().build();
    }

    public static SSLConfig parseJson(Path path) throws IOException {
        return Parser.parseJson(path.toFile(), SSLConfig.class);
    }

    public static SSLConfig parseJson(String value) throws IOException {
        return Parser.parseJson(value, SSLConfig.class);
    }

    public static SSLConfig parseJson(URL url) throws IOException {
        return Parser.parseJson(url, SSLConfig.class);
    }

    public abstract Optional<Identity> identity();

    public abstract Optional<Trust> trust();

    public abstract Optional<Protocols> protocols();

    public abstract Optional<Ciphers> ciphers();

    public abstract Optional<ClientAuth> clientAuthentication();

    public abstract SSLConfig withTrust(Trust var1);

    public abstract SSLConfig withProtocols(Protocols var1);

    public abstract SSLConfig withCiphers(Ciphers var1);

    public final SSLConfig orTrust(Trust trust) {
        return this.trust().isPresent() ? this : this.withTrust(trust);
    }

    public final SSLConfig orProtocols(Protocols protocols) {
        return this.protocols().isPresent() ? this : this.withProtocols(protocols);
    }

    public final SSLConfig orCiphers(Ciphers ciphers) {
        return this.ciphers().isPresent() ? this : this.withCiphers(ciphers);
    }

    @Value.Check
    final void checkMutualTLS() {
        if (this.clientAuthentication().orElse(ClientAuth.NONE) != ClientAuth.NONE) {
            if (!this.trust().isPresent()) {
                throw new IllegalArgumentException("Trust material must be present when requesting mutual TLS");
            }
            if (!this.identity().isPresent()) {
                throw new IllegalArgumentException("Identity material must be present when requesting mutual TLS");
            }
        }
    }

    public static interface Builder {
        public Builder identity(Identity var1);

        public Builder trust(Trust var1);

        public Builder protocols(Protocols var1);

        public Builder ciphers(Ciphers var1);

        public Builder clientAuthentication(ClientAuth var1);

        public SSLConfig build();
    }

    public static enum ClientAuth {
        NONE,
        WANTED,
        NEEDED;

    }
}

