/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.ssl.config;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.deephaven.annotations.BuildableStyle;
import io.deephaven.ssl.config.ImmutableTrustCertificates;
import io.deephaven.ssl.config.Trust;
import io.deephaven.ssl.config.TrustBase;
import java.util.List;
import org.immutables.value.Value;

@JsonDeserialize(as=ImmutableTrustCertificates.class)
@Value.Immutable
@BuildableStyle
public abstract class TrustCertificates
extends TrustBase {
    public static TrustCertificates of(String ... path) {
        return ImmutableTrustCertificates.builder().addPath(path).build();
    }

    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    public abstract List<String> path();

    @Override
    public final <T> T walk(Trust.Visitor<T> visitor) {
        return visitor.visit(this);
    }

    @Value.Check
    final void checkPath() {
        if (this.path().isEmpty()) {
            throw new IllegalArgumentException("path must have at least one element");
        }
    }
}

