/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.ssl.config;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.deephaven.annotations.BuildableStyle;
import io.deephaven.ssl.config.ImmutableTrustList;
import io.deephaven.ssl.config.Trust;
import io.deephaven.ssl.config.TrustBase;
import java.util.List;
import org.immutables.value.Value;

@JsonDeserialize(as=ImmutableTrustList.class)
@Value.Immutable
@BuildableStyle
public abstract class TrustList
extends TrustBase {
    public static TrustList of(Trust ... elements) {
        return ImmutableTrustList.builder().addValues(elements).build();
    }

    public static TrustList of(List<? extends Trust> elements) {
        return ImmutableTrustList.builder().addAllValues(elements).build();
    }

    public abstract List<Trust> values();

    @Override
    public final <T> T walk(Trust.Visitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public final boolean contains(Trust trust) {
        return this.values().stream().anyMatch(t -> t.contains(trust));
    }

    @Override
    public final Trust or(Trust other) {
        if (this.contains(other)) {
            return this;
        }
        if (other.contains(this)) {
            return other;
        }
        return ImmutableTrustList.builder().addAllValues(this.values()).addValues(other).build();
    }

    @Value.Check
    final void checkNonEmpty() {
        if (this.values().isEmpty()) {
            throw new IllegalArgumentException("values() must be non-empty");
        }
    }
}

