/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.ssl.config;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.deephaven.annotations.BuildableStyle;
import io.deephaven.ssl.config.Identity;
import io.deephaven.ssl.config.ImmutableIdentityKeyStore;
import java.util.Optional;
import org.immutables.value.Value;

@JsonDeserialize(as=ImmutableIdentityKeyStore.class)
@Value.Immutable
@BuildableStyle
public abstract class IdentityKeyStore
implements Identity {
    public static IdentityKeyStore of(String path, String password) {
        return ImmutableIdentityKeyStore.builder().path(path).password(password).build();
    }

    public static IdentityKeyStore of(String path, String password, String keystoreType) {
        return ImmutableIdentityKeyStore.builder().path(path).password(password).keystoreType(keystoreType).build();
    }

    public abstract String path();

    public abstract String password();

    public abstract Optional<String> keystoreType();

    @Override
    public final <V extends Identity.Visitor<T>, T> T walk(V visitor) {
        return visitor.visit(this);
    }
}

