/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.ssl.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.deephaven.ssl.config.IdentityPrivateKey;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="IdentityPrivateKey", generator="Immutables")
final class ImmutableIdentityPrivateKey
extends IdentityPrivateKey {
    private final String certChainPath;
    private final String privateKeyPath;
    private final String privateKeyPassword;
    private final String alias;

    private ImmutableIdentityPrivateKey(Builder builder) {
        this.certChainPath = builder.certChainPath;
        this.privateKeyPath = builder.privateKeyPath;
        this.privateKeyPassword = builder.privateKeyPassword;
        this.alias = builder.alias;
    }

    @Override
    @JsonProperty(value="certChainPath")
    public String certChainPath() {
        return this.certChainPath;
    }

    @Override
    @JsonProperty(value="privateKeyPath")
    public String privateKeyPath() {
        return this.privateKeyPath;
    }

    @Override
    @JsonProperty(value="privateKeyPassword")
    public Optional<String> privateKeyPassword() {
        return Optional.ofNullable(this.privateKeyPassword);
    }

    @Override
    @JsonProperty(value="alias")
    public Optional<String> alias() {
        return Optional.ofNullable(this.alias);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIdentityPrivateKey && this.equalTo(0, (ImmutableIdentityPrivateKey)another);
    }

    private boolean equalTo(int synthetic, ImmutableIdentityPrivateKey another) {
        return this.certChainPath.equals(another.certChainPath) && this.privateKeyPath.equals(another.privateKeyPath) && Objects.equals(this.privateKeyPassword, another.privateKeyPassword) && Objects.equals(this.alias, another.alias);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.certChainPath.hashCode();
        h += (h << 5) + this.privateKeyPath.hashCode();
        h += (h << 5) + Objects.hashCode(this.privateKeyPassword);
        h += (h << 5) + Objects.hashCode(this.alias);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("IdentityPrivateKey{");
        builder.append("certChainPath=").append(this.certChainPath);
        builder.append(", ");
        builder.append("privateKeyPath=").append(this.privateKeyPath);
        if (this.privateKeyPassword != null) {
            builder.append(", ");
            builder.append("privateKeyPassword=").append(this.privateKeyPassword);
        }
        if (this.alias != null) {
            builder.append(", ");
            builder.append("alias=").append(this.alias);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIdentityPrivateKey fromJson(Json json) {
        Builder builder = ImmutableIdentityPrivateKey.builder();
        if (json.certChainPath != null) {
            builder.certChainPath(json.certChainPath);
        }
        if (json.privateKeyPath != null) {
            builder.privateKeyPath(json.privateKeyPath);
        }
        if (json.privateKeyPasswordIsSet) {
            builder.privateKeyPassword(json.privateKeyPassword);
        }
        if (json.aliasIsSet) {
            builder.alias(json.alias);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IdentityPrivateKey", generator="Immutables")
    public static final class Builder
    implements IdentityPrivateKey.Builder {
        private static final long INIT_BIT_CERT_CHAIN_PATH = 1L;
        private static final long INIT_BIT_PRIVATE_KEY_PATH = 2L;
        private static final long OPT_BIT_PRIVATE_KEY_PASSWORD = 1L;
        private static final long OPT_BIT_ALIAS = 2L;
        private long initBits = 3L;
        private long optBits;
        private String certChainPath;
        private String privateKeyPath;
        private String privateKeyPassword;
        private String alias;

        private Builder() {
        }

        @Override
        @JsonProperty(value="certChainPath")
        public final Builder certChainPath(String certChainPath) {
            Builder.checkNotIsSet(this.certChainPathIsSet(), "certChainPath");
            this.certChainPath = Objects.requireNonNull(certChainPath, "certChainPath");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="privateKeyPath")
        public final Builder privateKeyPath(String privateKeyPath) {
            Builder.checkNotIsSet(this.privateKeyPathIsSet(), "privateKeyPath");
            this.privateKeyPath = Objects.requireNonNull(privateKeyPath, "privateKeyPath");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public final Builder privateKeyPassword(String privateKeyPassword) {
            Builder.checkNotIsSet(this.privateKeyPasswordIsSet(), "privateKeyPassword");
            this.privateKeyPassword = Objects.requireNonNull(privateKeyPassword, "privateKeyPassword");
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="privateKeyPassword")
        public final Builder privateKeyPassword(Optional<String> privateKeyPassword) {
            Builder.checkNotIsSet(this.privateKeyPasswordIsSet(), "privateKeyPassword");
            this.privateKeyPassword = privateKeyPassword.orElse(null);
            this.optBits |= 1L;
            return this;
        }

        @Override
        public final Builder alias(String alias) {
            Builder.checkNotIsSet(this.aliasIsSet(), "alias");
            this.alias = Objects.requireNonNull(alias, "alias");
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="alias")
        public final Builder alias(Optional<String> alias) {
            Builder.checkNotIsSet(this.aliasIsSet(), "alias");
            this.alias = alias.orElse(null);
            this.optBits |= 2L;
            return this;
        }

        @Override
        public ImmutableIdentityPrivateKey build() {
            this.checkRequiredAttributes();
            return new ImmutableIdentityPrivateKey(this);
        }

        private boolean privateKeyPasswordIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean aliasIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean certChainPathIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean privateKeyPathIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of IdentityPrivateKey is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.certChainPathIsSet()) {
                attributes.add("certChainPath");
            }
            if (!this.privateKeyPathIsSet()) {
                attributes.add("privateKeyPath");
            }
            return "Cannot build IdentityPrivateKey, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="IdentityPrivateKey", generator="Immutables")
    static final class Json
    extends IdentityPrivateKey {
        String certChainPath;
        String privateKeyPath;
        Optional<String> privateKeyPassword = Optional.empty();
        boolean privateKeyPasswordIsSet;
        Optional<String> alias = Optional.empty();
        boolean aliasIsSet;

        Json() {
        }

        @JsonProperty(value="certChainPath")
        public void setCertChainPath(String certChainPath) {
            this.certChainPath = certChainPath;
        }

        @JsonProperty(value="privateKeyPath")
        public void setPrivateKeyPath(String privateKeyPath) {
            this.privateKeyPath = privateKeyPath;
        }

        @JsonProperty(value="privateKeyPassword")
        public void setPrivateKeyPassword(Optional<String> privateKeyPassword) {
            this.privateKeyPassword = privateKeyPassword;
            this.privateKeyPasswordIsSet = true;
        }

        @JsonProperty(value="alias")
        public void setAlias(Optional<String> alias) {
            this.alias = alias;
            this.aliasIsSet = true;
        }

        @Override
        public String certChainPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String privateKeyPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> privateKeyPassword() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> alias() {
            throw new UnsupportedOperationException();
        }
    }
}

