/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.ssl.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.deephaven.ssl.config.Ciphers;
import io.deephaven.ssl.config.Identity;
import io.deephaven.ssl.config.Protocols;
import io.deephaven.ssl.config.SSLConfig;
import io.deephaven.ssl.config.Trust;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="SSLConfig", generator="Immutables")
final class ImmutableSSLConfig
extends SSLConfig {
    private final Identity identity;
    private final Trust trust;
    private final Protocols protocols;
    private final Ciphers ciphers;
    private final SSLConfig.ClientAuth clientAuthentication;

    private ImmutableSSLConfig(Identity identity, Trust trust, Protocols protocols, Ciphers ciphers, SSLConfig.ClientAuth clientAuthentication) {
        this.identity = identity;
        this.trust = trust;
        this.protocols = protocols;
        this.ciphers = ciphers;
        this.clientAuthentication = clientAuthentication;
    }

    @Override
    @JsonProperty(value="identity")
    public Optional<Identity> identity() {
        return Optional.ofNullable(this.identity);
    }

    @Override
    @JsonProperty(value="trust")
    public Optional<Trust> trust() {
        return Optional.ofNullable(this.trust);
    }

    @Override
    @JsonProperty(value="protocols")
    public Optional<Protocols> protocols() {
        return Optional.ofNullable(this.protocols);
    }

    @Override
    @JsonProperty(value="ciphers")
    public Optional<Ciphers> ciphers() {
        return Optional.ofNullable(this.ciphers);
    }

    @Override
    @JsonProperty(value="clientAuthentication")
    public Optional<SSLConfig.ClientAuth> clientAuthentication() {
        return Optional.ofNullable(this.clientAuthentication);
    }

    public final ImmutableSSLConfig withIdentity(Identity value) {
        Identity newValue = Objects.requireNonNull(value, "identity");
        if (this.identity == newValue) {
            return this;
        }
        return ImmutableSSLConfig.validate(new ImmutableSSLConfig(newValue, this.trust, this.protocols, this.ciphers, this.clientAuthentication));
    }

    public final ImmutableSSLConfig withIdentity(Optional<? extends Identity> optional) {
        Identity value = optional.orElse(null);
        if (this.identity == value) {
            return this;
        }
        return ImmutableSSLConfig.validate(new ImmutableSSLConfig(value, this.trust, this.protocols, this.ciphers, this.clientAuthentication));
    }

    @Override
    public final ImmutableSSLConfig withTrust(Trust value) {
        Trust newValue = Objects.requireNonNull(value, "trust");
        if (this.trust == newValue) {
            return this;
        }
        return ImmutableSSLConfig.validate(new ImmutableSSLConfig(this.identity, newValue, this.protocols, this.ciphers, this.clientAuthentication));
    }

    public final ImmutableSSLConfig withTrust(Optional<? extends Trust> optional) {
        Trust value = optional.orElse(null);
        if (this.trust == value) {
            return this;
        }
        return ImmutableSSLConfig.validate(new ImmutableSSLConfig(this.identity, value, this.protocols, this.ciphers, this.clientAuthentication));
    }

    @Override
    public final ImmutableSSLConfig withProtocols(Protocols value) {
        Protocols newValue = Objects.requireNonNull(value, "protocols");
        if (this.protocols == newValue) {
            return this;
        }
        return ImmutableSSLConfig.validate(new ImmutableSSLConfig(this.identity, this.trust, newValue, this.ciphers, this.clientAuthentication));
    }

    public final ImmutableSSLConfig withProtocols(Optional<? extends Protocols> optional) {
        Protocols value = optional.orElse(null);
        if (this.protocols == value) {
            return this;
        }
        return ImmutableSSLConfig.validate(new ImmutableSSLConfig(this.identity, this.trust, value, this.ciphers, this.clientAuthentication));
    }

    @Override
    public final ImmutableSSLConfig withCiphers(Ciphers value) {
        Ciphers newValue = Objects.requireNonNull(value, "ciphers");
        if (this.ciphers == newValue) {
            return this;
        }
        return ImmutableSSLConfig.validate(new ImmutableSSLConfig(this.identity, this.trust, this.protocols, newValue, this.clientAuthentication));
    }

    public final ImmutableSSLConfig withCiphers(Optional<? extends Ciphers> optional) {
        Ciphers value = optional.orElse(null);
        if (this.ciphers == value) {
            return this;
        }
        return ImmutableSSLConfig.validate(new ImmutableSSLConfig(this.identity, this.trust, this.protocols, value, this.clientAuthentication));
    }

    public final ImmutableSSLConfig withClientAuthentication(SSLConfig.ClientAuth value) {
        SSLConfig.ClientAuth newValue = Objects.requireNonNull(value, "clientAuthentication");
        if (this.clientAuthentication == newValue) {
            return this;
        }
        return ImmutableSSLConfig.validate(new ImmutableSSLConfig(this.identity, this.trust, this.protocols, this.ciphers, newValue));
    }

    public final ImmutableSSLConfig withClientAuthentication(Optional<? extends SSLConfig.ClientAuth> optional) {
        SSLConfig.ClientAuth value = optional.orElse(null);
        if (this.clientAuthentication == value) {
            return this;
        }
        return ImmutableSSLConfig.validate(new ImmutableSSLConfig(this.identity, this.trust, this.protocols, this.ciphers, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSSLConfig && this.equalTo(0, (ImmutableSSLConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableSSLConfig another) {
        return Objects.equals(this.identity, another.identity) && Objects.equals(this.trust, another.trust) && Objects.equals(this.protocols, another.protocols) && Objects.equals(this.ciphers, another.ciphers) && Objects.equals((Object)this.clientAuthentication, (Object)another.clientAuthentication);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + Objects.hashCode(this.identity);
        h += (h << 5) + Objects.hashCode(this.trust);
        h += (h << 5) + Objects.hashCode(this.protocols);
        h += (h << 5) + Objects.hashCode(this.ciphers);
        h += (h << 5) + Objects.hashCode((Object)this.clientAuthentication);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SSLConfig{");
        if (this.identity != null) {
            builder.append("identity=").append(this.identity);
        }
        if (this.trust != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("trust=").append(this.trust);
        }
        if (this.protocols != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("protocols=").append(this.protocols);
        }
        if (this.ciphers != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("ciphers=").append(this.ciphers);
        }
        if (this.clientAuthentication != null) {
            if (builder.length() > 10) {
                builder.append(", ");
            }
            builder.append("clientAuthentication=").append((Object)this.clientAuthentication);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSSLConfig fromJson(Json json) {
        Builder builder = ImmutableSSLConfig.builder();
        if (json.identityIsSet) {
            builder.identity(json.identity);
        }
        if (json.trustIsSet) {
            builder.trust(json.trust);
        }
        if (json.protocolsIsSet) {
            builder.protocols(json.protocols);
        }
        if (json.ciphersIsSet) {
            builder.ciphers(json.ciphers);
        }
        if (json.clientAuthenticationIsSet) {
            builder.clientAuthentication(json.clientAuthentication);
        }
        return builder.build();
    }

    private static ImmutableSSLConfig validate(ImmutableSSLConfig instance) {
        instance.checkMutualTLS();
        return instance;
    }

    public static ImmutableSSLConfig copyOf(SSLConfig instance) {
        if (instance instanceof ImmutableSSLConfig) {
            return (ImmutableSSLConfig)instance;
        }
        return ImmutableSSLConfig.builder().identity(instance.identity()).trust(instance.trust()).protocols(instance.protocols()).ciphers(instance.ciphers()).clientAuthentication(instance.clientAuthentication()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SSLConfig", generator="Immutables")
    public static final class Builder
    implements SSLConfig.Builder {
        private static final long OPT_BIT_IDENTITY = 1L;
        private static final long OPT_BIT_TRUST = 2L;
        private static final long OPT_BIT_PROTOCOLS = 4L;
        private static final long OPT_BIT_CIPHERS = 8L;
        private static final long OPT_BIT_CLIENT_AUTHENTICATION = 16L;
        private long optBits;
        private Identity identity;
        private Trust trust;
        private Protocols protocols;
        private Ciphers ciphers;
        private SSLConfig.ClientAuth clientAuthentication;

        private Builder() {
        }

        @Override
        public final Builder identity(Identity identity) {
            Builder.checkNotIsSet(this.identityIsSet(), "identity");
            this.identity = Objects.requireNonNull(identity, "identity");
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="identity")
        public final Builder identity(Optional<? extends Identity> identity) {
            Builder.checkNotIsSet(this.identityIsSet(), "identity");
            this.identity = identity.orElse(null);
            this.optBits |= 1L;
            return this;
        }

        @Override
        public final Builder trust(Trust trust) {
            Builder.checkNotIsSet(this.trustIsSet(), "trust");
            this.trust = Objects.requireNonNull(trust, "trust");
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="trust")
        public final Builder trust(Optional<? extends Trust> trust) {
            Builder.checkNotIsSet(this.trustIsSet(), "trust");
            this.trust = trust.orElse(null);
            this.optBits |= 2L;
            return this;
        }

        @Override
        public final Builder protocols(Protocols protocols) {
            Builder.checkNotIsSet(this.protocolsIsSet(), "protocols");
            this.protocols = Objects.requireNonNull(protocols, "protocols");
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="protocols")
        public final Builder protocols(Optional<? extends Protocols> protocols) {
            Builder.checkNotIsSet(this.protocolsIsSet(), "protocols");
            this.protocols = protocols.orElse(null);
            this.optBits |= 4L;
            return this;
        }

        @Override
        public final Builder ciphers(Ciphers ciphers) {
            Builder.checkNotIsSet(this.ciphersIsSet(), "ciphers");
            this.ciphers = Objects.requireNonNull(ciphers, "ciphers");
            this.optBits |= 8L;
            return this;
        }

        @JsonProperty(value="ciphers")
        public final Builder ciphers(Optional<? extends Ciphers> ciphers) {
            Builder.checkNotIsSet(this.ciphersIsSet(), "ciphers");
            this.ciphers = ciphers.orElse(null);
            this.optBits |= 8L;
            return this;
        }

        @Override
        public final Builder clientAuthentication(SSLConfig.ClientAuth clientAuthentication) {
            Builder.checkNotIsSet(this.clientAuthenticationIsSet(), "clientAuthentication");
            this.clientAuthentication = Objects.requireNonNull(clientAuthentication, "clientAuthentication");
            this.optBits |= 0x10L;
            return this;
        }

        @JsonProperty(value="clientAuthentication")
        public final Builder clientAuthentication(Optional<? extends SSLConfig.ClientAuth> clientAuthentication) {
            Builder.checkNotIsSet(this.clientAuthenticationIsSet(), "clientAuthentication");
            this.clientAuthentication = clientAuthentication.orElse(null);
            this.optBits |= 0x10L;
            return this;
        }

        @Override
        public ImmutableSSLConfig build() {
            return ImmutableSSLConfig.validate(new ImmutableSSLConfig(this.identity, this.trust, this.protocols, this.ciphers, this.clientAuthentication));
        }

        private boolean identityIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean trustIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean protocolsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean ciphersIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean clientAuthenticationIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of SSLConfig is strict, attribute is already set: ".concat(name));
            }
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SSLConfig", generator="Immutables")
    static final class Json
    extends SSLConfig {
        Optional<Identity> identity = Optional.empty();
        boolean identityIsSet;
        Optional<Trust> trust = Optional.empty();
        boolean trustIsSet;
        Optional<Protocols> protocols = Optional.empty();
        boolean protocolsIsSet;
        Optional<Ciphers> ciphers = Optional.empty();
        boolean ciphersIsSet;
        Optional<SSLConfig.ClientAuth> clientAuthentication = Optional.empty();
        boolean clientAuthenticationIsSet;

        Json() {
        }

        @JsonProperty(value="identity")
        public void setIdentity(Optional<Identity> identity) {
            this.identity = identity;
            this.identityIsSet = true;
        }

        @JsonProperty(value="trust")
        public void setTrust(Optional<Trust> trust) {
            this.trust = trust;
            this.trustIsSet = true;
        }

        @JsonProperty(value="protocols")
        public void setProtocols(Optional<Protocols> protocols) {
            this.protocols = protocols;
            this.protocolsIsSet = true;
        }

        @JsonProperty(value="ciphers")
        public void setCiphers(Optional<Ciphers> ciphers) {
            this.ciphers = ciphers;
            this.ciphersIsSet = true;
        }

        @JsonProperty(value="clientAuthentication")
        public void setClientAuthentication(Optional<SSLConfig.ClientAuth> clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            this.clientAuthenticationIsSet = true;
        }

        @Override
        public SSLConfig withTrust(Trust trust) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SSLConfig withProtocols(Protocols protocols) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SSLConfig withCiphers(Ciphers ciphers) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Identity> identity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Trust> trust() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Protocols> protocols() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Ciphers> ciphers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SSLConfig.ClientAuth> clientAuthentication() {
            throw new UnsupportedOperationException();
        }
    }
}

