/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.ssl.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.deephaven.ssl.config.Trust;
import io.deephaven.ssl.config.TrustList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="TrustList", generator="Immutables")
final class ImmutableTrustList
extends TrustList {
    private final List<Trust> values;

    private ImmutableTrustList(Builder builder) {
        this.values = ImmutableTrustList.createUnmodifiableList(true, builder.values);
    }

    @Override
    @JsonProperty(value="values")
    public List<Trust> values() {
        return this.values;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTrustList && this.equalTo(0, (ImmutableTrustList)another);
    }

    private boolean equalTo(int synthetic, ImmutableTrustList another) {
        return this.values.equals(another.values);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.values.hashCode();
        return h;
    }

    public String toString() {
        return "TrustList{values=" + this.values + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTrustList fromJson(Json json) {
        Builder builder = ImmutableTrustList.builder();
        if (json.values != null) {
            builder.addAllValues(json.values);
        }
        return builder.build();
    }

    private static ImmutableTrustList validate(ImmutableTrustList instance) {
        instance.checkNonEmpty();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="TrustList", generator="Immutables")
    public static final class Builder {
        private final List<Trust> values = new ArrayList<Trust>();

        private Builder() {
        }

        public final Builder addValues(Trust element) {
            this.values.add(Objects.requireNonNull(element, "values element"));
            return this;
        }

        public final Builder addValues(Trust ... elements) {
            for (Trust element : elements) {
                this.values.add(Objects.requireNonNull(element, "values element"));
            }
            return this;
        }

        public final Builder addAllValues(Iterable<? extends Trust> elements) {
            for (Trust trust : elements) {
                this.values.add(Objects.requireNonNull(trust, "values element"));
            }
            return this;
        }

        public ImmutableTrustList build() {
            return ImmutableTrustList.validate(new ImmutableTrustList(this));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TrustList", generator="Immutables")
    static final class Json
    extends TrustList {
        List<Trust> values = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="values")
        public void setValues(List<Trust> values) {
            this.values = values;
        }

        @Override
        public List<Trust> values() {
            throw new UnsupportedOperationException();
        }
    }
}

