/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.ssl.config;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.ssl.config.ImmutableTrustCustom;
import io.deephaven.ssl.config.Trust;
import io.deephaven.ssl.config.TrustBase;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.List;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class TrustCustom
extends TrustBase {
    private static final String X_509 = "X.509";

    public static Builder builder() {
        return ImmutableTrustCustom.builder();
    }

    public static TrustCustom of(CertificateFactory factory, InputStream in) throws IOException, CertificateException {
        return TrustCustom.builder().addAllCertificates(factory.generateCertificates(in)).build();
    }

    public static TrustCustom of(CertificateFactory factory, Path path) throws IOException, CertificateException {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            TrustCustom trustCustom = TrustCustom.of(factory, in);
            return trustCustom;
        }
    }

    public static TrustCustom of(CertificateFactory factory, byte[] in, int offset, int length) throws IOException, CertificateException {
        return TrustCustom.of(factory, new ByteArrayInputStream(in, offset, length));
    }

    public static TrustCustom ofX509(InputStream in) throws CertificateException, IOException {
        return TrustCustom.of(CertificateFactory.getInstance(X_509), in);
    }

    public static TrustCustom ofX509(Path path) throws CertificateException, IOException {
        return TrustCustom.of(CertificateFactory.getInstance(X_509), path);
    }

    public static TrustCustom ofX509(byte[] in, int offset, int length) throws CertificateException, IOException {
        return TrustCustom.of(CertificateFactory.getInstance(X_509), in, offset, length);
    }

    public abstract List<Certificate> certificates();

    @Override
    public final <T> T walk(Trust.Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public static interface Builder {
        public Builder addCertificates(Certificate var1);

        public Builder addCertificates(Certificate ... var1);

        public Builder addAllCertificates(Iterable<? extends Certificate> var1);

        public TrustCustom build();
    }
}

