/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.ssl.config.impl;

import io.deephaven.ssl.config.Ciphers;
import io.deephaven.ssl.config.CiphersExplicit;
import io.deephaven.ssl.config.CiphersIntermediate;
import io.deephaven.ssl.config.CiphersJdk;
import io.deephaven.ssl.config.CiphersModern;
import io.deephaven.ssl.config.CiphersProperties;
import io.deephaven.ssl.config.Identity;
import io.deephaven.ssl.config.IdentityKeyStore;
import io.deephaven.ssl.config.IdentityList;
import io.deephaven.ssl.config.IdentityPrivateKey;
import io.deephaven.ssl.config.IdentityProperties;
import io.deephaven.ssl.config.Protocols;
import io.deephaven.ssl.config.ProtocolsExplicit;
import io.deephaven.ssl.config.ProtocolsIntermediate;
import io.deephaven.ssl.config.ProtocolsJdk;
import io.deephaven.ssl.config.ProtocolsModern;
import io.deephaven.ssl.config.ProtocolsProperties;
import io.deephaven.ssl.config.SSLConfig;
import io.deephaven.ssl.config.Trust;
import io.deephaven.ssl.config.TrustAll;
import io.deephaven.ssl.config.TrustCertificates;
import io.deephaven.ssl.config.TrustCustom;
import io.deephaven.ssl.config.TrustJdk;
import io.deephaven.ssl.config.TrustList;
import io.deephaven.ssl.config.TrustProperties;
import io.deephaven.ssl.config.TrustStore;
import io.deephaven.ssl.config.TrustSystem;
import io.grpc.util.CertificateUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import nl.altindag.ssl.SSLFactory;
import nl.altindag.ssl.exception.GenericKeyStoreException;

public class KickstartUtils {
    public static SSLFactory create(SSLConfig config) {
        SSLFactory.Builder builder = SSLFactory.builder();
        config.identity().ifPresent(identity -> KickstartUtils.addIdentity(builder, identity));
        config.trust().ifPresent(trust -> KickstartUtils.addTrust(builder, trust));
        config.protocols().ifPresent(protocols -> KickstartUtils.addProtocols(builder, protocols));
        config.ciphers().ifPresent(ciphers -> KickstartUtils.addCiphers(builder, ciphers));
        config.clientAuthentication().ifPresent(clientAuth -> KickstartUtils.addClientAuth(builder, clientAuth));
        return builder.build();
    }

    private static void addTrust(final SSLFactory.Builder builder, Trust config) {
        config.walk((Trust.Visitor)new Trust.Visitor<Void>(){

            public Void visit(TrustStore trustStore) {
                KickstartUtils.addTrust(builder, trustStore);
                return null;
            }

            public Void visit(TrustCertificates certificates) {
                KickstartUtils.addTrust(builder, certificates);
                return null;
            }

            public Void visit(TrustJdk jdk) {
                builder.withDefaultTrustMaterial();
                return null;
            }

            public Void visit(TrustProperties properties) {
                builder.withSystemPropertyDerivedTrustMaterial();
                return null;
            }

            public Void visit(TrustSystem system) {
                builder.withSystemTrustMaterial();
                return null;
            }

            public Void visit(TrustCustom custom) {
                builder.withTrustMaterial(custom.certificates());
                return null;
            }

            public Void visit(TrustAll all) {
                builder.withTrustingAllCertificatesWithoutValidation();
                return null;
            }

            public Void visit(TrustList list) {
                for (Trust trust : list.values()) {
                    KickstartUtils.addTrust(builder, trust);
                }
                return null;
            }
        });
    }

    private static void addTrust(SSLFactory.Builder builder, TrustCertificates config) {
        for (String path : config.path()) {
            try {
                Certificate[] x509Certificates = KickstartUtils.readX509Certificates(Paths.get(path, new String[0]));
                builder.withTrustMaterial(x509Certificates);
            }
            catch (GenericKeyStoreException e) {
                throw new RuntimeException(e.getCause());
            }
            catch (CertificateException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static void addTrust(SSLFactory.Builder builder, TrustStore config) {
        try {
            char[] password = config.password().toCharArray();
            builder.withTrustMaterial(Paths.get(config.path(), new String[0]), password);
        }
        catch (GenericKeyStoreException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private static void addIdentity(final SSLFactory.Builder builder, Identity config) {
        config.walk((Identity.Visitor)new Identity.Visitor<Void>(){

            public Void visit(IdentityKeyStore keyStore) {
                KickstartUtils.addIdentity(builder, keyStore);
                return null;
            }

            public Void visit(IdentityPrivateKey privateKey) {
                KickstartUtils.addIdentity(builder, privateKey);
                return null;
            }

            public Void visit(IdentityProperties properties) {
                builder.withSystemPropertyDerivedIdentityMaterial();
                return null;
            }

            public Void visit(IdentityList list) {
                for (Identity value : list.values()) {
                    KickstartUtils.addIdentity(builder, value);
                }
                return null;
            }
        });
    }

    private static void addCiphers(final SSLFactory.Builder builder, Ciphers ciphers) {
        ciphers.walk((Ciphers.Visitor)new Ciphers.Visitor<Void>(){

            public Void visit(CiphersJdk jdk) {
                return null;
            }

            public Void visit(CiphersModern modern) {
                builder.withCiphers(modern.ciphers().toArray(new String[0]));
                return null;
            }

            public Void visit(CiphersIntermediate intermediate) {
                builder.withCiphers(intermediate.ciphers().toArray(new String[0]));
                return null;
            }

            public Void visit(CiphersProperties properties) {
                builder.withSystemPropertyDerivedCiphers();
                return null;
            }

            public Void visit(CiphersExplicit explicit) {
                builder.withCiphers(explicit.values().toArray(new String[0]));
                return null;
            }
        });
    }

    private static void addProtocols(final SSLFactory.Builder builder, Protocols protocols) {
        protocols.walk((Protocols.Visitor)new Protocols.Visitor<Object>(){

            public Object visit(ProtocolsJdk jdk) {
                return null;
            }

            public Object visit(ProtocolsModern modern) {
                builder.withProtocols(modern.protocols().toArray(new String[0]));
                return null;
            }

            public Object visit(ProtocolsIntermediate intermediate) {
                builder.withProtocols(intermediate.protocols().toArray(new String[0]));
                return null;
            }

            public Object visit(ProtocolsProperties properties) {
                builder.withSystemPropertyDerivedProtocols();
                return null;
            }

            public Object visit(ProtocolsExplicit explicit) {
                builder.withProtocols(explicit.values().toArray(new String[0]));
                return null;
            }
        });
    }

    private static void addClientAuth(SSLFactory.Builder builder, SSLConfig.ClientAuth auth) {
        switch (auth) {
            case NONE: {
                break;
            }
            case WANTED: {
                builder.withWantClientAuthentication();
                break;
            }
            case NEEDED: {
                builder.withNeedClientAuthentication();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected client auth: " + auth);
            }
        }
    }

    private static void addIdentity(SSLFactory.Builder builder, IdentityKeyStore config) {
        char[] password = config.password().toCharArray();
        try {
            if (config.keystoreType().isPresent()) {
                builder.withIdentityMaterial(Paths.get(config.path(), new String[0]), password, (String)config.keystoreType().get());
            } else {
                builder.withIdentityMaterial(Paths.get(config.path(), new String[0]), password);
            }
        }
        catch (GenericKeyStoreException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private static void addIdentity(SSLFactory.Builder builder, IdentityPrivateKey config) {
        try {
            PrivateKey privateKey = KickstartUtils.readPrivateKey(Paths.get(config.privateKeyPath(), new String[0]));
            Certificate[] x509Certificates = KickstartUtils.readX509Certificates(Paths.get(config.certChainPath(), new String[0]));
            char[] password = config.privateKeyPassword().map(String::toCharArray).orElse(null);
            String alias = config.alias().orElse(null);
            builder.withIdentityMaterial((Key)privateKey, password, alias, x509Certificates);
        }
        catch (GenericKeyStoreException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (NoSuchAlgorithmException | CertificateException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static PrivateKey readPrivateKey(Path path) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            PrivateKey privateKey = CertificateUtils.getPrivateKey((InputStream)in);
            return privateKey;
        }
    }

    private static X509Certificate[] readX509Certificates(Path path) throws IOException, CertificateException {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            X509Certificate[] x509CertificateArray = CertificateUtils.getX509Certificates((InputStream)in);
            return x509CertificateArray;
        }
    }
}

