/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.api.ImmutableColumnName;
import io.deephaven.api.JoinAddition;
import io.deephaven.api.JoinMatch;
import io.deephaven.api.Pair;
import io.deephaven.api.Selectable;
import io.deephaven.api.SortColumn;
import io.deephaven.api.expression.Expression;
import io.deephaven.api.util.NameValidator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
public abstract class ColumnName
implements Selectable,
Expression,
Pair,
JoinMatch,
JoinAddition {
    public static boolean isValidParsedColumnName(String value) {
        return NameValidator.isValidColumnName(value.trim());
    }

    public static ColumnName of(String name) {
        return ImmutableColumnName.of(name);
    }

    public static ColumnName parse(String value) {
        return ColumnName.of(value.trim());
    }

    public static List<ColumnName> from(String ... values) {
        return Arrays.stream(values).map(ColumnName::of).collect(Collectors.toList());
    }

    public static List<ColumnName> from(Collection<String> values) {
        return values.stream().map(ColumnName::of).collect(Collectors.toList());
    }

    public static List<String> names(Collection<? extends ColumnName> columns) {
        return columns.stream().map(ColumnName::name).collect(Collectors.toList());
    }

    public static Optional<Collection<ColumnName>> cast(Collection<? extends Selectable> columns) {
        for (Selectable selectable : columns) {
            if (selectable instanceof ColumnName) continue;
            return Optional.empty();
        }
        return Optional.of(columns);
    }

    @Value.Parameter
    public abstract String name();

    public final SortColumn asc() {
        return SortColumn.asc(this);
    }

    public final SortColumn desc() {
        return SortColumn.desc(this);
    }

    @Override
    public final <T> T walk(Expression.Visitor<T> visitor) {
        return visitor.visit(this);
    }

    @Value.Check
    final void checkName() {
        NameValidator.validateColumnName(this.name());
    }

    @Override
    public final ColumnName newColumn() {
        return this;
    }

    @Override
    public final Expression expression() {
        return this;
    }

    @Override
    public final ColumnName input() {
        return this;
    }

    @Override
    public final ColumnName output() {
        return this;
    }

    @Override
    public final ColumnName left() {
        return this;
    }

    @Override
    public final ColumnName right() {
        return this;
    }

    @Override
    public final ColumnName existingColumn() {
        return this;
    }

    public final String toString() {
        return "ColumnName(" + this.name() + ")";
    }
}

