/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.ColumnName;
import io.deephaven.api.ImmutableRangeJoinMatch;
import io.deephaven.api.RangeEndRule;
import io.deephaven.api.RangeStartRule;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class RangeJoinMatch {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\A\\s*(<-)?\\s*([a-zA-Z_$][a-zA-Z0-9_$]*)\\s*(<=?)\\s*([a-zA-Z_$][a-zA-Z0-9_$]*)\\s*(<=?)\\s*([a-zA-Z_$][a-zA-Z0-9_$]*)\\s*(->)?\\s*\\Z");

    public static Builder builder() {
        return ImmutableRangeJoinMatch.builder();
    }

    public static RangeJoinMatch of(ColumnName leftStartColumn, RangeStartRule rangeStartRule, ColumnName rightRangeColumn, RangeEndRule rangeEndRule, ColumnName leftEndColumn) {
        return RangeJoinMatch.builder().leftStartColumn(leftStartColumn).rangeStartRule(rangeStartRule).rightRangeColumn(rightRangeColumn).rangeEndRule(rangeEndRule).leftEndColumn(leftEndColumn).build();
    }

    public static RangeJoinMatch parse(String input) {
        RangeStartRule rangeStartRule;
        boolean allowFollowing;
        Matcher matcher = EXPRESSION_PATTERN.matcher(input);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Input expression %s does not match expected pattern %s", input, EXPRESSION_PATTERN.pattern()));
        }
        boolean allowPreceding = matcher.group(1) != null;
        ColumnName leftStartColumn = ColumnName.of(matcher.group(2));
        boolean startAllowsEqual = matcher.group(3).length() == 2;
        ColumnName rightRangeColumn = ColumnName.of(matcher.group(4));
        boolean endAllowsEqual = matcher.group(5).length() == 2;
        ColumnName leftEndColumn = ColumnName.of(matcher.group(6));
        boolean bl = allowFollowing = matcher.group(7) != null;
        if (allowPreceding && !startAllowsEqual) {
            throw new IllegalArgumentException("Error parsing expression " + input + ": <- operator for \"allow preceding\" may only be combined with <= start match expression");
        }
        RangeStartRule rangeStartRule2 = allowPreceding ? RangeStartRule.LESS_THAN_OR_EQUAL_ALLOW_PRECEDING : (rangeStartRule = startAllowsEqual ? RangeStartRule.LESS_THAN_OR_EQUAL : RangeStartRule.LESS_THAN);
        if (allowFollowing && !endAllowsEqual) {
            throw new IllegalArgumentException("Error parsing expression " + input + ": -> operator for \"allow following\" may only be combined with <= end match expression");
        }
        RangeEndRule rangeEndRule = allowFollowing ? RangeEndRule.GREATER_THAN_OR_EQUAL_ALLOW_FOLLOWING : (endAllowsEqual ? RangeEndRule.GREATER_THAN_OR_EQUAL : RangeEndRule.GREATER_THAN);
        return RangeJoinMatch.of(leftStartColumn, rangeStartRule, rightRangeColumn, rangeEndRule, leftEndColumn);
    }

    public abstract ColumnName leftStartColumn();

    public abstract RangeStartRule rangeStartRule();

    public abstract ColumnName rightRangeColumn();

    public abstract RangeEndRule rangeEndRule();

    public abstract ColumnName leftEndColumn();

    @Value.Check
    public final void checkLeftColumnsDifferent() {
        if (this.leftStartColumn().equals(this.leftEndColumn())) {
            throw new IllegalArgumentException(String.format("RangeJoinMatch must have distinct ColumnNames for leftStartColumn() and leftEndColumn() in order to properly define a range, %s specified for both fields", this.leftStartColumn().name()));
        }
    }

    public static interface Builder {
        public Builder leftStartColumn(ColumnName var1);

        public Builder rangeStartRule(RangeStartRule var1);

        public Builder rightRangeColumn(ColumnName var1);

        public Builder rangeEndRule(RangeEndRule var1);

        public Builder leftEndColumn(ColumnName var1);

        public RangeJoinMatch build();
    }
}

