/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api;

import io.deephaven.api.AsOfJoinMatch;
import io.deephaven.api.ColumnName;
import io.deephaven.api.JoinAddition;
import io.deephaven.api.JoinMatch;
import io.deephaven.api.RangeJoinMatch;
import io.deephaven.api.Selectable;
import io.deephaven.api.SortColumn;
import io.deephaven.api.TableOperations;
import io.deephaven.api.TableOperationsDefaults;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.api.agg.spec.AggSpec;
import io.deephaven.api.filter.Filter;
import io.deephaven.api.snapshot.SnapshotWhenOptions;
import io.deephaven.api.updateby.UpdateByControl;
import io.deephaven.api.updateby.UpdateByOperation;
import java.util.Collection;
import java.util.Objects;

public abstract class TableOperationsAdapter<TOPS_1 extends TableOperations<TOPS_1, TABLE_1>, TABLE_1, TOPS_2 extends TableOperations<TOPS_2, TABLE_2>, TABLE_2>
implements TableOperationsDefaults<TOPS_1, TABLE_1> {
    private final TOPS_2 delegate;

    public TableOperationsAdapter(TOPS_2 delegate) {
        this.delegate = (TableOperations)Objects.requireNonNull(delegate);
    }

    protected abstract TOPS_1 adapt(TOPS_2 var1);

    protected abstract TABLE_2 adapt(TABLE_1 var1);

    public final TOPS_2 delegate() {
        return this.delegate;
    }

    @Override
    public final TOPS_1 head(long size) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.head(size));
    }

    @Override
    public final TOPS_1 tail(long size) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.tail(size));
    }

    @Override
    public final TOPS_1 reverse() {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.reverse());
    }

    @Override
    public final TOPS_1 snapshot() {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.snapshot());
    }

    @Override
    public final TOPS_1 snapshotWhen(TABLE_1 trigger, SnapshotWhenOptions.Flag ... features) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.snapshotWhen(this.adapt(trigger), features));
    }

    @Override
    public final TOPS_1 snapshotWhen(TABLE_1 trigger, Collection<SnapshotWhenOptions.Flag> features, String ... stampColumns) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.snapshotWhen(this.adapt(trigger), features, stampColumns));
    }

    @Override
    public final TOPS_1 snapshotWhen(TABLE_1 trigger, SnapshotWhenOptions options) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.snapshotWhen(this.adapt(trigger), options));
    }

    @Override
    public final TOPS_1 sort(Collection<SortColumn> columnsToSortBy) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.sort(columnsToSortBy));
    }

    @Override
    public final TOPS_1 where(Filter filter) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.where(filter));
    }

    @Override
    public final TOPS_1 whereIn(TABLE_1 rightTable, Collection<? extends JoinMatch> columnsToMatch) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.whereIn(this.adapt(rightTable), columnsToMatch));
    }

    @Override
    public final TOPS_1 whereNotIn(TABLE_1 rightTable, Collection<? extends JoinMatch> columnsToMatch) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.whereNotIn(this.adapt(rightTable), columnsToMatch));
    }

    @Override
    public final TOPS_1 view(Collection<? extends Selectable> columns) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.view(columns));
    }

    @Override
    public final TOPS_1 updateView(Collection<? extends Selectable> columns) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.updateView(columns));
    }

    @Override
    public final TOPS_1 update(Collection<? extends Selectable> columns) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.update(columns));
    }

    @Override
    public final TOPS_1 lazyUpdate(Collection<? extends Selectable> columns) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.lazyUpdate(columns));
    }

    @Override
    public final TOPS_1 select(Collection<? extends Selectable> columns) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.select(columns));
    }

    @Override
    public final TOPS_1 naturalJoin(TABLE_1 rightTable, Collection<? extends JoinMatch> columnsToMatch, Collection<? extends JoinAddition> columnsToAdd) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.naturalJoin(this.adapt(rightTable), columnsToMatch, columnsToAdd));
    }

    @Override
    public final TOPS_1 exactJoin(TABLE_1 rightTable, Collection<? extends JoinMatch> columnsToMatch, Collection<? extends JoinAddition> columnsToAdd) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.exactJoin(this.adapt(rightTable), columnsToMatch, columnsToAdd));
    }

    @Override
    public final TOPS_1 join(TABLE_1 rightTable, Collection<? extends JoinMatch> columnsToMatch, Collection<? extends JoinAddition> columnsToAdd) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.join(this.adapt(rightTable), columnsToMatch, columnsToAdd));
    }

    @Override
    public final TOPS_1 join(TABLE_1 rightTable, Collection<? extends JoinMatch> columnsToMatch, Collection<? extends JoinAddition> columnsToAdd, int reserveBits) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.join(this.adapt(rightTable), columnsToMatch, columnsToAdd, reserveBits));
    }

    @Override
    public final TOPS_1 asOfJoin(TABLE_1 rightTable, Collection<? extends JoinMatch> exactMatches, AsOfJoinMatch asOfMatch, Collection<? extends JoinAddition> columnsToAdd) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.asOfJoin(this.adapt(rightTable), exactMatches, asOfMatch, columnsToAdd));
    }

    @Override
    public final TOPS_1 rangeJoin(TABLE_1 rightTable, Collection<? extends JoinMatch> exactMatches, RangeJoinMatch rangeMatch, Collection<? extends Aggregation> aggregations) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.rangeJoin(this.adapt(rightTable), exactMatches, rangeMatch, aggregations));
    }

    @Override
    public final TOPS_1 aggAllBy(AggSpec spec, ColumnName ... groupByColumns) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.aggAllBy(spec, groupByColumns));
    }

    @Override
    public final TOPS_1 updateBy(UpdateByControl control, Collection<? extends UpdateByOperation> operations, Collection<? extends ColumnName> byColumns) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.updateBy(control, operations, byColumns));
    }

    @Override
    public TOPS_1 aggBy(Collection<? extends Aggregation> aggregations, boolean preserveEmpty, TABLE_1 initialGroups, Collection<? extends ColumnName> groupByColumns) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.aggBy(aggregations, preserveEmpty, initialGroups == null ? null : (Object)this.adapt(initialGroups), groupByColumns));
    }

    @Override
    public final TOPS_1 selectDistinct() {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.selectDistinct());
    }

    @Override
    public final TOPS_1 selectDistinct(Collection<? extends Selectable> columns) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.selectDistinct(columns));
    }

    @Override
    public final TOPS_1 ungroup(boolean nullFill, Collection<? extends ColumnName> columnsToUngroup) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.ungroup(nullFill, columnsToUngroup));
    }

    @Override
    public final TOPS_1 dropColumns(String ... columnNames) {
        return (TOPS_1)this.adapt((TABLE_1)this.delegate.dropColumns(columnNames));
    }
}

