/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api;

import io.deephaven.api.AsOfJoinMatch;
import io.deephaven.api.ColumnName;
import io.deephaven.api.JoinAddition;
import io.deephaven.api.JoinMatch;
import io.deephaven.api.RangeJoinMatch;
import io.deephaven.api.Selectable;
import io.deephaven.api.SortColumn;
import io.deephaven.api.TableOperations;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.api.agg.spec.AggSpec;
import io.deephaven.api.filter.Filter;
import io.deephaven.api.updateby.UpdateByControl;
import io.deephaven.api.updateby.UpdateByOperation;
import io.deephaven.api.util.ConcurrentMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public interface TableOperationsDefaults<TOPS extends TableOperations<TOPS, TABLE>, TABLE>
extends TableOperations<TOPS, TABLE> {
    public static final Filter[] ZERO_LENGTH_FILTER_ARRAY = new Filter[0];
    public static final ColumnName[] ZERO_LENGTH_COLUMNNAME_ARRAY = new ColumnName[0];

    @Override
    @ConcurrentMethod
    default public TOPS sort(String ... columnsToSortBy) {
        return this.sort(Arrays.stream(columnsToSortBy).map(ColumnName::of).map(SortColumn::asc).collect(Collectors.toList()));
    }

    @Override
    @ConcurrentMethod
    default public TOPS sortDescending(String ... columnsToSortBy) {
        return this.sort(Arrays.stream(columnsToSortBy).map(ColumnName::of).map(SortColumn::desc).collect(Collectors.toList()));
    }

    @Override
    @ConcurrentMethod
    default public TOPS where(String ... filters) {
        return this.where(Filter.and(Filter.from(filters)));
    }

    @Override
    default public TOPS whereIn(TABLE rightTable, String ... columnsToMatch) {
        return this.whereIn(rightTable, JoinMatch.from(columnsToMatch));
    }

    @Override
    default public TOPS whereNotIn(TABLE rightTable, String ... columnsToMatch) {
        return this.whereNotIn(rightTable, JoinMatch.from(columnsToMatch));
    }

    @Override
    @ConcurrentMethod
    default public TOPS view(String ... columns) {
        return this.view(Selectable.from(columns));
    }

    @Override
    @ConcurrentMethod
    default public TOPS updateView(String ... columns) {
        return this.updateView(Selectable.from(columns));
    }

    @Override
    default public TOPS update(String ... columns) {
        return this.update(Selectable.from(columns));
    }

    @Override
    default public TOPS lazyUpdate(String ... colummns) {
        return this.lazyUpdate(Selectable.from(colummns));
    }

    @Override
    default public TOPS select() {
        return this.select(Collections.emptyList());
    }

    @Override
    default public TOPS select(String ... columns) {
        return this.select(Selectable.from(columns));
    }

    @Override
    default public TOPS naturalJoin(TABLE rightTable, String columnsToMatch) {
        return this.naturalJoin(rightTable, JoinMatch.from(TableOperationsDefaults.splitToCollection(columnsToMatch)), Collections.emptyList());
    }

    @Override
    default public TOPS naturalJoin(TABLE rightTable, String columnsToMatch, String columnsToAdd) {
        return this.naturalJoin(rightTable, JoinMatch.from(TableOperationsDefaults.splitToCollection(columnsToMatch)), JoinAddition.from(TableOperationsDefaults.splitToCollection(columnsToAdd)));
    }

    @Override
    default public TOPS exactJoin(TABLE rightTable, String columnsToMatch) {
        return this.exactJoin(rightTable, JoinMatch.from(TableOperationsDefaults.splitToCollection(columnsToMatch)), Collections.emptyList());
    }

    @Override
    default public TOPS exactJoin(TABLE rightTable, String columnsToMatch, String columnsToAdd) {
        return this.exactJoin(rightTable, JoinMatch.from(TableOperationsDefaults.splitToCollection(columnsToMatch)), JoinAddition.from(TableOperationsDefaults.splitToCollection(columnsToAdd)));
    }

    @Override
    default public TOPS join(TABLE rightTable) {
        return this.join(rightTable, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    default public TOPS join(TABLE rightTable, String columnsToMatch) {
        return this.join(rightTable, JoinMatch.from(TableOperationsDefaults.splitToCollection(columnsToMatch)), Collections.emptyList());
    }

    @Override
    default public TOPS join(TABLE rightTable, String columnsToMatch, String columnsToAdd) {
        return this.join(rightTable, JoinMatch.from(TableOperationsDefaults.splitToCollection(columnsToMatch)), JoinAddition.from(TableOperationsDefaults.splitToCollection(columnsToAdd)));
    }

    @Override
    default public TOPS aj(TABLE rightTable, String columnsToMatch) {
        List<String> matches = TableOperationsDefaults.splitToList(columnsToMatch);
        return this.asOfJoin(rightTable, JoinMatch.from(matches.subList(0, matches.size() - 1)), AsOfJoinMatch.parseForAj(matches.get(matches.size() - 1)), Collections.emptyList());
    }

    @Override
    default public TOPS aj(TABLE rightTable, String columnsToMatch, String columnsToAdd) {
        List<String> matches = TableOperationsDefaults.splitToList(columnsToMatch);
        return this.asOfJoin(rightTable, JoinMatch.from(matches.subList(0, matches.size() - 1)), AsOfJoinMatch.parseForAj(matches.get(matches.size() - 1)), JoinAddition.from(TableOperationsDefaults.splitToCollection(columnsToAdd)));
    }

    @Override
    default public TOPS raj(TABLE rightTable, String columnsToMatch) {
        List<String> matches = TableOperationsDefaults.splitToList(columnsToMatch);
        return this.asOfJoin(rightTable, JoinMatch.from(matches.subList(0, matches.size() - 1)), AsOfJoinMatch.parseForRaj(matches.get(matches.size() - 1)), Collections.emptyList());
    }

    @Override
    default public TOPS raj(TABLE rightTable, String columnsToMatch, String columnsToAdd) {
        List<String> matches = TableOperationsDefaults.splitToList(columnsToMatch);
        return this.asOfJoin(rightTable, JoinMatch.from(matches.subList(0, matches.size() - 1)), AsOfJoinMatch.parseForRaj(matches.get(matches.size() - 1)), JoinAddition.from(TableOperationsDefaults.splitToCollection(columnsToAdd)));
    }

    @Override
    default public TOPS rangeJoin(TABLE rightTable, Collection<String> columnsToMatch, Collection<? extends Aggregation> aggregations) {
        if (columnsToMatch.isEmpty()) {
            throw new IllegalArgumentException("No match expressions found; must include at least a range match expression");
        }
        Iterator<String> matchExpressions = columnsToMatch.iterator();
        int numExactMatches = columnsToMatch.size() - 1;
        ArrayList<JoinMatch> exactMatches = numExactMatches == 0 ? Collections.emptyList() : new ArrayList<JoinMatch>(numExactMatches);
        for (int emi = 0; emi < numExactMatches; ++emi) {
            exactMatches.add(JoinMatch.parse(matchExpressions.next()));
        }
        RangeJoinMatch rangeMatch = RangeJoinMatch.parse(matchExpressions.next());
        return this.rangeJoin(rightTable, exactMatches, rangeMatch, aggregations);
    }

    @Override
    @ConcurrentMethod
    default public TOPS groupBy() {
        return this.groupBy(Collections.emptyList());
    }

    @Override
    @ConcurrentMethod
    default public TOPS groupBy(String ... groupByColumns) {
        return this.groupBy(ColumnName.from(groupByColumns));
    }

    @Override
    @ConcurrentMethod
    default public TOPS groupBy(Collection<? extends ColumnName> groupByColumns) {
        return this.aggAllBy((AggSpec)AggSpec.group(), groupByColumns.toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    default public TOPS ungroup() {
        return this.ungroup(false, Collections.emptyList());
    }

    @Override
    default public TOPS ungroup(boolean nullFill) {
        return this.ungroup(nullFill, Collections.emptyList());
    }

    @Override
    default public TOPS ungroup(String ... columnsToUngroup) {
        return this.ungroup(false, Arrays.stream(columnsToUngroup).map(ColumnName::of).collect(Collectors.toList()));
    }

    @Override
    default public TOPS ungroup(boolean nullFill, String ... columnsToUngroup) {
        return this.ungroup(nullFill, Arrays.stream(columnsToUngroup).map(ColumnName::of).collect(Collectors.toList()));
    }

    @Override
    @ConcurrentMethod
    default public TOPS aggAllBy(AggSpec spec) {
        return this.aggAllBy(spec, Collections.emptyList());
    }

    @Override
    @ConcurrentMethod
    default public TOPS aggAllBy(AggSpec spec, String ... groupByColumns) {
        return this.aggAllBy(spec, ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS aggAllBy(AggSpec spec, Collection<String> groupByColumns) {
        return this.aggAllBy(spec, ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS aggBy(Aggregation aggregation) {
        return this.aggBy(Collections.singletonList(aggregation));
    }

    @Override
    @ConcurrentMethod
    default public TOPS aggBy(Collection<? extends Aggregation> aggregations) {
        return this.aggBy(aggregations, Collections.emptyList());
    }

    @Override
    @ConcurrentMethod
    default public TOPS aggBy(Collection<? extends Aggregation> aggregations, boolean preserveEmpty) {
        return this.aggBy(aggregations, preserveEmpty, null, Collections.emptyList());
    }

    @Override
    @ConcurrentMethod
    default public TOPS aggBy(Aggregation aggregation, String ... groupByColumns) {
        return this.aggBy(Collections.singletonList(aggregation), groupByColumns);
    }

    @Override
    @ConcurrentMethod
    default public TOPS aggBy(Aggregation aggregation, Collection<? extends ColumnName> groupByColumns) {
        return this.aggBy(Collections.singletonList(aggregation), groupByColumns);
    }

    @Override
    @ConcurrentMethod
    default public TOPS aggBy(Collection<? extends Aggregation> aggregations, String ... groupByColumns) {
        return this.aggBy(aggregations, ColumnName.from(groupByColumns));
    }

    @Override
    @ConcurrentMethod
    default public TOPS aggBy(Collection<? extends Aggregation> aggregations, Collection<? extends ColumnName> groupByColumns) {
        return this.aggBy(aggregations, false, null, groupByColumns);
    }

    @Override
    default public TOPS updateBy(UpdateByOperation operation) {
        return this.updateBy(UpdateByControl.defaultInstance(), Collections.singletonList(operation), Collections.emptyList());
    }

    @Override
    default public TOPS updateBy(UpdateByControl control, UpdateByOperation operation) {
        return this.updateBy(control, Collections.singletonList(operation), Collections.emptyList());
    }

    @Override
    default public TOPS updateBy(Collection<? extends UpdateByOperation> operations) {
        return this.updateBy(UpdateByControl.defaultInstance(), operations, Collections.emptyList());
    }

    @Override
    default public TOPS updateBy(UpdateByControl control, Collection<? extends UpdateByOperation> operations) {
        return this.updateBy(control, operations, Collections.emptyList());
    }

    @Override
    default public TOPS updateBy(UpdateByOperation operation, String ... byColumns) {
        return this.updateBy(UpdateByControl.defaultInstance(), Collections.singletonList(operation), ColumnName.from(byColumns));
    }

    @Override
    default public TOPS updateBy(UpdateByControl control, UpdateByOperation operation, String ... byColumns) {
        return this.updateBy(control, Collections.singletonList(operation), ColumnName.from(byColumns));
    }

    @Override
    default public TOPS updateBy(Collection<? extends UpdateByOperation> operations, String ... byColumns) {
        return this.updateBy(UpdateByControl.defaultInstance(), operations, ColumnName.from(byColumns));
    }

    @Override
    default public TOPS updateBy(Collection<? extends UpdateByOperation> operations, Collection<? extends ColumnName> byColumns) {
        return this.updateBy(UpdateByControl.defaultInstance(), operations, byColumns);
    }

    @Override
    @ConcurrentMethod
    default public TOPS selectDistinct(String ... columns) {
        return this.selectDistinct(Selectable.from(columns));
    }

    @Override
    @ConcurrentMethod
    default public TOPS countBy(String countColumnName) {
        return this.countBy(countColumnName, ZERO_LENGTH_COLUMNNAME_ARRAY);
    }

    @Override
    @ConcurrentMethod
    default public TOPS countBy(String countColumnName, String ... groupByColumns) {
        return this.countBy(countColumnName, ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS countBy(String countColumnName, ColumnName ... groupByColumns) {
        return this.aggBy((Aggregation)Aggregation.AggCount(countColumnName), Arrays.asList(groupByColumns));
    }

    @Override
    @ConcurrentMethod
    default public TOPS countBy(String countColumnName, Collection<String> groupByColumns) {
        return this.countBy(countColumnName, ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS firstBy() {
        return this.firstBy(ZERO_LENGTH_COLUMNNAME_ARRAY);
    }

    @Override
    @ConcurrentMethod
    default public TOPS firstBy(String ... groupByColumns) {
        return this.firstBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS firstBy(ColumnName ... groupByColumns) {
        return this.aggAllBy((AggSpec)AggSpec.first(), groupByColumns);
    }

    @Override
    @ConcurrentMethod
    default public TOPS firstBy(Collection<String> groupByColumns) {
        return this.firstBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS lastBy() {
        return this.lastBy(ZERO_LENGTH_COLUMNNAME_ARRAY);
    }

    @Override
    @ConcurrentMethod
    default public TOPS lastBy(String ... groupByColumns) {
        return this.lastBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS lastBy(ColumnName ... groupByColumns) {
        return this.aggAllBy((AggSpec)AggSpec.last(), groupByColumns);
    }

    @Override
    @ConcurrentMethod
    default public TOPS lastBy(Collection<String> groupByColumns) {
        return this.lastBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS minBy() {
        return this.minBy(ZERO_LENGTH_COLUMNNAME_ARRAY);
    }

    @Override
    @ConcurrentMethod
    default public TOPS minBy(String ... groupByColumns) {
        return this.minBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS minBy(ColumnName ... groupByColumns) {
        return this.aggAllBy((AggSpec)AggSpec.min(), groupByColumns);
    }

    @Override
    @ConcurrentMethod
    default public TOPS minBy(Collection<String> groupByColumns) {
        return this.minBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS maxBy() {
        return this.maxBy(ZERO_LENGTH_COLUMNNAME_ARRAY);
    }

    @Override
    @ConcurrentMethod
    default public TOPS maxBy(String ... groupByColumns) {
        return this.maxBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS maxBy(ColumnName ... groupByColumns) {
        return this.aggAllBy((AggSpec)AggSpec.max(), groupByColumns);
    }

    @Override
    @ConcurrentMethod
    default public TOPS maxBy(Collection<String> groupByColumns) {
        return this.maxBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS sumBy() {
        return this.sumBy(ZERO_LENGTH_COLUMNNAME_ARRAY);
    }

    @Override
    @ConcurrentMethod
    default public TOPS sumBy(String ... groupByColumns) {
        return this.sumBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS sumBy(ColumnName ... groupByColumns) {
        return this.aggAllBy((AggSpec)AggSpec.sum(), groupByColumns);
    }

    @Override
    @ConcurrentMethod
    default public TOPS sumBy(Collection<String> groupByColumns) {
        return this.sumBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS avgBy() {
        return this.avgBy(ZERO_LENGTH_COLUMNNAME_ARRAY);
    }

    @Override
    @ConcurrentMethod
    default public TOPS avgBy(String ... groupByColumns) {
        return this.avgBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS avgBy(ColumnName ... groupByColumns) {
        return this.aggAllBy((AggSpec)AggSpec.avg(), groupByColumns);
    }

    @Override
    @ConcurrentMethod
    default public TOPS avgBy(Collection<String> groupByColumns) {
        return this.avgBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS medianBy() {
        return this.medianBy(ZERO_LENGTH_COLUMNNAME_ARRAY);
    }

    @Override
    @ConcurrentMethod
    default public TOPS medianBy(String ... groupByColumns) {
        return this.medianBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS medianBy(ColumnName ... groupByColumns) {
        return this.aggAllBy((AggSpec)AggSpec.median(), groupByColumns);
    }

    @Override
    @ConcurrentMethod
    default public TOPS medianBy(Collection<String> groupByColumns) {
        return this.medianBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS stdBy() {
        return this.stdBy(ZERO_LENGTH_COLUMNNAME_ARRAY);
    }

    @Override
    @ConcurrentMethod
    default public TOPS stdBy(String ... groupByColumns) {
        return this.stdBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS stdBy(ColumnName ... groupByColumns) {
        return this.aggAllBy((AggSpec)AggSpec.std(), groupByColumns);
    }

    @Override
    @ConcurrentMethod
    default public TOPS stdBy(Collection<String> groupByColumns) {
        return this.stdBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS varBy() {
        return this.varBy(ZERO_LENGTH_COLUMNNAME_ARRAY);
    }

    @Override
    @ConcurrentMethod
    default public TOPS varBy(String ... groupByColumns) {
        return this.varBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS varBy(ColumnName ... groupByColumns) {
        return this.aggAllBy((AggSpec)AggSpec.var(), groupByColumns);
    }

    @Override
    @ConcurrentMethod
    default public TOPS varBy(Collection<String> groupByColumns) {
        return this.varBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS absSumBy() {
        return this.absSumBy(ZERO_LENGTH_COLUMNNAME_ARRAY);
    }

    @Override
    @ConcurrentMethod
    default public TOPS absSumBy(String ... groupByColumns) {
        return this.absSumBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS absSumBy(ColumnName ... groupByColumns) {
        return this.aggAllBy((AggSpec)AggSpec.absSum(), groupByColumns);
    }

    @Override
    @ConcurrentMethod
    default public TOPS absSumBy(Collection<String> groupByColumns) {
        return this.absSumBy(ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS wsumBy(String weightColumn) {
        return this.wsumBy(weightColumn, ZERO_LENGTH_COLUMNNAME_ARRAY);
    }

    @Override
    @ConcurrentMethod
    default public TOPS wsumBy(String weightColumn, String ... groupByColumns) {
        return this.wsumBy(weightColumn, ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS wsumBy(String weightColumn, ColumnName ... groupByColumns) {
        return this.aggAllBy((AggSpec)AggSpec.wsum(weightColumn), groupByColumns);
    }

    @Override
    @ConcurrentMethod
    default public TOPS wsumBy(String weightColumn, Collection<String> groupByColumns) {
        return this.wsumBy(weightColumn, ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS wavgBy(String weightColumn) {
        return this.wavgBy(weightColumn, ZERO_LENGTH_COLUMNNAME_ARRAY);
    }

    @Override
    @ConcurrentMethod
    default public TOPS wavgBy(String weightColumn, String ... groupByColumns) {
        return this.wavgBy(weightColumn, ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS wavgBy(String weightColumn, ColumnName ... groupByColumns) {
        return this.aggAllBy((AggSpec)AggSpec.wavg(weightColumn), groupByColumns);
    }

    @Override
    @ConcurrentMethod
    default public TOPS wavgBy(String weightColumn, Collection<String> groupByColumns) {
        return this.wavgBy(weightColumn, ColumnName.from(groupByColumns).toArray(ZERO_LENGTH_COLUMNNAME_ARRAY));
    }

    @Override
    @ConcurrentMethod
    default public TOPS dropColumns(Collection<String> columnNames) {
        return this.dropColumns(columnNames.toArray(new String[0]));
    }

    @Override
    @ConcurrentMethod
    default public TOPS dropColumns(ColumnName ... columnNames) {
        return this.dropColumns((String[])Arrays.stream(columnNames).map(ColumnName::name).toArray(String[]::new));
    }

    public static Collection<String> splitToCollection(String string) {
        return TableOperationsDefaults.splitToList(string);
    }

    public static List<String> splitToList(String string) {
        return string.trim().isEmpty() ? Collections.emptyList() : Arrays.stream(string.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }
}

