/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg;

import io.deephaven.api.ColumnName;
import io.deephaven.api.Pair;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.api.agg.Aggregations;
import io.deephaven.api.agg.ColumnAggregation;
import io.deephaven.api.agg.ColumnAggregations;
import io.deephaven.api.agg.Count;
import io.deephaven.api.agg.FirstRowKey;
import io.deephaven.api.agg.LastRowKey;
import io.deephaven.api.agg.Partition;
import io.deephaven.api.agg.spec.AggSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AggregationOptimizer
implements Aggregation.Visitor {
    private static final Object COUNT_OBJ = new Object();
    private static final Object FIRST_ROW_KEY_OBJ = new Object();
    private static final Object LAST_ROW_KEY_OBJ = new Object();
    private static final Object PARTITION_KEEPING_OBJ = new Object();
    private static final Object PARTITION_DROPPING_OBJ = new Object();
    private final LinkedHashMap<Object, List<Pair>> visitOrder = new LinkedHashMap();

    public static List<Aggregation> of(Collection<? extends Aggregation> aggregations) {
        AggregationOptimizer optimizer = new AggregationOptimizer();
        for (Aggregation aggregation : aggregations) {
            aggregation.walk(optimizer);
        }
        return optimizer.build();
    }

    public List<Aggregation> build() {
        ArrayList<Aggregation> out = new ArrayList<Aggregation>();
        for (Map.Entry<Object, List<Pair>> e : this.visitOrder.entrySet()) {
            if (e.getKey() == COUNT_OBJ) {
                for (Pair pair : e.getValue()) {
                    out.add(Count.of((ColumnName)pair));
                }
                continue;
            }
            if (e.getKey() == FIRST_ROW_KEY_OBJ) {
                for (Pair pair : e.getValue()) {
                    out.add(FirstRowKey.of((ColumnName)pair));
                }
                continue;
            }
            if (e.getKey() == LAST_ROW_KEY_OBJ) {
                for (Pair pair : e.getValue()) {
                    out.add(LastRowKey.of((ColumnName)pair));
                }
                continue;
            }
            if (e.getKey() == PARTITION_KEEPING_OBJ) {
                for (Pair pair : e.getValue()) {
                    out.add(Partition.of((ColumnName)pair));
                }
                continue;
            }
            if (e.getKey() == PARTITION_DROPPING_OBJ) {
                for (Pair pair : e.getValue()) {
                    out.add(Partition.of((ColumnName)pair, false));
                }
                continue;
            }
            if (e.getValue() == null) {
                out.add((Aggregation)e.getKey());
                continue;
            }
            if (e.getValue().size() == 1) {
                out.add(ColumnAggregation.of((AggSpec)e.getKey(), e.getValue().get(0)));
                continue;
            }
            out.add(ColumnAggregations.builder().spec((AggSpec)e.getKey()).addAllPairs((Iterable<? extends Pair>)e.getValue()).build());
        }
        return out;
    }

    @Override
    public void visit(Aggregations aggregations) {
        aggregations.aggregations().forEach(a -> a.walk(this));
    }

    @Override
    public void visit(ColumnAggregation columnAgg) {
        this.visitOrder.computeIfAbsent(columnAgg.spec(), k -> new ArrayList()).add(columnAgg.pair());
    }

    @Override
    public void visit(ColumnAggregations columnAggs) {
        this.visitOrder.computeIfAbsent(columnAggs.spec(), k -> new ArrayList()).addAll(columnAggs.pairs());
    }

    @Override
    public void visit(Count count) {
        this.visitOrder.computeIfAbsent(COUNT_OBJ, k -> new ArrayList()).add(count.column());
    }

    @Override
    public void visit(FirstRowKey firstRowKey) {
        this.visitOrder.computeIfAbsent(FIRST_ROW_KEY_OBJ, k -> new ArrayList()).add(firstRowKey.column());
    }

    @Override
    public void visit(LastRowKey lastRowKey) {
        this.visitOrder.computeIfAbsent(LAST_ROW_KEY_OBJ, k -> new ArrayList()).add(lastRowKey.column());
    }

    @Override
    public void visit(Partition partition) {
        this.visitOrder.computeIfAbsent(partition.includeGroupByColumns() ? PARTITION_KEEPING_OBJ : PARTITION_DROPPING_OBJ, k -> new ArrayList()).add(partition.column());
    }
}

