/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg;

import io.deephaven.api.Pair;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.api.agg.Aggregations;
import io.deephaven.api.agg.ColumnAggregation;
import io.deephaven.api.agg.ColumnAggregations;
import io.deephaven.api.agg.Count;
import io.deephaven.api.agg.FirstRowKey;
import io.deephaven.api.agg.LastRowKey;
import io.deephaven.api.agg.Partition;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;

public class AggregationPairs
implements Aggregation.Visitor {
    protected Stream<Pair> out;

    public static Stream<Pair> of(Aggregation aggregation) {
        return aggregation.walk(new AggregationPairs()).getOut();
    }

    public static Stream<Pair> of(Collection<? extends Aggregation> aggregations) {
        return aggregations.stream().flatMap(AggregationPairs::of);
    }

    protected Stream<Pair> getOut() {
        return Objects.requireNonNull(this.out);
    }

    @Override
    public void visit(Aggregations aggregations) {
        this.out = aggregations.aggregations().stream().flatMap(AggregationPairs::of);
    }

    @Override
    public void visit(ColumnAggregation columnAgg) {
        this.out = Stream.of(columnAgg.pair());
    }

    @Override
    public void visit(ColumnAggregations columnAggs) {
        this.out = columnAggs.pairs().stream();
    }

    @Override
    public void visit(Count count) {
        this.out = Stream.empty();
    }

    @Override
    public void visit(FirstRowKey firstRowKey) {
        this.out = Stream.empty();
    }

    @Override
    public void visit(LastRowKey lastRowKey) {
        this.out = Stream.empty();
    }

    @Override
    public void visit(Partition partition) {
        this.out = Stream.empty();
    }
}

