/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg.spec;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.api.agg.spec.AggSpec;
import io.deephaven.api.agg.spec.AggSpecBase;
import io.deephaven.api.agg.spec.ImmutableAggSpecTDigest;
import java.util.OptionalDouble;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
public abstract class AggSpecTDigest
extends AggSpecBase {
    public static AggSpecTDigest of() {
        return ImmutableAggSpecTDigest.of(OptionalDouble.empty());
    }

    public static AggSpecTDigest of(double compression) {
        return ImmutableAggSpecTDigest.of(OptionalDouble.of(compression));
    }

    @Override
    public final String description() {
        if (this.compression().isPresent()) {
            return String.format("TDigest with compression %.2f", this.compression().getAsDouble());
        }
        return "TDigest with default compression";
    }

    @Value.Parameter
    public abstract OptionalDouble compression();

    @Override
    public final <V extends AggSpec.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    @Value.Check
    final void checkCompression() {
        if (this.compression().isPresent() && this.compression().getAsDouble() < 1.0) {
            throw new IllegalArgumentException("Compression must be greater than or equal to 1.0");
        }
    }
}

