/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.agg.spec;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.agg.spec.AggSpec;
import io.deephaven.api.agg.spec.AggSpecBase;
import io.deephaven.api.agg.spec.ImmutableAggSpecUnique;
import io.deephaven.api.object.UnionObject;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class AggSpecUnique
extends AggSpecBase {
    public static final boolean INCLUDE_NULLS_DEFAULT = false;

    public static AggSpecUnique of() {
        return ImmutableAggSpecUnique.builder().build();
    }

    public static AggSpecUnique of(boolean includeNulls, Object nonUniqueSentinel) {
        return AggSpecUnique.of(includeNulls, UnionObject.from(nonUniqueSentinel));
    }

    public static AggSpecUnique of(boolean includeNulls, UnionObject nonUniqueSentinel) {
        ImmutableAggSpecUnique.Builder builder = ImmutableAggSpecUnique.builder().includeNulls(includeNulls);
        if (nonUniqueSentinel != null) {
            builder.nonUniqueSentinel(nonUniqueSentinel);
        }
        return builder.build();
    }

    @Override
    public final String description() {
        return "unique" + (this.includeNulls() ? " (including nulls)" : " (excluding nulls)");
    }

    @Value.Default
    public boolean includeNulls() {
        return false;
    }

    public abstract Optional<UnionObject> nonUniqueSentinel();

    @Override
    public final <V extends AggSpec.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }
}

