/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.expression;

import io.deephaven.api.expression.ExpressionException;
import io.deephaven.api.expression.ExpressionFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpressionParser<TYPE> {
    private final Map<Pattern, ExpressionFactory<TYPE>> expressions = new LinkedHashMap<Pattern, ExpressionFactory<TYPE>>();

    public TYPE parse(String expression, Object ... args) {
        Throwable creationException = null;
        for (Map.Entry<Pattern, ExpressionFactory<TYPE>> patternExpressionFactoryEntry : this.expressions.entrySet()) {
            Matcher matcher = patternExpressionFactoryEntry.getKey().matcher(expression);
            if (!matcher.matches()) continue;
            try {
                return patternExpressionFactoryEntry.getValue().getExpression(expression, matcher, args);
            }
            catch (Throwable t) {
                if (creationException != null) continue;
                creationException = t;
            }
        }
        if (creationException == null) {
            throw new ExpressionException("Unable to parse expression: \"" + expression + "\"", expression);
        }
        throw new ExpressionException("Failed to get expression for all matched patterns", creationException, expression);
    }

    public void registerFactory(ExpressionFactory<TYPE> expressionFactory) {
        this.expressions.put(Pattern.compile(expressionFactory.getPattern()), expressionFactory);
    }
}

