/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.filter;

import io.deephaven.api.RawString;
import io.deephaven.api.expression.Expression;
import io.deephaven.api.expression.Function;
import io.deephaven.api.expression.Method;
import io.deephaven.api.filter.ExtractAnds;
import io.deephaven.api.filter.FilterAnd;
import io.deephaven.api.filter.FilterComparison;
import io.deephaven.api.filter.FilterIn;
import io.deephaven.api.filter.FilterIsNull;
import io.deephaven.api.filter.FilterNot;
import io.deephaven.api.filter.FilterOr;
import io.deephaven.api.filter.FilterPattern;
import io.deephaven.api.literal.Literal;
import io.deephaven.api.literal.LiteralFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

public interface Filter
extends Expression {
    public static Collection<? extends Filter> from(String ... expressions) {
        return Filter.from(Arrays.asList(expressions));
    }

    public static Collection<? extends Filter> from(Collection<String> expressions) {
        return expressions.stream().map(RawString::of).collect(Collectors.toList());
    }

    public static LiteralFilter ofTrue() {
        return Literal.of(true);
    }

    public static LiteralFilter ofFalse() {
        return Literal.of(false);
    }

    public static FilterIsNull isNull(Expression expression) {
        return FilterIsNull.of(expression);
    }

    public static FilterNot<FilterIsNull> isNotNull(Expression expression) {
        return Filter.not(Filter.isNull(expression));
    }

    public static FilterComparison isTrue(Expression expression) {
        return FilterComparison.eq(expression, Filter.ofTrue());
    }

    public static FilterComparison isFalse(Expression expression) {
        return FilterComparison.eq(expression, Filter.ofFalse());
    }

    public static <F extends Filter> FilterNot<F> not(F filter) {
        return FilterNot.of(filter);
    }

    public static Filter or(Filter ... filters) {
        return Filter.or(Arrays.asList(filters));
    }

    public static Filter or(Collection<? extends Filter> filters) {
        if (filters.isEmpty()) {
            return Filter.ofFalse();
        }
        if (filters.size() == 1) {
            return filters.iterator().next();
        }
        return FilterOr.of(filters);
    }

    public static Filter and(Filter ... filters) {
        return Filter.and(Arrays.asList(filters));
    }

    public static Filter and(Collection<? extends Filter> filters) {
        if (filters.isEmpty()) {
            return Filter.ofTrue();
        }
        if (filters.size() == 1) {
            return filters.iterator().next();
        }
        return FilterAnd.of(filters);
    }

    public static Collection<Filter> extractAnds(Filter filter) {
        return ExtractAnds.of(filter);
    }

    public Filter invert();

    public <T> T walk(Visitor<T> var1);

    public static interface Visitor<T> {
        public T visit(FilterIsNull var1);

        public T visit(FilterComparison var1);

        public T visit(FilterIn var1);

        public T visit(FilterNot<?> var1);

        public T visit(FilterOr var1);

        public T visit(FilterAnd var1);

        public T visit(FilterPattern var1);

        public T visit(Function var1);

        public T visit(Method var1);

        public T visit(boolean var1);

        public T visit(RawString var1);
    }
}

