/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.filter;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.expression.Expression;
import io.deephaven.api.filter.Filter;
import io.deephaven.api.filter.FilterBase;
import io.deephaven.api.filter.FilterComparison;
import io.deephaven.api.filter.FilterNot;
import io.deephaven.api.filter.ImmutableFilterIn;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class FilterIn
extends FilterBase {
    public static Builder builder() {
        return ImmutableFilterIn.builder();
    }

    public static FilterIn of(Expression expression, List<Expression> values) {
        return FilterIn.builder().expression(expression).addAllValues(values).build();
    }

    public static FilterIn of(Expression expression, Expression ... values) {
        return FilterIn.builder().expression(expression).addValues(values).build();
    }

    public abstract Expression expression();

    public abstract List<Expression> values();

    @Override
    public final FilterNot<FilterIn> invert() {
        return FilterNot.of(this);
    }

    @Override
    public final <T> T walk(Filter.Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public final Filter asComparisons() {
        return Filter.or(this.values().stream().map(this::expEq).collect(Collectors.toList()));
    }

    public final FilterComparison asEquals() {
        if (this.values().size() != 1) {
            throw new IllegalArgumentException("Must only call this when values().size() == 1");
        }
        return this.expEq(this.values().get(0));
    }

    @Value.Check
    final void checkNotEmpty() {
        if (this.values().isEmpty()) {
            throw new IllegalArgumentException("FilterIn.values() must be non-empty");
        }
    }

    private FilterComparison expEq(Expression rhs) {
        return FilterComparison.eq(this.expression(), rhs);
    }

    private FilterComparison expNeq(Expression rhs) {
        return FilterComparison.neq(this.expression(), rhs);
    }

    public static interface Builder {
        public Builder expression(Expression var1);

        public Builder addValues(Expression var1);

        public Builder addValues(Expression ... var1);

        public Builder addAllValues(Iterable<? extends Expression> var1);

        public FilterIn build();
    }
}

