/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.filter;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.expression.Expression;
import io.deephaven.api.filter.Filter;
import io.deephaven.api.filter.FilterBase;
import io.deephaven.api.filter.FilterNot;
import io.deephaven.api.filter.ImmutableFilterPattern;
import java.util.regex.Pattern;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class FilterPattern
extends FilterBase {
    public static Builder builder() {
        return ImmutableFilterPattern.builder();
    }

    public static FilterPattern of(Expression expression, Pattern pattern, Mode mode, boolean invertPattern) {
        return FilterPattern.builder().expression(expression).pattern(pattern).mode(mode).invertPattern(invertPattern).build();
    }

    public abstract Expression expression();

    public abstract Pattern pattern();

    public abstract Mode mode();

    @Value.Default
    public boolean invertPattern() {
        return false;
    }

    @Override
    public final FilterNot<FilterPattern> invert() {
        return Filter.not(this);
    }

    @Override
    public final <T> T walk(Filter.Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public final String toString() {
        return "FilterPattern(" + this.expression() + ", " + this.pattern().pattern() + ", " + this.pattern().flags() + ", " + (Object)((Object)this.mode()) + ", " + this.invertPattern() + ")";
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterPattern)) {
            return false;
        }
        FilterPattern other = (FilterPattern)obj;
        return this.mode() == other.mode() && this.invertPattern() == other.invertPattern() && this.pattern().flags() == other.pattern().flags() && this.pattern().pattern().equals(other.pattern().pattern()) && this.expression().equals(other.expression());
    }

    public final int hashCode() {
        int h = 5381;
        h += (h << 5) + this.expression().hashCode();
        h += (h << 5) + this.pattern().pattern().hashCode();
        h += (h << 5) + Integer.hashCode(this.pattern().flags());
        h += (h << 5) + this.mode().hashCode();
        h += (h << 5) + Boolean.hashCode(this.invertPattern());
        return h;
    }

    public static interface Builder {
        public Builder expression(Expression var1);

        public Builder pattern(Pattern var1);

        public Builder mode(Mode var1);

        public Builder invertPattern(boolean var1);

        public FilterPattern build();
    }

    public static enum Mode {
        FIND,
        MATCHES;

    }
}

